/*
 * Microcks API v1.10
 * API offered by Microcks, the Kubernetes native tool for API and microservices mocking and testing (microcks.io)
 *
 * The version of the OpenAPI document: 1.10.1
 * Contact: laurent@microcks.io
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.github.microcks.client.model;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.StringJoiner;
import java.util.Objects;
import java.util.Map;
import java.util.HashMap;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;


import io.github.microcks.client.ApiClient;
/**
 * The daily statistic of a service mock invocations
 */
@JsonPropertyOrder({
  DailyInvocationStatistic.JSON_PROPERTY_ID,
  DailyInvocationStatistic.JSON_PROPERTY_DAY,
  DailyInvocationStatistic.JSON_PROPERTY_SERVICE_NAME,
  DailyInvocationStatistic.JSON_PROPERTY_SERVICE_VERSION,
  DailyInvocationStatistic.JSON_PROPERTY_DAILY_COUNT,
  DailyInvocationStatistic.JSON_PROPERTY_HOURLY_COUNT,
  DailyInvocationStatistic.JSON_PROPERTY_MINUTE_COUNT
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-01-06T15:57:00.387475551Z[Etc/UTC]", comments = "Generator version: 7.7.0")
public class DailyInvocationStatistic {
  public static final String JSON_PROPERTY_ID = "id";
  private String id;

  public static final String JSON_PROPERTY_DAY = "day";
  private String day;

  public static final String JSON_PROPERTY_SERVICE_NAME = "serviceName";
  private String serviceName;

  public static final String JSON_PROPERTY_SERVICE_VERSION = "serviceVersion";
  private String serviceVersion;

  public static final String JSON_PROPERTY_DAILY_COUNT = "dailyCount";
  private BigDecimal dailyCount;

  public static final String JSON_PROPERTY_HOURLY_COUNT = "hourlyCount";
  private Map<String, Object> hourlyCount = new HashMap<>();

  public static final String JSON_PROPERTY_MINUTE_COUNT = "minuteCount";
  private Map<String, Object> minuteCount = new HashMap<>();

  public DailyInvocationStatistic() { 
  }

  public DailyInvocationStatistic id(String id) {
    this.id = id;
    return this;
  }

  /**
   * Unique identifier of this statistic object
   * @return id
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public String getId() {
    return id;
  }


  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setId(String id) {
    this.id = id;
  }


  public DailyInvocationStatistic day(String day) {
    this.day = day;
    return this;
  }

  /**
   * The day (formatted as yyyyMMdd string) represented by this statistic
   * @return day
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_DAY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public String getDay() {
    return day;
  }


  @JsonProperty(JSON_PROPERTY_DAY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setDay(String day) {
    this.day = day;
  }


  public DailyInvocationStatistic serviceName(String serviceName) {
    this.serviceName = serviceName;
    return this;
  }

  /**
   * The name of the service this statistic is related to
   * @return serviceName
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_SERVICE_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public String getServiceName() {
    return serviceName;
  }


  @JsonProperty(JSON_PROPERTY_SERVICE_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setServiceName(String serviceName) {
    this.serviceName = serviceName;
  }


  public DailyInvocationStatistic serviceVersion(String serviceVersion) {
    this.serviceVersion = serviceVersion;
    return this;
  }

  /**
   * The version of the service this statistic is related to
   * @return serviceVersion
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_SERVICE_VERSION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public String getServiceVersion() {
    return serviceVersion;
  }


  @JsonProperty(JSON_PROPERTY_SERVICE_VERSION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setServiceVersion(String serviceVersion) {
    this.serviceVersion = serviceVersion;
  }


  public DailyInvocationStatistic dailyCount(BigDecimal dailyCount) {
    this.dailyCount = dailyCount;
    return this;
  }

  /**
   * The number of service mock invocations on this day
   * @return dailyCount
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_DAILY_COUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public BigDecimal getDailyCount() {
    return dailyCount;
  }


  @JsonProperty(JSON_PROPERTY_DAILY_COUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setDailyCount(BigDecimal dailyCount) {
    this.dailyCount = dailyCount;
  }


  public DailyInvocationStatistic hourlyCount(Map<String, Object> hourlyCount) {
    this.hourlyCount = hourlyCount;
    return this;
  }

  public DailyInvocationStatistic putHourlyCountItem(String key, Object hourlyCountItem) {
    if (this.hourlyCount == null) {
      this.hourlyCount = new HashMap<>();
    }
    this.hourlyCount.put(key, hourlyCountItem);
    return this;
  }

  /**
   * The number of service mock invocations per hour of the day (keys range from 0 to 23)
   * @return hourlyCount
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_HOURLY_COUNT)
  @JsonInclude(content = JsonInclude.Include.ALWAYS, value = JsonInclude.Include.USE_DEFAULTS)
  public Map<String, Object> getHourlyCount() {
    return hourlyCount;
  }


  @JsonProperty(JSON_PROPERTY_HOURLY_COUNT)
  @JsonInclude(content = JsonInclude.Include.ALWAYS, value = JsonInclude.Include.USE_DEFAULTS)
  public void setHourlyCount(Map<String, Object> hourlyCount) {
    this.hourlyCount = hourlyCount;
  }


  public DailyInvocationStatistic minuteCount(Map<String, Object> minuteCount) {
    this.minuteCount = minuteCount;
    return this;
  }

  public DailyInvocationStatistic putMinuteCountItem(String key, Object minuteCountItem) {
    if (this.minuteCount == null) {
      this.minuteCount = new HashMap<>();
    }
    this.minuteCount.put(key, minuteCountItem);
    return this;
  }

  /**
   * The number of service mock invocations per minute of the day (keys range from 0 to 1439)
   * @return minuteCount
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_MINUTE_COUNT)
  @JsonInclude(content = JsonInclude.Include.ALWAYS, value = JsonInclude.Include.USE_DEFAULTS)
  public Map<String, Object> getMinuteCount() {
    return minuteCount;
  }


  @JsonProperty(JSON_PROPERTY_MINUTE_COUNT)
  @JsonInclude(content = JsonInclude.Include.ALWAYS, value = JsonInclude.Include.USE_DEFAULTS)
  public void setMinuteCount(Map<String, Object> minuteCount) {
    this.minuteCount = minuteCount;
  }


  /**
   * Return true if this DailyInvocationStatistic object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    DailyInvocationStatistic dailyInvocationStatistic = (DailyInvocationStatistic) o;
    return Objects.equals(this.id, dailyInvocationStatistic.id) &&
        Objects.equals(this.day, dailyInvocationStatistic.day) &&
        Objects.equals(this.serviceName, dailyInvocationStatistic.serviceName) &&
        Objects.equals(this.serviceVersion, dailyInvocationStatistic.serviceVersion) &&
        Objects.equals(this.dailyCount, dailyInvocationStatistic.dailyCount) &&
        Objects.equals(this.hourlyCount, dailyInvocationStatistic.hourlyCount) &&
        Objects.equals(this.minuteCount, dailyInvocationStatistic.minuteCount);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, day, serviceName, serviceVersion, dailyCount, hourlyCount, minuteCount);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class DailyInvocationStatistic {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    day: ").append(toIndentedString(day)).append("\n");
    sb.append("    serviceName: ").append(toIndentedString(serviceName)).append("\n");
    sb.append("    serviceVersion: ").append(toIndentedString(serviceVersion)).append("\n");
    sb.append("    dailyCount: ").append(toIndentedString(dailyCount)).append("\n");
    sb.append("    hourlyCount: ").append(toIndentedString(hourlyCount)).append("\n");
    sb.append("    minuteCount: ").append(toIndentedString(minuteCount)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `id` to the URL query string
    if (getId() != null) {
      joiner.add(String.format("%sid%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getId()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `day` to the URL query string
    if (getDay() != null) {
      joiner.add(String.format("%sday%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getDay()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `serviceName` to the URL query string
    if (getServiceName() != null) {
      joiner.add(String.format("%sserviceName%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getServiceName()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `serviceVersion` to the URL query string
    if (getServiceVersion() != null) {
      joiner.add(String.format("%sserviceVersion%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getServiceVersion()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `dailyCount` to the URL query string
    if (getDailyCount() != null) {
      joiner.add(String.format("%sdailyCount%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getDailyCount()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `hourlyCount` to the URL query string
    if (getHourlyCount() != null) {
      for (String _key : getHourlyCount().keySet()) {
        joiner.add(String.format("%shourlyCount%s%s=%s", prefix, suffix,
            "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, _key, containerSuffix),
            getHourlyCount().get(_key), URLEncoder.encode(ApiClient.valueToString(getHourlyCount().get(_key)), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
      }
    }

    // add `minuteCount` to the URL query string
    if (getMinuteCount() != null) {
      for (String _key : getMinuteCount().keySet()) {
        joiner.add(String.format("%sminuteCount%s%s=%s", prefix, suffix,
            "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, _key, containerSuffix),
            getMinuteCount().get(_key), URLEncoder.encode(ApiClient.valueToString(getMinuteCount().get(_key)), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
      }
    }

    return joiner.toString();
  }
}

