/*
 * Microcks API v1.10
 * API offered by Microcks, the Kubernetes native tool for API and microservices mocking and testing (microcks.io)
 *
 * The version of the OpenAPI document: 1.10.1
 * Contact: laurent@microcks.io
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.github.microcks.client.model;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.StringJoiner;
import java.util.Objects;
import java.util.Map;
import java.util.HashMap;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.github.microcks.client.model.EventMessage;
import io.github.microcks.client.model.Request;
import io.github.microcks.client.model.RequestResponsePair;
import io.github.microcks.client.model.Response;
import io.github.microcks.client.model.UnidirectionalEvent;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

import com.fasterxml.jackson.core.type.TypeReference;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import io.github.microcks.client.JSON;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-01-06T15:57:00.387475551Z[Etc/UTC]", comments = "Generator version: 7.7.0")
@JsonDeserialize(using = Exchange.ExchangeDeserializer.class)
@JsonSerialize(using = Exchange.ExchangeSerializer.class)
public class Exchange extends AbstractOpenApiSchema {
    private static final Logger log = Logger.getLogger(Exchange.class.getName());

    public static class ExchangeSerializer extends StdSerializer<Exchange> {
        public ExchangeSerializer(Class<Exchange> t) {
            super(t);
        }

        public ExchangeSerializer() {
            this(null);
        }

        @Override
        public void serialize(Exchange value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeObject(value.getActualInstance());
        }
    }

    public static class ExchangeDeserializer extends StdDeserializer<Exchange> {
        public ExchangeDeserializer() {
            this(Exchange.class);
        }

        public ExchangeDeserializer(Class<?> vc) {
            super(vc);
        }

        @Override
        public Exchange deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            JsonNode tree = jp.readValueAsTree();
            Object deserialized = null;
            boolean typeCoercion = ctxt.isEnabled(MapperFeature.ALLOW_COERCION_OF_SCALARS);
            int match = 0;
            JsonToken token = tree.traverse(jp.getCodec()).nextToken();
            // deserialize RequestResponsePair
            try {
                boolean attemptParsing = true;
                // ensure that we respect type coercion as set on the client ObjectMapper
                if (RequestResponsePair.class.equals(Integer.class) || RequestResponsePair.class.equals(Long.class) || RequestResponsePair.class.equals(Float.class) || RequestResponsePair.class.equals(Double.class) || RequestResponsePair.class.equals(Boolean.class) || RequestResponsePair.class.equals(String.class)) {
                    attemptParsing = typeCoercion;
                    if (!attemptParsing) {
                        attemptParsing |= ((RequestResponsePair.class.equals(Integer.class) || RequestResponsePair.class.equals(Long.class)) && token == JsonToken.VALUE_NUMBER_INT);
                        attemptParsing |= ((RequestResponsePair.class.equals(Float.class) || RequestResponsePair.class.equals(Double.class)) && token == JsonToken.VALUE_NUMBER_FLOAT);
                        attemptParsing |= (RequestResponsePair.class.equals(Boolean.class) && (token == JsonToken.VALUE_FALSE || token == JsonToken.VALUE_TRUE));
                        attemptParsing |= (RequestResponsePair.class.equals(String.class) && token == JsonToken.VALUE_STRING);
                    }
                }
                if (attemptParsing) {
                    deserialized = tree.traverse(jp.getCodec()).readValueAs(RequestResponsePair.class);
                    // TODO: there is no validation against JSON schema constraints
                    // (min, max, enum, pattern...), this does not perform a strict JSON
                    // validation, which means the 'match' count may be higher than it should be.
                    match++;
                    log.log(Level.FINER, "Input data matches schema 'RequestResponsePair'");
                }
            } catch (Exception e) {
                // deserialization failed, continue
                log.log(Level.FINER, "Input data does not match schema 'RequestResponsePair'", e);
            }

            // deserialize UnidirectionalEvent
            try {
                boolean attemptParsing = true;
                // ensure that we respect type coercion as set on the client ObjectMapper
                if (UnidirectionalEvent.class.equals(Integer.class) || UnidirectionalEvent.class.equals(Long.class) || UnidirectionalEvent.class.equals(Float.class) || UnidirectionalEvent.class.equals(Double.class) || UnidirectionalEvent.class.equals(Boolean.class) || UnidirectionalEvent.class.equals(String.class)) {
                    attemptParsing = typeCoercion;
                    if (!attemptParsing) {
                        attemptParsing |= ((UnidirectionalEvent.class.equals(Integer.class) || UnidirectionalEvent.class.equals(Long.class)) && token == JsonToken.VALUE_NUMBER_INT);
                        attemptParsing |= ((UnidirectionalEvent.class.equals(Float.class) || UnidirectionalEvent.class.equals(Double.class)) && token == JsonToken.VALUE_NUMBER_FLOAT);
                        attemptParsing |= (UnidirectionalEvent.class.equals(Boolean.class) && (token == JsonToken.VALUE_FALSE || token == JsonToken.VALUE_TRUE));
                        attemptParsing |= (UnidirectionalEvent.class.equals(String.class) && token == JsonToken.VALUE_STRING);
                    }
                }
                if (attemptParsing) {
                    deserialized = tree.traverse(jp.getCodec()).readValueAs(UnidirectionalEvent.class);
                    // TODO: there is no validation against JSON schema constraints
                    // (min, max, enum, pattern...), this does not perform a strict JSON
                    // validation, which means the 'match' count may be higher than it should be.
                    match++;
                    log.log(Level.FINER, "Input data matches schema 'UnidirectionalEvent'");
                }
            } catch (Exception e) {
                // deserialization failed, continue
                log.log(Level.FINER, "Input data does not match schema 'UnidirectionalEvent'", e);
            }

            if (match == 1) {
                Exchange ret = new Exchange();
                ret.setActualInstance(deserialized);
                return ret;
            }
            throw new IOException(String.format("Failed deserialization for Exchange: %d classes match result, expected 1", match));
        }

        /**
         * Handle deserialization of the 'null' value.
         */
        @Override
        public Exchange getNullValue(DeserializationContext ctxt) throws JsonMappingException {
            throw new JsonMappingException(ctxt.getParser(), "Exchange cannot be null");
        }
    }

    // store a list of schema names defined in oneOf
    public static final Map<String, Class<?>> schemas = new HashMap<>();

    public Exchange() {
        super("oneOf", Boolean.FALSE);
    }

    public Exchange(RequestResponsePair o) {
        super("oneOf", Boolean.FALSE);
        setActualInstance(o);
    }

    public Exchange(UnidirectionalEvent o) {
        super("oneOf", Boolean.FALSE);
        setActualInstance(o);
    }

    static {
        schemas.put("RequestResponsePair", RequestResponsePair.class);
        schemas.put("UnidirectionalEvent", UnidirectionalEvent.class);
        JSON.registerDescendants(Exchange.class, Collections.unmodifiableMap(schemas));
        // Initialize and register the discriminator mappings.
        Map<String, Class<?>> mappings = new HashMap<String, Class<?>>();
        mappings.put("reqRespPair", RequestResponsePair.class);
        mappings.put("unidirEvent", UnidirectionalEvent.class);
        mappings.put("RequestResponsePair", RequestResponsePair.class);
        mappings.put("UnidirectionalEvent", UnidirectionalEvent.class);
        mappings.put("Exchange", Exchange.class);
        JSON.registerDiscriminator(Exchange.class, "type", mappings);
    }

    @Override
    public Map<String, Class<?>> getSchemas() {
        return Exchange.schemas;
    }

    /**
     * Set the instance that matches the oneOf child schema, check
     * the instance parameter is valid against the oneOf child schemas:
     * RequestResponsePair, UnidirectionalEvent
     *
     * It could be an instance of the 'oneOf' schemas.
     * The oneOf child schemas may themselves be a composed schema (allOf, anyOf, oneOf).
     */
    @Override
    public void setActualInstance(Object instance) {
        if (JSON.isInstanceOf(RequestResponsePair.class, instance, new HashSet<Class<?>>())) {
            super.setActualInstance(instance);
            return;
        }

        if (JSON.isInstanceOf(UnidirectionalEvent.class, instance, new HashSet<Class<?>>())) {
            super.setActualInstance(instance);
            return;
        }

        throw new RuntimeException("Invalid instance type. Must be RequestResponsePair, UnidirectionalEvent");
    }

    /**
     * Get the actual instance, which can be the following:
     * RequestResponsePair, UnidirectionalEvent
     *
     * @return The actual instance (RequestResponsePair, UnidirectionalEvent)
     */
    @Override
    public Object getActualInstance() {
        return super.getActualInstance();
    }

    /**
     * Get the actual instance of `RequestResponsePair`. If the actual instance is not `RequestResponsePair`,
     * the ClassCastException will be thrown.
     *
     * @return The actual instance of `RequestResponsePair`
     * @throws ClassCastException if the instance is not `RequestResponsePair`
     */
    public RequestResponsePair getRequestResponsePair() throws ClassCastException {
        return (RequestResponsePair)super.getActualInstance();
    }

    /**
     * Get the actual instance of `UnidirectionalEvent`. If the actual instance is not `UnidirectionalEvent`,
     * the ClassCastException will be thrown.
     *
     * @return The actual instance of `UnidirectionalEvent`
     * @throws ClassCastException if the instance is not `UnidirectionalEvent`
     */
    public UnidirectionalEvent getUnidirectionalEvent() throws ClassCastException {
        return (UnidirectionalEvent)super.getActualInstance();
    }



  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    if (getActualInstance() instanceof RequestResponsePair) {
        if (getActualInstance() != null) {
          joiner.add(((RequestResponsePair)getActualInstance()).toUrlQueryString(prefix + "one_of_0" + suffix));
        }
        return joiner.toString();
    }
    if (getActualInstance() instanceof UnidirectionalEvent) {
        if (getActualInstance() != null) {
          joiner.add(((UnidirectionalEvent)getActualInstance()).toUrlQueryString(prefix + "one_of_1" + suffix));
        }
        return joiner.toString();
    }
    return null;
  }

}

