/*
 * Microcks API v1.10
 * API offered by Microcks, the Kubernetes native tool for API and microservices mocking and testing (microcks.io)
 *
 * The version of the OpenAPI document: 1.10.1
 * Contact: laurent@microcks.io
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.github.microcks.client.model;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.StringJoiner;
import java.util.Objects;
import java.util.Map;
import java.util.HashMap;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.github.microcks.client.model.Metadata;
import io.github.microcks.client.model.SecretRef;
import io.github.microcks.client.model.ServiceRef;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;


import io.github.microcks.client.ApiClient;
/**
 * An ImportJob allow defining a repository artifact to poll for discovering Services and APIs mocks and tests
 */
@JsonPropertyOrder({
  ImportJob.JSON_PROPERTY_ID,
  ImportJob.JSON_PROPERTY_NAME,
  ImportJob.JSON_PROPERTY_REPOSITORY_URL,
  ImportJob.JSON_PROPERTY_REPOSITORY_DISABLE_S_S_L_VALIDATION,
  ImportJob.JSON_PROPERTY_FREQUENCY,
  ImportJob.JSON_PROPERTY_CREATED_DATE,
  ImportJob.JSON_PROPERTY_LAST_IMPORT_DATE,
  ImportJob.JSON_PROPERTY_LAST_IMPORT_ERROR,
  ImportJob.JSON_PROPERTY_ACTIVE,
  ImportJob.JSON_PROPERTY_ETAG,
  ImportJob.JSON_PROPERTY_SERVICE_REFS,
  ImportJob.JSON_PROPERTY_METADATA,
  ImportJob.JSON_PROPERTY_SECRET_REF,
  ImportJob.JSON_PROPERTY_MAIN_ARTIFACT
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-01-06T15:57:00.387475551Z[Etc/UTC]", comments = "Generator version: 7.7.0")
public class ImportJob {
  public static final String JSON_PROPERTY_ID = "id";
  private String id;

  public static final String JSON_PROPERTY_NAME = "name";
  private String name;

  public static final String JSON_PROPERTY_REPOSITORY_URL = "repositoryUrl";
  private String repositoryUrl;

  public static final String JSON_PROPERTY_REPOSITORY_DISABLE_S_S_L_VALIDATION = "repositoryDisableSSLValidation";
  private Boolean repositoryDisableSSLValidation;

  public static final String JSON_PROPERTY_FREQUENCY = "frequency";
  private String frequency;

  public static final String JSON_PROPERTY_CREATED_DATE = "createdDate";
  private Long createdDate;

  public static final String JSON_PROPERTY_LAST_IMPORT_DATE = "lastImportDate";
  private Long lastImportDate;

  public static final String JSON_PROPERTY_LAST_IMPORT_ERROR = "lastImportError";
  private String lastImportError;

  public static final String JSON_PROPERTY_ACTIVE = "active";
  private Boolean active;

  public static final String JSON_PROPERTY_ETAG = "etag";
  private String etag;

  public static final String JSON_PROPERTY_SERVICE_REFS = "serviceRefs";
  private List<ServiceRef> serviceRefs = new ArrayList<>();

  public static final String JSON_PROPERTY_METADATA = "metadata";
  private Metadata metadata;

  public static final String JSON_PROPERTY_SECRET_REF = "secretRef";
  private SecretRef secretRef;

  public static final String JSON_PROPERTY_MAIN_ARTIFACT = "mainArtifact";
  private Boolean mainArtifact;

  public ImportJob() { 
  }

  public ImportJob id(String id) {
    this.id = id;
    return this;
  }

  /**
   * Unique identifier of ImportJob
   * @return id
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getId() {
    return id;
  }


  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setId(String id) {
    this.id = id;
  }


  public ImportJob name(String name) {
    this.name = name;
    return this;
  }

  /**
   * Unique distinct name of this ImportJob
   * @return name
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public String getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setName(String name) {
    this.name = name;
  }


  public ImportJob repositoryUrl(String repositoryUrl) {
    this.repositoryUrl = repositoryUrl;
    return this;
  }

  /**
   * URL of mocks and tests repository artifact
   * @return repositoryUrl
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_REPOSITORY_URL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public String getRepositoryUrl() {
    return repositoryUrl;
  }


  @JsonProperty(JSON_PROPERTY_REPOSITORY_URL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setRepositoryUrl(String repositoryUrl) {
    this.repositoryUrl = repositoryUrl;
  }


  public ImportJob repositoryDisableSSLValidation(Boolean repositoryDisableSSLValidation) {
    this.repositoryDisableSSLValidation = repositoryDisableSSLValidation;
    return this;
  }

  /**
   * Whether to disable SSL certificate verification when checking repository
   * @return repositoryDisableSSLValidation
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_REPOSITORY_DISABLE_S_S_L_VALIDATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Boolean getRepositoryDisableSSLValidation() {
    return repositoryDisableSSLValidation;
  }


  @JsonProperty(JSON_PROPERTY_REPOSITORY_DISABLE_S_S_L_VALIDATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRepositoryDisableSSLValidation(Boolean repositoryDisableSSLValidation) {
    this.repositoryDisableSSLValidation = repositoryDisableSSLValidation;
  }


  public ImportJob frequency(String frequency) {
    this.frequency = frequency;
    return this;
  }

  /**
   * Reserved for future usage
   * @return frequency
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_FREQUENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getFrequency() {
    return frequency;
  }


  @JsonProperty(JSON_PROPERTY_FREQUENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFrequency(String frequency) {
    this.frequency = frequency;
  }


  public ImportJob createdDate(Long createdDate) {
    this.createdDate = createdDate;
    return this;
  }

  /**
   * Creation timestamp for this ImportJob
   * @return createdDate
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_CREATED_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Long getCreatedDate() {
    return createdDate;
  }


  @JsonProperty(JSON_PROPERTY_CREATED_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCreatedDate(Long createdDate) {
    this.createdDate = createdDate;
  }


  public ImportJob lastImportDate(Long lastImportDate) {
    this.lastImportDate = lastImportDate;
    return this;
  }

  /**
   * Timestamp of the last import
   * @return lastImportDate
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_LAST_IMPORT_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Long getLastImportDate() {
    return lastImportDate;
  }


  @JsonProperty(JSON_PROPERTY_LAST_IMPORT_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLastImportDate(Long lastImportDate) {
    this.lastImportDate = lastImportDate;
  }


  public ImportJob lastImportError(String lastImportError) {
    this.lastImportError = lastImportError;
    return this;
  }

  /**
   * Error message of last import (if any)
   * @return lastImportError
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_LAST_IMPORT_ERROR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getLastImportError() {
    return lastImportError;
  }


  @JsonProperty(JSON_PROPERTY_LAST_IMPORT_ERROR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLastImportError(String lastImportError) {
    this.lastImportError = lastImportError;
  }


  public ImportJob active(Boolean active) {
    this.active = active;
    return this;
  }

  /**
   * Whether this ImportJob is active (ie. scheduled for execution)
   * @return active
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ACTIVE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Boolean getActive() {
    return active;
  }


  @JsonProperty(JSON_PROPERTY_ACTIVE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setActive(Boolean active) {
    this.active = active;
  }


  public ImportJob etag(String etag) {
    this.etag = etag;
    return this;
  }

  /**
   * Etag of repository URL during previous import. Is used for not re-importing if no recent changes
   * @return etag
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ETAG)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getEtag() {
    return etag;
  }


  @JsonProperty(JSON_PROPERTY_ETAG)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEtag(String etag) {
    this.etag = etag;
  }


  public ImportJob serviceRefs(List<ServiceRef> serviceRefs) {
    this.serviceRefs = serviceRefs;
    return this;
  }

  public ImportJob addServiceRefsItem(ServiceRef serviceRefsItem) {
    if (this.serviceRefs == null) {
      this.serviceRefs = new ArrayList<>();
    }
    this.serviceRefs.add(serviceRefsItem);
    return this;
  }

  /**
   * References of Services discovered when checking repository
   * @return serviceRefs
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_SERVICE_REFS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public List<ServiceRef> getServiceRefs() {
    return serviceRefs;
  }


  @JsonProperty(JSON_PROPERTY_SERVICE_REFS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setServiceRefs(List<ServiceRef> serviceRefs) {
    this.serviceRefs = serviceRefs;
  }


  public ImportJob metadata(Metadata metadata) {
    this.metadata = metadata;
    return this;
  }

  /**
   * Get metadata
   * @return metadata
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_METADATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Metadata getMetadata() {
    return metadata;
  }


  @JsonProperty(JSON_PROPERTY_METADATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMetadata(Metadata metadata) {
    this.metadata = metadata;
  }


  public ImportJob secretRef(SecretRef secretRef) {
    this.secretRef = secretRef;
    return this;
  }

  /**
   * Get secretRef
   * @return secretRef
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_SECRET_REF)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public SecretRef getSecretRef() {
    return secretRef;
  }


  @JsonProperty(JSON_PROPERTY_SECRET_REF)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSecretRef(SecretRef secretRef) {
    this.secretRef = secretRef;
  }


  public ImportJob mainArtifact(Boolean mainArtifact) {
    this.mainArtifact = mainArtifact;
    return this;
  }

  /**
   * Flag telling if considered as primary or secondary artifact. Default to &#x60;true&#x60;
   * @return mainArtifact
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_MAIN_ARTIFACT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Boolean getMainArtifact() {
    return mainArtifact;
  }


  @JsonProperty(JSON_PROPERTY_MAIN_ARTIFACT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMainArtifact(Boolean mainArtifact) {
    this.mainArtifact = mainArtifact;
  }


  /**
   * Return true if this ImportJob object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ImportJob importJob = (ImportJob) o;
    return Objects.equals(this.id, importJob.id) &&
        Objects.equals(this.name, importJob.name) &&
        Objects.equals(this.repositoryUrl, importJob.repositoryUrl) &&
        Objects.equals(this.repositoryDisableSSLValidation, importJob.repositoryDisableSSLValidation) &&
        Objects.equals(this.frequency, importJob.frequency) &&
        Objects.equals(this.createdDate, importJob.createdDate) &&
        Objects.equals(this.lastImportDate, importJob.lastImportDate) &&
        Objects.equals(this.lastImportError, importJob.lastImportError) &&
        Objects.equals(this.active, importJob.active) &&
        Objects.equals(this.etag, importJob.etag) &&
        Objects.equals(this.serviceRefs, importJob.serviceRefs) &&
        Objects.equals(this.metadata, importJob.metadata) &&
        Objects.equals(this.secretRef, importJob.secretRef) &&
        Objects.equals(this.mainArtifact, importJob.mainArtifact);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, name, repositoryUrl, repositoryDisableSSLValidation, frequency, createdDate, lastImportDate, lastImportError, active, etag, serviceRefs, metadata, secretRef, mainArtifact);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ImportJob {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    repositoryUrl: ").append(toIndentedString(repositoryUrl)).append("\n");
    sb.append("    repositoryDisableSSLValidation: ").append(toIndentedString(repositoryDisableSSLValidation)).append("\n");
    sb.append("    frequency: ").append(toIndentedString(frequency)).append("\n");
    sb.append("    createdDate: ").append(toIndentedString(createdDate)).append("\n");
    sb.append("    lastImportDate: ").append(toIndentedString(lastImportDate)).append("\n");
    sb.append("    lastImportError: ").append(toIndentedString(lastImportError)).append("\n");
    sb.append("    active: ").append(toIndentedString(active)).append("\n");
    sb.append("    etag: ").append(toIndentedString(etag)).append("\n");
    sb.append("    serviceRefs: ").append(toIndentedString(serviceRefs)).append("\n");
    sb.append("    metadata: ").append(toIndentedString(metadata)).append("\n");
    sb.append("    secretRef: ").append(toIndentedString(secretRef)).append("\n");
    sb.append("    mainArtifact: ").append(toIndentedString(mainArtifact)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `id` to the URL query string
    if (getId() != null) {
      joiner.add(String.format("%sid%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getId()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `name` to the URL query string
    if (getName() != null) {
      joiner.add(String.format("%sname%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getName()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `repositoryUrl` to the URL query string
    if (getRepositoryUrl() != null) {
      joiner.add(String.format("%srepositoryUrl%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getRepositoryUrl()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `repositoryDisableSSLValidation` to the URL query string
    if (getRepositoryDisableSSLValidation() != null) {
      joiner.add(String.format("%srepositoryDisableSSLValidation%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getRepositoryDisableSSLValidation()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `frequency` to the URL query string
    if (getFrequency() != null) {
      joiner.add(String.format("%sfrequency%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getFrequency()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `createdDate` to the URL query string
    if (getCreatedDate() != null) {
      joiner.add(String.format("%screatedDate%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getCreatedDate()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `lastImportDate` to the URL query string
    if (getLastImportDate() != null) {
      joiner.add(String.format("%slastImportDate%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getLastImportDate()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `lastImportError` to the URL query string
    if (getLastImportError() != null) {
      joiner.add(String.format("%slastImportError%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getLastImportError()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `active` to the URL query string
    if (getActive() != null) {
      joiner.add(String.format("%sactive%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getActive()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `etag` to the URL query string
    if (getEtag() != null) {
      joiner.add(String.format("%setag%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getEtag()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `serviceRefs` to the URL query string
    if (getServiceRefs() != null) {
      for (int i = 0; i < getServiceRefs().size(); i++) {
        if (getServiceRefs().get(i) != null) {
          joiner.add(getServiceRefs().get(i).toUrlQueryString(String.format("%sserviceRefs%s%s", prefix, suffix,
          "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
        }
      }
    }

    // add `metadata` to the URL query string
    if (getMetadata() != null) {
      joiner.add(getMetadata().toUrlQueryString(prefix + "metadata" + suffix));
    }

    // add `secretRef` to the URL query string
    if (getSecretRef() != null) {
      joiner.add(getSecretRef().toUrlQueryString(prefix + "secretRef" + suffix));
    }

    // add `mainArtifact` to the URL query string
    if (getMainArtifact() != null) {
      joiner.add(String.format("%smainArtifact%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getMainArtifact()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    return joiner.toString();
  }
}

