/*
 * Microcks API v1.10
 * API offered by Microcks, the Kubernetes native tool for API and microservices mocking and testing (microcks.io)
 *
 * The version of the OpenAPI document: 1.10.1
 * Contact: laurent@microcks.io
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.github.microcks.client.model;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.StringJoiner;
import java.util.Objects;
import java.util.Map;
import java.util.HashMap;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;


import io.github.microcks.client.ApiClient;
/**
 * Commodity object for holding metadata on any entity. This object is inspired by Kubernetes metadata.
 */
@JsonPropertyOrder({
  Metadata.JSON_PROPERTY_CREATED_ON,
  Metadata.JSON_PROPERTY_LAST_UPDATE,
  Metadata.JSON_PROPERTY_ANNOTATIONS,
  Metadata.JSON_PROPERTY_LABELS
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-01-06T15:57:00.387475551Z[Etc/UTC]", comments = "Generator version: 7.7.0")
public class Metadata {
  public static final String JSON_PROPERTY_CREATED_ON = "createdOn";
  private BigDecimal createdOn;

  public static final String JSON_PROPERTY_LAST_UPDATE = "lastUpdate";
  private BigDecimal lastUpdate;

  public static final String JSON_PROPERTY_ANNOTATIONS = "annotations";
  private Map<String, String> annotations = new HashMap<>();

  public static final String JSON_PROPERTY_LABELS = "labels";
  private Map<String, String> labels = new HashMap<>();

  public Metadata() { 
  }

  @JsonCreator
  public Metadata(
    @JsonProperty(JSON_PROPERTY_CREATED_ON) BigDecimal createdOn, 
    @JsonProperty(JSON_PROPERTY_LAST_UPDATE) BigDecimal lastUpdate
  ) {
  this();
    this.createdOn = createdOn;
    this.lastUpdate = lastUpdate;
  }

  /**
   * Creation date of attached object
   * @return createdOn
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_CREATED_ON)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public BigDecimal getCreatedOn() {
    return createdOn;
  }




  /**
   * Last update of attached object
   * @return lastUpdate
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_LAST_UPDATE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public BigDecimal getLastUpdate() {
    return lastUpdate;
  }




  public Metadata annotations(Map<String, String> annotations) {
    this.annotations = annotations;
    return this;
  }

  public Metadata putAnnotationsItem(String key, String annotationsItem) {
    if (this.annotations == null) {
      this.annotations = new HashMap<>();
    }
    this.annotations.put(key, annotationsItem);
    return this;
  }

  /**
   * Annotations of attached object
   * @return annotations
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ANNOTATIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Map<String, String> getAnnotations() {
    return annotations;
  }


  @JsonProperty(JSON_PROPERTY_ANNOTATIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAnnotations(Map<String, String> annotations) {
    this.annotations = annotations;
  }


  public Metadata labels(Map<String, String> labels) {
    this.labels = labels;
    return this;
  }

  public Metadata putLabelsItem(String key, String labelsItem) {
    if (this.labels == null) {
      this.labels = new HashMap<>();
    }
    this.labels.put(key, labelsItem);
    return this;
  }

  /**
   * Labels put on attached object
   * @return labels
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_LABELS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Map<String, String> getLabels() {
    return labels;
  }


  @JsonProperty(JSON_PROPERTY_LABELS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLabels(Map<String, String> labels) {
    this.labels = labels;
  }


  /**
   * Return true if this Metadata object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Metadata metadata = (Metadata) o;
    return Objects.equals(this.createdOn, metadata.createdOn) &&
        Objects.equals(this.lastUpdate, metadata.lastUpdate) &&
        Objects.equals(this.annotations, metadata.annotations) &&
        Objects.equals(this.labels, metadata.labels);
  }

  @Override
  public int hashCode() {
    return Objects.hash(createdOn, lastUpdate, annotations, labels);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Metadata {\n");
    sb.append("    createdOn: ").append(toIndentedString(createdOn)).append("\n");
    sb.append("    lastUpdate: ").append(toIndentedString(lastUpdate)).append("\n");
    sb.append("    annotations: ").append(toIndentedString(annotations)).append("\n");
    sb.append("    labels: ").append(toIndentedString(labels)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `createdOn` to the URL query string
    if (getCreatedOn() != null) {
      joiner.add(String.format("%screatedOn%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getCreatedOn()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `lastUpdate` to the URL query string
    if (getLastUpdate() != null) {
      joiner.add(String.format("%slastUpdate%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getLastUpdate()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `annotations` to the URL query string
    if (getAnnotations() != null) {
      for (String _key : getAnnotations().keySet()) {
        joiner.add(String.format("%sannotations%s%s=%s", prefix, suffix,
            "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, _key, containerSuffix),
            getAnnotations().get(_key), URLEncoder.encode(ApiClient.valueToString(getAnnotations().get(_key)), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
      }
    }

    // add `labels` to the URL query string
    if (getLabels() != null) {
      for (String _key : getLabels().keySet()) {
        joiner.add(String.format("%slabels%s%s=%s", prefix, suffix,
            "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, _key, containerSuffix),
            getLabels().get(_key), URLEncoder.encode(ApiClient.valueToString(getLabels().get(_key)), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
      }
    }

    return joiner.toString();
  }
}

