/*
 * Microcks API v1.10
 * API offered by Microcks, the Kubernetes native tool for API and microservices mocking and testing (microcks.io)
 *
 * The version of the OpenAPI document: 1.10.1
 * Contact: laurent@microcks.io
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.github.microcks.client.model;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.StringJoiner;
import java.util.Objects;
import java.util.Map;
import java.util.HashMap;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;


import io.github.microcks.client.ApiClient;
/**
 * Represents a volatile OAuth2 client context usually associated with a Test request
 */
@JsonPropertyOrder({
  OAuth2ClientContent.JSON_PROPERTY_CLIENT_ID,
  OAuth2ClientContent.JSON_PROPERTY_CLIENT_SECRET,
  OAuth2ClientContent.JSON_PROPERTY_TOKEN_URI,
  OAuth2ClientContent.JSON_PROPERTY_USERNAME,
  OAuth2ClientContent.JSON_PROPERTY_PASSWORD,
  OAuth2ClientContent.JSON_PROPERTY_REFRESH_TOKEN
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-01-06T15:57:00.387475551Z[Etc/UTC]", comments = "Generator version: 7.7.0")
public class OAuth2ClientContent {
  public static final String JSON_PROPERTY_CLIENT_ID = "clientId";
  private String clientId;

  public static final String JSON_PROPERTY_CLIENT_SECRET = "clientSecret";
  private String clientSecret;

  public static final String JSON_PROPERTY_TOKEN_URI = "tokenUri";
  private String tokenUri;

  public static final String JSON_PROPERTY_USERNAME = "username";
  private String username;

  public static final String JSON_PROPERTY_PASSWORD = "password";
  private String password;

  public static final String JSON_PROPERTY_REFRESH_TOKEN = "refreshToken";
  private String refreshToken;

  public OAuth2ClientContent() { 
  }

  public OAuth2ClientContent clientId(String clientId) {
    this.clientId = clientId;
    return this;
  }

  /**
   * Id for connecting to OAuth2 identity provider
   * @return clientId
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_CLIENT_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public String getClientId() {
    return clientId;
  }


  @JsonProperty(JSON_PROPERTY_CLIENT_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setClientId(String clientId) {
    this.clientId = clientId;
  }


  public OAuth2ClientContent clientSecret(String clientSecret) {
    this.clientSecret = clientSecret;
    return this;
  }

  /**
   * Secret for connecting to OAuth2 identity provider
   * @return clientSecret
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_CLIENT_SECRET)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public String getClientSecret() {
    return clientSecret;
  }


  @JsonProperty(JSON_PROPERTY_CLIENT_SECRET)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setClientSecret(String clientSecret) {
    this.clientSecret = clientSecret;
  }


  public OAuth2ClientContent tokenUri(String tokenUri) {
    this.tokenUri = tokenUri;
    return this;
  }

  /**
   * URI for retrieving an access token from OAuth2 identity provider
   * @return tokenUri
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_TOKEN_URI)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public String getTokenUri() {
    return tokenUri;
  }


  @JsonProperty(JSON_PROPERTY_TOKEN_URI)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setTokenUri(String tokenUri) {
    this.tokenUri = tokenUri;
  }


  public OAuth2ClientContent username(String username) {
    this.username = username;
    return this;
  }

  /**
   * Username in case you&#39;re using the Resource Owner Password flow
   * @return username
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_USERNAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getUsername() {
    return username;
  }


  @JsonProperty(JSON_PROPERTY_USERNAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUsername(String username) {
    this.username = username;
  }


  public OAuth2ClientContent password(String password) {
    this.password = password;
    return this;
  }

  /**
   * User password in case you&#39;re suing the Resource Owner password flow
   * @return password
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_PASSWORD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getPassword() {
    return password;
  }


  @JsonProperty(JSON_PROPERTY_PASSWORD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPassword(String password) {
    this.password = password;
  }


  public OAuth2ClientContent refreshToken(String refreshToken) {
    this.refreshToken = refreshToken;
    return this;
  }

  /**
   * Refresh token in case you&#39;re using the Refresh Token rotation flow
   * @return refreshToken
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_REFRESH_TOKEN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getRefreshToken() {
    return refreshToken;
  }


  @JsonProperty(JSON_PROPERTY_REFRESH_TOKEN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRefreshToken(String refreshToken) {
    this.refreshToken = refreshToken;
  }


  /**
   * Return true if this OAuth2ClientContent object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    OAuth2ClientContent oauth2ClientContent = (OAuth2ClientContent) o;
    return Objects.equals(this.clientId, oauth2ClientContent.clientId) &&
        Objects.equals(this.clientSecret, oauth2ClientContent.clientSecret) &&
        Objects.equals(this.tokenUri, oauth2ClientContent.tokenUri) &&
        Objects.equals(this.username, oauth2ClientContent.username) &&
        Objects.equals(this.password, oauth2ClientContent.password) &&
        Objects.equals(this.refreshToken, oauth2ClientContent.refreshToken);
  }

  @Override
  public int hashCode() {
    return Objects.hash(clientId, clientSecret, tokenUri, username, password, refreshToken);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class OAuth2ClientContent {\n");
    sb.append("    clientId: ").append(toIndentedString(clientId)).append("\n");
    sb.append("    clientSecret: ").append("*").append("\n");
    sb.append("    tokenUri: ").append(toIndentedString(tokenUri)).append("\n");
    sb.append("    username: ").append(toIndentedString(username)).append("\n");
    sb.append("    password: ").append(toIndentedString(password)).append("\n");
    sb.append("    refreshToken: ").append(toIndentedString(refreshToken)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `clientId` to the URL query string
    if (getClientId() != null) {
      joiner.add(String.format("%sclientId%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getClientId()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `clientSecret` to the URL query string
    if (getClientSecret() != null) {
      joiner.add(String.format("%sclientSecret%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getClientSecret()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `tokenUri` to the URL query string
    if (getTokenUri() != null) {
      joiner.add(String.format("%stokenUri%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getTokenUri()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `username` to the URL query string
    if (getUsername() != null) {
      joiner.add(String.format("%susername%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getUsername()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `password` to the URL query string
    if (getPassword() != null) {
      joiner.add(String.format("%spassword%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getPassword()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `refreshToken` to the URL query string
    if (getRefreshToken() != null) {
      joiner.add(String.format("%srefreshToken%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getRefreshToken()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    return joiner.toString();
  }
}

