/*
 * Microcks API v1.10
 * API offered by Microcks, the Kubernetes native tool for API and microservices mocking and testing (microcks.io)
 *
 * The version of the OpenAPI document: 1.10.1
 * Contact: laurent@microcks.io
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.github.microcks.client.model;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.StringJoiner;
import java.util.Objects;
import java.util.Map;
import java.util.HashMap;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;


import io.github.microcks.client.ApiClient;
/**
 * Companion object for Operation that may be used to express constraints on request parameters
 */
@JsonPropertyOrder({
  ParameterConstraint.JSON_PROPERTY_NAME,
  ParameterConstraint.JSON_PROPERTY_REQUIRED,
  ParameterConstraint.JSON_PROPERTY_RECOPY,
  ParameterConstraint.JSON_PROPERTY_MUST_MATCH_REGEXP,
  ParameterConstraint.JSON_PROPERTY_IN
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-01-06T15:57:00.387475551Z[Etc/UTC]", comments = "Generator version: 7.7.0")
public class ParameterConstraint {
  public static final String JSON_PROPERTY_NAME = "name";
  private String name;

  public static final String JSON_PROPERTY_REQUIRED = "required";
  private Boolean required;

  public static final String JSON_PROPERTY_RECOPY = "recopy";
  private Boolean recopy;

  public static final String JSON_PROPERTY_MUST_MATCH_REGEXP = "mustMatchRegexp";
  private String mustMatchRegexp;

  /**
   * Parameter location
   */
  public enum InEnum {
    PATH("path"),
    
    QUERY("query"),
    
    HEADER("header");

    private String value;

    InEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static InEnum fromValue(String value) {
      for (InEnum b : InEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_IN = "in";
  private InEnum in;

  public ParameterConstraint() { 
  }

  public ParameterConstraint name(String name) {
    this.name = name;
    return this;
  }

  /**
   * Parameter name
   * @return name
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public String getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setName(String name) {
    this.name = name;
  }


  public ParameterConstraint required(Boolean required) {
    this.required = required;
    return this;
  }

  /**
   * Whether it&#39;s a required constraint
   * @return required
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_REQUIRED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Boolean getRequired() {
    return required;
  }


  @JsonProperty(JSON_PROPERTY_REQUIRED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRequired(Boolean required) {
    this.required = required;
  }


  public ParameterConstraint recopy(Boolean recopy) {
    this.recopy = recopy;
    return this;
  }

  /**
   * Whether it&#39;s a recopy constraint
   * @return recopy
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_RECOPY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Boolean getRecopy() {
    return recopy;
  }


  @JsonProperty(JSON_PROPERTY_RECOPY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRecopy(Boolean recopy) {
    this.recopy = recopy;
  }


  public ParameterConstraint mustMatchRegexp(String mustMatchRegexp) {
    this.mustMatchRegexp = mustMatchRegexp;
    return this;
  }

  /**
   * Whether it&#39;s a regular expression matching constraint
   * @return mustMatchRegexp
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_MUST_MATCH_REGEXP)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getMustMatchRegexp() {
    return mustMatchRegexp;
  }


  @JsonProperty(JSON_PROPERTY_MUST_MATCH_REGEXP)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMustMatchRegexp(String mustMatchRegexp) {
    this.mustMatchRegexp = mustMatchRegexp;
  }


  public ParameterConstraint in(InEnum in) {
    this.in = in;
    return this;
  }

  /**
   * Parameter location
   * @return in
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_IN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public InEnum getIn() {
    return in;
  }


  @JsonProperty(JSON_PROPERTY_IN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIn(InEnum in) {
    this.in = in;
  }


  /**
   * Return true if this ParameterConstraint object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ParameterConstraint parameterConstraint = (ParameterConstraint) o;
    return Objects.equals(this.name, parameterConstraint.name) &&
        Objects.equals(this.required, parameterConstraint.required) &&
        Objects.equals(this.recopy, parameterConstraint.recopy) &&
        Objects.equals(this.mustMatchRegexp, parameterConstraint.mustMatchRegexp) &&
        Objects.equals(this.in, parameterConstraint.in);
  }

  @Override
  public int hashCode() {
    return Objects.hash(name, required, recopy, mustMatchRegexp, in);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ParameterConstraint {\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    required: ").append(toIndentedString(required)).append("\n");
    sb.append("    recopy: ").append(toIndentedString(recopy)).append("\n");
    sb.append("    mustMatchRegexp: ").append(toIndentedString(mustMatchRegexp)).append("\n");
    sb.append("    in: ").append(toIndentedString(in)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `name` to the URL query string
    if (getName() != null) {
      joiner.add(String.format("%sname%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getName()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `required` to the URL query string
    if (getRequired() != null) {
      joiner.add(String.format("%srequired%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getRequired()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `recopy` to the URL query string
    if (getRecopy() != null) {
      joiner.add(String.format("%srecopy%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getRecopy()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `mustMatchRegexp` to the URL query string
    if (getMustMatchRegexp() != null) {
      joiner.add(String.format("%smustMatchRegexp%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getMustMatchRegexp()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `in` to the URL query string
    if (getIn() != null) {
      joiner.add(String.format("%sin%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getIn()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    return joiner.toString();
  }
}

