/*
 * Microcks API v1.10
 * API offered by Microcks, the Kubernetes native tool for API and microservices mocking and testing (microcks.io)
 *
 * The version of the OpenAPI document: 1.10.1
 * Contact: laurent@microcks.io
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.github.microcks.client.model;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.StringJoiner;
import java.util.Objects;
import java.util.Map;
import java.util.HashMap;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;


import io.github.microcks.client.ApiClient;
/**
 * A Secret allows grouping informations on how to access a restricted resource such as a repsoitory URL. Secrets are typically used by ImpoortJobs.
 */
@JsonPropertyOrder({
  Secret.JSON_PROPERTY_ID,
  Secret.JSON_PROPERTY_NAME,
  Secret.JSON_PROPERTY_USERNAME,
  Secret.JSON_PROPERTY_PASSWORD,
  Secret.JSON_PROPERTY_TOKEN,
  Secret.JSON_PROPERTY_TOKEN_HEADER,
  Secret.JSON_PROPERTY_CA_CERT_PEM,
  Secret.JSON_PROPERTY_DESCRIPTION
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-01-06T15:57:00.387475551Z[Etc/UTC]", comments = "Generator version: 7.7.0")
public class Secret {
  public static final String JSON_PROPERTY_ID = "id";
  private String id;

  public static final String JSON_PROPERTY_NAME = "name";
  private String name;

  public static final String JSON_PROPERTY_USERNAME = "username";
  private String username;

  public static final String JSON_PROPERTY_PASSWORD = "password";
  private String password;

  public static final String JSON_PROPERTY_TOKEN = "token";
  private String token;

  public static final String JSON_PROPERTY_TOKEN_HEADER = "tokenHeader";
  private String tokenHeader;

  public static final String JSON_PROPERTY_CA_CERT_PEM = "caCertPem";
  private String caCertPem;

  public static final String JSON_PROPERTY_DESCRIPTION = "description";
  private String description;

  public Secret() { 
  }

  public Secret id(String id) {
    this.id = id;
    return this;
  }

  /**
   * Unique identifier of Secret
   * @return id
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getId() {
    return id;
  }


  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setId(String id) {
    this.id = id;
  }


  public Secret name(String name) {
    this.name = name;
    return this;
  }

  /**
   * Unique distinct name of Secret
   * @return name
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public String getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setName(String name) {
    this.name = name;
  }


  public Secret username(String username) {
    this.username = username;
    return this;
  }

  /**
   * Get username
   * @return username
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_USERNAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getUsername() {
    return username;
  }


  @JsonProperty(JSON_PROPERTY_USERNAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUsername(String username) {
    this.username = username;
  }


  public Secret password(String password) {
    this.password = password;
    return this;
  }

  /**
   * Get password
   * @return password
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_PASSWORD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getPassword() {
    return password;
  }


  @JsonProperty(JSON_PROPERTY_PASSWORD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPassword(String password) {
    this.password = password;
  }


  public Secret token(String token) {
    this.token = token;
    return this;
  }

  /**
   * Get token
   * @return token
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_TOKEN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getToken() {
    return token;
  }


  @JsonProperty(JSON_PROPERTY_TOKEN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setToken(String token) {
    this.token = token;
  }


  public Secret tokenHeader(String tokenHeader) {
    this.tokenHeader = tokenHeader;
    return this;
  }

  /**
   * Get tokenHeader
   * @return tokenHeader
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_TOKEN_HEADER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getTokenHeader() {
    return tokenHeader;
  }


  @JsonProperty(JSON_PROPERTY_TOKEN_HEADER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTokenHeader(String tokenHeader) {
    this.tokenHeader = tokenHeader;
  }


  public Secret caCertPem(String caCertPem) {
    this.caCertPem = caCertPem;
    return this;
  }

  /**
   * Get caCertPem
   * @return caCertPem
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_CA_CERT_PEM)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getCaCertPem() {
    return caCertPem;
  }


  @JsonProperty(JSON_PROPERTY_CA_CERT_PEM)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCaCertPem(String caCertPem) {
    this.caCertPem = caCertPem;
  }


  public Secret description(String description) {
    this.description = description;
    return this;
  }

  /**
   * Description of this Secret
   * @return description
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public String getDescription() {
    return description;
  }


  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setDescription(String description) {
    this.description = description;
  }


  /**
   * Return true if this Secret object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Secret secret = (Secret) o;
    return Objects.equals(this.id, secret.id) &&
        Objects.equals(this.name, secret.name) &&
        Objects.equals(this.username, secret.username) &&
        Objects.equals(this.password, secret.password) &&
        Objects.equals(this.token, secret.token) &&
        Objects.equals(this.tokenHeader, secret.tokenHeader) &&
        Objects.equals(this.caCertPem, secret.caCertPem) &&
        Objects.equals(this.description, secret.description);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, name, username, password, token, tokenHeader, caCertPem, description);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Secret {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    username: ").append(toIndentedString(username)).append("\n");
    sb.append("    password: ").append(toIndentedString(password)).append("\n");
    sb.append("    token: ").append(toIndentedString(token)).append("\n");
    sb.append("    tokenHeader: ").append(toIndentedString(tokenHeader)).append("\n");
    sb.append("    caCertPem: ").append(toIndentedString(caCertPem)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `id` to the URL query string
    if (getId() != null) {
      joiner.add(String.format("%sid%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getId()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `name` to the URL query string
    if (getName() != null) {
      joiner.add(String.format("%sname%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getName()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `username` to the URL query string
    if (getUsername() != null) {
      joiner.add(String.format("%susername%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getUsername()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `password` to the URL query string
    if (getPassword() != null) {
      joiner.add(String.format("%spassword%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getPassword()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `token` to the URL query string
    if (getToken() != null) {
      joiner.add(String.format("%stoken%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getToken()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `tokenHeader` to the URL query string
    if (getTokenHeader() != null) {
      joiner.add(String.format("%stokenHeader%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getTokenHeader()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `caCertPem` to the URL query string
    if (getCaCertPem() != null) {
      joiner.add(String.format("%scaCertPem%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getCaCertPem()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `description` to the URL query string
    if (getDescription() != null) {
      joiner.add(String.format("%sdescription%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getDescription()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    return joiner.toString();
  }
}

