/*
 * Microcks API v1.10
 * API offered by Microcks, the Kubernetes native tool for API and microservices mocking and testing (microcks.io)
 *
 * The version of the OpenAPI document: 1.10.1
 * Contact: laurent@microcks.io
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.github.microcks.client.model;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.StringJoiner;
import java.util.Objects;
import java.util.Map;
import java.util.HashMap;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.github.microcks.client.model.Exchange;
import io.github.microcks.client.model.Service;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;


import io.github.microcks.client.ApiClient;
/**
 * Aggregate bean for grouping a Service an its messages pairs
 */
@JsonPropertyOrder({
  ServiceView.JSON_PROPERTY_SERVICE,
  ServiceView.JSON_PROPERTY_MESSAGES_MAP
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-01-06T15:57:00.387475551Z[Etc/UTC]", comments = "Generator version: 7.7.0")
public class ServiceView {
  public static final String JSON_PROPERTY_SERVICE = "service";
  private Service service;

  public static final String JSON_PROPERTY_MESSAGES_MAP = "messagesMap";
  private Map<String, List<Exchange>> messagesMap = new HashMap<>();

  public ServiceView() { 
  }

  public ServiceView service(Service service) {
    this.service = service;
    return this;
  }

  /**
   * Get service
   * @return service
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_SERVICE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public Service getService() {
    return service;
  }


  @JsonProperty(JSON_PROPERTY_SERVICE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setService(Service service) {
    this.service = service;
  }


  public ServiceView messagesMap(Map<String, List<Exchange>> messagesMap) {
    this.messagesMap = messagesMap;
    return this;
  }

  public ServiceView putMessagesMapItem(String key, List<Exchange> messagesMapItem) {
    if (this.messagesMap == null) {
      this.messagesMap = new HashMap<>();
    }
    this.messagesMap.put(key, messagesMapItem);
    return this;
  }

  /**
   * Map of messages for this Service. Keys are operation name, values are array of messages for this operation
   * @return messagesMap
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_MESSAGES_MAP)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public Map<String, List<Exchange>> getMessagesMap() {
    return messagesMap;
  }


  @JsonProperty(JSON_PROPERTY_MESSAGES_MAP)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setMessagesMap(Map<String, List<Exchange>> messagesMap) {
    this.messagesMap = messagesMap;
  }


  /**
   * Return true if this ServiceView object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ServiceView serviceView = (ServiceView) o;
    return Objects.equals(this.service, serviceView.service) &&
        Objects.equals(this.messagesMap, serviceView.messagesMap);
  }

  @Override
  public int hashCode() {
    return Objects.hash(service, messagesMap);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ServiceView {\n");
    sb.append("    service: ").append(toIndentedString(service)).append("\n");
    sb.append("    messagesMap: ").append(toIndentedString(messagesMap)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `service` to the URL query string
    if (getService() != null) {
      joiner.add(getService().toUrlQueryString(prefix + "service" + suffix));
    }

    // add `messagesMap` to the URL query string
    if (getMessagesMap() != null) {
      for (String _key : getMessagesMap().keySet()) {
        joiner.add(String.format("%smessagesMap%s%s=%s", prefix, suffix,
            "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, _key, containerSuffix),
            getMessagesMap().get(_key), URLEncoder.encode(ApiClient.valueToString(getMessagesMap().get(_key)), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
      }
    }

    return joiner.toString();
  }
}

