/*
 * Microcks API v1.10
 * API offered by Microcks, the Kubernetes native tool for API and microservices mocking and testing (microcks.io)
 *
 * The version of the OpenAPI document: 1.10.1
 * Contact: laurent@microcks.io
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.github.microcks.client.model;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.StringJoiner;
import java.util.Objects;
import java.util.Map;
import java.util.HashMap;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.github.microcks.client.model.HeaderDTO;
import io.github.microcks.client.model.OAuth2AuthorizedClient;
import io.github.microcks.client.model.SecretRef;
import io.github.microcks.client.model.TestCaseResult;
import io.github.microcks.client.model.TestRunnerType;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;


import io.github.microcks.client.ApiClient;
/**
 * Represents the result of a Service or API test run by Microcks. Tests are related to a service and made of multiple test cases corresponding to each operations / actions composing service. Tests are run against a specific endpoint named testedEndpoint. It holds global markers telling if test still ran, is a success, how many times is has taken and so on ...
 */
@JsonPropertyOrder({
  TestResult.JSON_PROPERTY_ID,
  TestResult.JSON_PROPERTY_VERSION,
  TestResult.JSON_PROPERTY_TEST_NUMBER,
  TestResult.JSON_PROPERTY_TEST_DATE,
  TestResult.JSON_PROPERTY_TESTED_ENDPOINT,
  TestResult.JSON_PROPERTY_SERVICE_ID,
  TestResult.JSON_PROPERTY_ELAPSED_TIME,
  TestResult.JSON_PROPERTY_SUCCESS,
  TestResult.JSON_PROPERTY_IN_PROGRESS,
  TestResult.JSON_PROPERTY_RUNNER_TYPE,
  TestResult.JSON_PROPERTY_TEST_CASE_RESULTS,
  TestResult.JSON_PROPERTY_SECRET_REF,
  TestResult.JSON_PROPERTY_OPERATION_HEADERS,
  TestResult.JSON_PROPERTY_TIMEOUT,
  TestResult.JSON_PROPERTY_AUTHORIZED_CLIENT
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-01-06T15:57:00.387475551Z[Etc/UTC]", comments = "Generator version: 7.7.0")
public class TestResult {
  public static final String JSON_PROPERTY_ID = "id";
  private String id;

  public static final String JSON_PROPERTY_VERSION = "version";
  private BigDecimal version;

  public static final String JSON_PROPERTY_TEST_NUMBER = "testNumber";
  private BigDecimal testNumber;

  public static final String JSON_PROPERTY_TEST_DATE = "testDate";
  private Long testDate;

  public static final String JSON_PROPERTY_TESTED_ENDPOINT = "testedEndpoint";
  private String testedEndpoint;

  public static final String JSON_PROPERTY_SERVICE_ID = "serviceId";
  private String serviceId;

  public static final String JSON_PROPERTY_ELAPSED_TIME = "elapsedTime";
  private BigDecimal elapsedTime;

  public static final String JSON_PROPERTY_SUCCESS = "success";
  private Boolean success;

  public static final String JSON_PROPERTY_IN_PROGRESS = "inProgress";
  private Boolean inProgress;

  public static final String JSON_PROPERTY_RUNNER_TYPE = "runnerType";
  private TestRunnerType runnerType;

  public static final String JSON_PROPERTY_TEST_CASE_RESULTS = "testCaseResults";
  private List<TestCaseResult> testCaseResults = new ArrayList<>();

  public static final String JSON_PROPERTY_SECRET_REF = "secretRef";
  private SecretRef secretRef;

  public static final String JSON_PROPERTY_OPERATION_HEADERS = "operationHeaders";
  private Map<String, List<HeaderDTO>> operationHeaders = new HashMap<>();

  public static final String JSON_PROPERTY_TIMEOUT = "timeout";
  private Integer timeout;

  public static final String JSON_PROPERTY_AUTHORIZED_CLIENT = "authorizedClient";
  private OAuth2AuthorizedClient authorizedClient;

  public TestResult() { 
  }

  public TestResult id(String id) {
    this.id = id;
    return this;
  }

  /**
   * Unique identifier of TestResult
   * @return id
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public String getId() {
    return id;
  }


  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setId(String id) {
    this.id = id;
  }


  public TestResult version(BigDecimal version) {
    this.version = version;
    return this;
  }

  /**
   * Revision number of this test
   * @return version
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_VERSION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public BigDecimal getVersion() {
    return version;
  }


  @JsonProperty(JSON_PROPERTY_VERSION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setVersion(BigDecimal version) {
    this.version = version;
  }


  public TestResult testNumber(BigDecimal testNumber) {
    this.testNumber = testNumber;
    return this;
  }

  /**
   * Incremental number for tracking number of tests of a service
   * @return testNumber
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_TEST_NUMBER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public BigDecimal getTestNumber() {
    return testNumber;
  }


  @JsonProperty(JSON_PROPERTY_TEST_NUMBER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setTestNumber(BigDecimal testNumber) {
    this.testNumber = testNumber;
  }


  public TestResult testDate(Long testDate) {
    this.testDate = testDate;
    return this;
  }

  /**
   * Timestamp of creation date of this service
   * @return testDate
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_TEST_DATE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public Long getTestDate() {
    return testDate;
  }


  @JsonProperty(JSON_PROPERTY_TEST_DATE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setTestDate(Long testDate) {
    this.testDate = testDate;
  }


  public TestResult testedEndpoint(String testedEndpoint) {
    this.testedEndpoint = testedEndpoint;
    return this;
  }

  /**
   * Endpoint used during test
   * @return testedEndpoint
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_TESTED_ENDPOINT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public String getTestedEndpoint() {
    return testedEndpoint;
  }


  @JsonProperty(JSON_PROPERTY_TESTED_ENDPOINT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setTestedEndpoint(String testedEndpoint) {
    this.testedEndpoint = testedEndpoint;
  }


  public TestResult serviceId(String serviceId) {
    this.serviceId = serviceId;
    return this;
  }

  /**
   * Unique identifier of service tested
   * @return serviceId
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_SERVICE_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public String getServiceId() {
    return serviceId;
  }


  @JsonProperty(JSON_PROPERTY_SERVICE_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setServiceId(String serviceId) {
    this.serviceId = serviceId;
  }


  public TestResult elapsedTime(BigDecimal elapsedTime) {
    this.elapsedTime = elapsedTime;
    return this;
  }

  /**
   * Elapsed time in milliseconds since test beginning
   * @return elapsedTime
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ELAPSED_TIME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public BigDecimal getElapsedTime() {
    return elapsedTime;
  }


  @JsonProperty(JSON_PROPERTY_ELAPSED_TIME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setElapsedTime(BigDecimal elapsedTime) {
    this.elapsedTime = elapsedTime;
  }


  public TestResult success(Boolean success) {
    this.success = success;
    return this;
  }

  /**
   * Flag telling if test is a success
   * @return success
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_SUCCESS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public Boolean getSuccess() {
    return success;
  }


  @JsonProperty(JSON_PROPERTY_SUCCESS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSuccess(Boolean success) {
    this.success = success;
  }


  public TestResult inProgress(Boolean inProgress) {
    this.inProgress = inProgress;
    return this;
  }

  /**
   * Flag telling is test is still in progress
   * @return inProgress
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_IN_PROGRESS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public Boolean getInProgress() {
    return inProgress;
  }


  @JsonProperty(JSON_PROPERTY_IN_PROGRESS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setInProgress(Boolean inProgress) {
    this.inProgress = inProgress;
  }


  public TestResult runnerType(TestRunnerType runnerType) {
    this.runnerType = runnerType;
    return this;
  }

  /**
   * Get runnerType
   * @return runnerType
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_RUNNER_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public TestRunnerType getRunnerType() {
    return runnerType;
  }


  @JsonProperty(JSON_PROPERTY_RUNNER_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setRunnerType(TestRunnerType runnerType) {
    this.runnerType = runnerType;
  }


  public TestResult testCaseResults(List<TestCaseResult> testCaseResults) {
    this.testCaseResults = testCaseResults;
    return this;
  }

  public TestResult addTestCaseResultsItem(TestCaseResult testCaseResultsItem) {
    if (this.testCaseResults == null) {
      this.testCaseResults = new ArrayList<>();
    }
    this.testCaseResults.add(testCaseResultsItem);
    return this;
  }

  /**
   * TestCase results associated to this test
   * @return testCaseResults
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_TEST_CASE_RESULTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public List<TestCaseResult> getTestCaseResults() {
    return testCaseResults;
  }


  @JsonProperty(JSON_PROPERTY_TEST_CASE_RESULTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTestCaseResults(List<TestCaseResult> testCaseResults) {
    this.testCaseResults = testCaseResults;
  }


  public TestResult secretRef(SecretRef secretRef) {
    this.secretRef = secretRef;
    return this;
  }

  /**
   * Get secretRef
   * @return secretRef
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_SECRET_REF)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public SecretRef getSecretRef() {
    return secretRef;
  }


  @JsonProperty(JSON_PROPERTY_SECRET_REF)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSecretRef(SecretRef secretRef) {
    this.secretRef = secretRef;
  }


  public TestResult operationHeaders(Map<String, List<HeaderDTO>> operationHeaders) {
    this.operationHeaders = operationHeaders;
    return this;
  }

  public TestResult putOperationHeadersItem(String key, List<HeaderDTO> operationHeadersItem) {
    if (this.operationHeaders == null) {
      this.operationHeaders = new HashMap<>();
    }
    this.operationHeaders.put(key, operationHeadersItem);
    return this;
  }

  /**
   * Specification of additional headers for a Service/API operations. Keys are operation name or \&quot;globals\&quot; (if header applies to all), values are Header objects DTO.
   * @return operationHeaders
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_OPERATION_HEADERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Map<String, List<HeaderDTO>> getOperationHeaders() {
    return operationHeaders;
  }


  @JsonProperty(JSON_PROPERTY_OPERATION_HEADERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOperationHeaders(Map<String, List<HeaderDTO>> operationHeaders) {
    this.operationHeaders = operationHeaders;
  }


  public TestResult timeout(Integer timeout) {
    this.timeout = timeout;
    return this;
  }

  /**
   * The maximum time (in milliseconds) to wait for this test ends
   * @return timeout
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_TIMEOUT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Integer getTimeout() {
    return timeout;
  }


  @JsonProperty(JSON_PROPERTY_TIMEOUT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTimeout(Integer timeout) {
    this.timeout = timeout;
  }


  public TestResult authorizedClient(OAuth2AuthorizedClient authorizedClient) {
    this.authorizedClient = authorizedClient;
    return this;
  }

  /**
   * Get authorizedClient
   * @return authorizedClient
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_AUTHORIZED_CLIENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public OAuth2AuthorizedClient getAuthorizedClient() {
    return authorizedClient;
  }


  @JsonProperty(JSON_PROPERTY_AUTHORIZED_CLIENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAuthorizedClient(OAuth2AuthorizedClient authorizedClient) {
    this.authorizedClient = authorizedClient;
  }


  /**
   * Return true if this TestResult object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    TestResult testResult = (TestResult) o;
    return Objects.equals(this.id, testResult.id) &&
        Objects.equals(this.version, testResult.version) &&
        Objects.equals(this.testNumber, testResult.testNumber) &&
        Objects.equals(this.testDate, testResult.testDate) &&
        Objects.equals(this.testedEndpoint, testResult.testedEndpoint) &&
        Objects.equals(this.serviceId, testResult.serviceId) &&
        Objects.equals(this.elapsedTime, testResult.elapsedTime) &&
        Objects.equals(this.success, testResult.success) &&
        Objects.equals(this.inProgress, testResult.inProgress) &&
        Objects.equals(this.runnerType, testResult.runnerType) &&
        Objects.equals(this.testCaseResults, testResult.testCaseResults) &&
        Objects.equals(this.secretRef, testResult.secretRef) &&
        Objects.equals(this.operationHeaders, testResult.operationHeaders) &&
        Objects.equals(this.timeout, testResult.timeout) &&
        Objects.equals(this.authorizedClient, testResult.authorizedClient);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, version, testNumber, testDate, testedEndpoint, serviceId, elapsedTime, success, inProgress, runnerType, testCaseResults, secretRef, operationHeaders, timeout, authorizedClient);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class TestResult {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    version: ").append(toIndentedString(version)).append("\n");
    sb.append("    testNumber: ").append(toIndentedString(testNumber)).append("\n");
    sb.append("    testDate: ").append(toIndentedString(testDate)).append("\n");
    sb.append("    testedEndpoint: ").append(toIndentedString(testedEndpoint)).append("\n");
    sb.append("    serviceId: ").append(toIndentedString(serviceId)).append("\n");
    sb.append("    elapsedTime: ").append(toIndentedString(elapsedTime)).append("\n");
    sb.append("    success: ").append(toIndentedString(success)).append("\n");
    sb.append("    inProgress: ").append(toIndentedString(inProgress)).append("\n");
    sb.append("    runnerType: ").append(toIndentedString(runnerType)).append("\n");
    sb.append("    testCaseResults: ").append(toIndentedString(testCaseResults)).append("\n");
    sb.append("    secretRef: ").append(toIndentedString(secretRef)).append("\n");
    sb.append("    operationHeaders: ").append(toIndentedString(operationHeaders)).append("\n");
    sb.append("    timeout: ").append(toIndentedString(timeout)).append("\n");
    sb.append("    authorizedClient: ").append(toIndentedString(authorizedClient)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `id` to the URL query string
    if (getId() != null) {
      joiner.add(String.format("%sid%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getId()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `version` to the URL query string
    if (getVersion() != null) {
      joiner.add(String.format("%sversion%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getVersion()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `testNumber` to the URL query string
    if (getTestNumber() != null) {
      joiner.add(String.format("%stestNumber%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getTestNumber()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `testDate` to the URL query string
    if (getTestDate() != null) {
      joiner.add(String.format("%stestDate%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getTestDate()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `testedEndpoint` to the URL query string
    if (getTestedEndpoint() != null) {
      joiner.add(String.format("%stestedEndpoint%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getTestedEndpoint()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `serviceId` to the URL query string
    if (getServiceId() != null) {
      joiner.add(String.format("%sserviceId%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getServiceId()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `elapsedTime` to the URL query string
    if (getElapsedTime() != null) {
      joiner.add(String.format("%selapsedTime%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getElapsedTime()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `success` to the URL query string
    if (getSuccess() != null) {
      joiner.add(String.format("%ssuccess%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getSuccess()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `inProgress` to the URL query string
    if (getInProgress() != null) {
      joiner.add(String.format("%sinProgress%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getInProgress()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `runnerType` to the URL query string
    if (getRunnerType() != null) {
      joiner.add(String.format("%srunnerType%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getRunnerType()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `testCaseResults` to the URL query string
    if (getTestCaseResults() != null) {
      for (int i = 0; i < getTestCaseResults().size(); i++) {
        if (getTestCaseResults().get(i) != null) {
          joiner.add(getTestCaseResults().get(i).toUrlQueryString(String.format("%stestCaseResults%s%s", prefix, suffix,
          "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
        }
      }
    }

    // add `secretRef` to the URL query string
    if (getSecretRef() != null) {
      joiner.add(getSecretRef().toUrlQueryString(prefix + "secretRef" + suffix));
    }

    // add `operationHeaders` to the URL query string
    if (getOperationHeaders() != null) {
      for (String _key : getOperationHeaders().keySet()) {
        joiner.add(String.format("%soperationHeaders%s%s=%s", prefix, suffix,
            "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, _key, containerSuffix),
            getOperationHeaders().get(_key), URLEncoder.encode(ApiClient.valueToString(getOperationHeaders().get(_key)), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
      }
    }

    // add `timeout` to the URL query string
    if (getTimeout() != null) {
      joiner.add(String.format("%stimeout%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getTimeout()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `authorizedClient` to the URL query string
    if (getAuthorizedClient() != null) {
      joiner.add(getAuthorizedClient().toUrlQueryString(prefix + "authorizedClient" + suffix));
    }

    return joiner.toString();
  }
}

