/*
 * Microcks API v1.10
 * API offered by Microcks, the Kubernetes native tool for API and microservices mocking and testing (microcks.io)
 *
 * The version of the OpenAPI document: 1.10.1
 * Contact: laurent@microcks.io
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.github.microcks.client.model;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.StringJoiner;
import java.util.Objects;
import java.util.Map;
import java.util.HashMap;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.github.microcks.client.model.EventMessage;
import io.github.microcks.client.model.Request;
import io.github.microcks.client.model.Response;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;


import io.github.microcks.client.ApiClient;
/**
 * TestReturn is used for wrapping the return code of a test step execution
 */
@JsonPropertyOrder({
  TestReturn.JSON_PROPERTY_CODE,
  TestReturn.JSON_PROPERTY_ELAPSED_TIME,
  TestReturn.JSON_PROPERTY_MESSAGE,
  TestReturn.JSON_PROPERTY_REQUEST,
  TestReturn.JSON_PROPERTY_RESPONSE,
  TestReturn.JSON_PROPERTY_EVENT_MESSAGE
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-01-06T15:57:00.387475551Z[Etc/UTC]", comments = "Generator version: 7.7.0")
public class TestReturn {
  public static final String JSON_PROPERTY_CODE = "code";
  private Integer code;

  public static final String JSON_PROPERTY_ELAPSED_TIME = "elapsedTime";
  private Long elapsedTime;

  public static final String JSON_PROPERTY_MESSAGE = "message";
  private String message;

  public static final String JSON_PROPERTY_REQUEST = "request";
  private Request request;

  public static final String JSON_PROPERTY_RESPONSE = "response";
  private Response response;

  public static final String JSON_PROPERTY_EVENT_MESSAGE = "eventMessage";
  private EventMessage eventMessage;

  public TestReturn() { 
  }

  public TestReturn code(Integer code) {
    this.code = code;
    return this;
  }

  /**
   * Return code for test (0 means Success, 1 means Failure)
   * @return code
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_CODE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public Integer getCode() {
    return code;
  }


  @JsonProperty(JSON_PROPERTY_CODE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCode(Integer code) {
    this.code = code;
  }


  public TestReturn elapsedTime(Long elapsedTime) {
    this.elapsedTime = elapsedTime;
    return this;
  }

  /**
   * Elapsed time in milliseconds
   * @return elapsedTime
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_ELAPSED_TIME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public Long getElapsedTime() {
    return elapsedTime;
  }


  @JsonProperty(JSON_PROPERTY_ELAPSED_TIME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setElapsedTime(Long elapsedTime) {
    this.elapsedTime = elapsedTime;
  }


  public TestReturn message(String message) {
    this.message = message;
    return this;
  }

  /**
   * Error message if any
   * @return message
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_MESSAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getMessage() {
    return message;
  }


  @JsonProperty(JSON_PROPERTY_MESSAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMessage(String message) {
    this.message = message;
  }


  public TestReturn request(Request request) {
    this.request = request;
    return this;
  }

  /**
   * Get request
   * @return request
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_REQUEST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Request getRequest() {
    return request;
  }


  @JsonProperty(JSON_PROPERTY_REQUEST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRequest(Request request) {
    this.request = request;
  }


  public TestReturn response(Response response) {
    this.response = response;
    return this;
  }

  /**
   * Get response
   * @return response
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_RESPONSE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Response getResponse() {
    return response;
  }


  @JsonProperty(JSON_PROPERTY_RESPONSE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setResponse(Response response) {
    this.response = response;
  }


  public TestReturn eventMessage(EventMessage eventMessage) {
    this.eventMessage = eventMessage;
    return this;
  }

  /**
   * Get eventMessage
   * @return eventMessage
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_EVENT_MESSAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public EventMessage getEventMessage() {
    return eventMessage;
  }


  @JsonProperty(JSON_PROPERTY_EVENT_MESSAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEventMessage(EventMessage eventMessage) {
    this.eventMessage = eventMessage;
  }


  /**
   * Return true if this TestReturn object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    TestReturn testReturn = (TestReturn) o;
    return Objects.equals(this.code, testReturn.code) &&
        Objects.equals(this.elapsedTime, testReturn.elapsedTime) &&
        Objects.equals(this.message, testReturn.message) &&
        Objects.equals(this.request, testReturn.request) &&
        Objects.equals(this.response, testReturn.response) &&
        Objects.equals(this.eventMessage, testReturn.eventMessage);
  }

  @Override
  public int hashCode() {
    return Objects.hash(code, elapsedTime, message, request, response, eventMessage);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class TestReturn {\n");
    sb.append("    code: ").append(toIndentedString(code)).append("\n");
    sb.append("    elapsedTime: ").append(toIndentedString(elapsedTime)).append("\n");
    sb.append("    message: ").append(toIndentedString(message)).append("\n");
    sb.append("    request: ").append(toIndentedString(request)).append("\n");
    sb.append("    response: ").append(toIndentedString(response)).append("\n");
    sb.append("    eventMessage: ").append(toIndentedString(eventMessage)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `code` to the URL query string
    if (getCode() != null) {
      joiner.add(String.format("%scode%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getCode()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `elapsedTime` to the URL query string
    if (getElapsedTime() != null) {
      joiner.add(String.format("%selapsedTime%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getElapsedTime()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `message` to the URL query string
    if (getMessage() != null) {
      joiner.add(String.format("%smessage%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getMessage()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `request` to the URL query string
    if (getRequest() != null) {
      joiner.add(getRequest().toUrlQueryString(prefix + "request" + suffix));
    }

    // add `response` to the URL query string
    if (getResponse() != null) {
      joiner.add(getResponse().toUrlQueryString(prefix + "response" + suffix));
    }

    // add `eventMessage` to the URL query string
    if (getEventMessage() != null) {
      joiner.add(getEventMessage().toUrlQueryString(prefix + "eventMessage" + suffix));
    }

    return joiner.toString();
  }
}

