/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum ResourceType {
    WSDL("WSDL"),
    XSD("XSD"),
    JSON_SCHEMA("JSON_SCHEMA"),
    OPEN_API_SPEC("OPEN_API_SPEC"),
    OPEN_API_SCHEMA("OPEN_API_SCHEMA"),
    ASYNC_API_SPEC("ASYNC_API_SPEC"),
    ASYNC_API_SCHEMA("ASYNC_API_SCHEMA"),
    AVRO_SCHEMA("AVRO_SCHEMA"),
    PROTOBUF_SCHEMA("PROTOBUF_SCHEMA"),
    PROTOBUF_DESCRIPTION("PROTOBUF_DESCRIPTION"),
    GRAPHQL_SCHEMA("GRAPHQL_SCHEMA"),
    POSTMAN_COLLECTION("POSTMAN_COLLECTION");

    private String value;

    private ResourceType(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    @JsonCreator
    public static ResourceType fromValue(String value) {
        for (ResourceType b : ResourceType.values()) {
            if (!b.value.equals(value)) continue;
            return b;
        }
        throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public String toUrlQueryString(String prefix) {
        if (prefix == null) {
            prefix = "";
        }
        return String.format("%s=%s", prefix, this.toString());
    }
}

