/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.github.microcks.client.ApiClient;
import io.github.microcks.client.model.Metadata;
import io.github.microcks.client.model.Operation;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"id", "name", "version", "type", "operations", "xmlNS", "metadata", "sourceArtifact"})
public class Service {
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_VERSION = "version";
    private String version;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;
    public static final String JSON_PROPERTY_OPERATIONS = "operations";
    private List<Operation> operations = new ArrayList<Operation>();
    public static final String JSON_PROPERTY_XML_N_S = "xmlNS";
    private String xmlNS;
    public static final String JSON_PROPERTY_METADATA = "metadata";
    private Metadata metadata;
    public static final String JSON_PROPERTY_SOURCE_ARTIFACT = "sourceArtifact";
    private String sourceArtifact;

    public Service id(String id) {
        this.id = id;
        return this;
    }

    @Nullable
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setId(String id) {
        this.id = id;
    }

    public Service name(String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(String name) {
        this.name = name;
    }

    public Service version(String version) {
        this.version = version;
        return this;
    }

    @Nonnull
    @JsonProperty(value="version")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getVersion() {
        return this.version;
    }

    @JsonProperty(value="version")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setVersion(String version) {
        this.version = version;
    }

    public Service type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nonnull
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public Service operations(List<Operation> operations) {
        this.operations = operations;
        return this;
    }

    public Service addOperationsItem(Operation operationsItem) {
        if (this.operations == null) {
            this.operations = new ArrayList<Operation>();
        }
        this.operations.add(operationsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="operations")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Operation> getOperations() {
        return this.operations;
    }

    @JsonProperty(value="operations")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOperations(List<Operation> operations) {
        this.operations = operations;
    }

    public Service xmlNS(String xmlNS) {
        this.xmlNS = xmlNS;
        return this;
    }

    @Nullable
    @JsonProperty(value="xmlNS")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getXmlNS() {
        return this.xmlNS;
    }

    @JsonProperty(value="xmlNS")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setXmlNS(String xmlNS) {
        this.xmlNS = xmlNS;
    }

    public Service metadata(Metadata metadata) {
        this.metadata = metadata;
        return this;
    }

    @Nullable
    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Metadata getMetadata() {
        return this.metadata;
    }

    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMetadata(Metadata metadata) {
        this.metadata = metadata;
    }

    public Service sourceArtifact(String sourceArtifact) {
        this.sourceArtifact = sourceArtifact;
        return this;
    }

    @Nonnull
    @JsonProperty(value="sourceArtifact")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getSourceArtifact() {
        return this.sourceArtifact;
    }

    @JsonProperty(value="sourceArtifact")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSourceArtifact(String sourceArtifact) {
        this.sourceArtifact = sourceArtifact;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Service service = (Service)o;
        return Objects.equals(this.id, service.id) && Objects.equals(this.name, service.name) && Objects.equals(this.version, service.version) && Objects.equals((Object)this.type, (Object)service.type) && Objects.equals(this.operations, service.operations) && Objects.equals(this.xmlNS, service.xmlNS) && Objects.equals(this.metadata, service.metadata) && Objects.equals(this.sourceArtifact, service.sourceArtifact);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.version, this.type, this.operations, this.xmlNS, this.metadata, this.sourceArtifact});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Service {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    operations: ").append(this.toIndentedString(this.operations)).append("\n");
        sb.append("    xmlNS: ").append(this.toIndentedString(this.xmlNS)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    sourceArtifact: ").append(this.toIndentedString(this.sourceArtifact)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getId() != null) {
            joiner.add(String.format("%sid%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(this.getId()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getName() != null) {
            joiner.add(String.format("%sname%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(this.getName()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getVersion() != null) {
            joiner.add(String.format("%sversion%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(this.getVersion()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getType() != null) {
            joiner.add(String.format("%stype%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString((Object)this.getType()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getOperations() != null) {
            for (int i = 0; i < this.getOperations().size(); ++i) {
                if (this.getOperations().get(i) == null) continue;
                joiner.add(this.getOperations().get(i).toUrlQueryString(String.format("%soperations%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
            }
        }
        if (this.getXmlNS() != null) {
            joiner.add(String.format("%sxmlNS%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(this.getXmlNS()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getMetadata() != null) {
            joiner.add(this.getMetadata().toUrlQueryString((String)prefix + JSON_PROPERTY_METADATA + suffix));
        }
        if (this.getSourceArtifact() != null) {
            joiner.add(String.format("%ssourceArtifact%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(this.getSourceArtifact()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        return joiner.toString();
    }

    public static enum TypeEnum {
        REST("REST"),
        SOAP_HTTP("SOAP_HTTP"),
        GENERIC_REST("GENERIC_REST"),
        GENERIC_EVENT("GENERIC_EVENT"),
        EVENT("EVENT"),
        GRPC("GRPC"),
        GRAPHQL("GRAPHQL");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

