/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.github.microcks.client.ApiClient;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"type", "keyType", "destinationType", "destinationName", "qoS", "persistent", "method"})
public class Binding {
    public static final String JSON_PROPERTY_TYPE = "type";
    @Nonnull
    private TypeEnum type;
    public static final String JSON_PROPERTY_KEY_TYPE = "keyType";
    @Nullable
    private String keyType;
    public static final String JSON_PROPERTY_DESTINATION_TYPE = "destinationType";
    @Nullable
    private String destinationType;
    public static final String JSON_PROPERTY_DESTINATION_NAME = "destinationName";
    @Nonnull
    private String destinationName;
    public static final String JSON_PROPERTY_QO_S = "qoS";
    @Nullable
    private String qoS;
    public static final String JSON_PROPERTY_PERSISTENT = "persistent";
    @Nullable
    private Boolean persistent;
    public static final String JSON_PROPERTY_METHOD = "method";
    @Nullable
    private String method;

    public Binding type(@Nonnull TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nonnull
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setType(@Nonnull TypeEnum type) {
        this.type = type;
    }

    public Binding keyType(@Nullable String keyType) {
        this.keyType = keyType;
        return this;
    }

    @Nullable
    @JsonProperty(value="keyType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getKeyType() {
        return this.keyType;
    }

    @JsonProperty(value="keyType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setKeyType(@Nullable String keyType) {
        this.keyType = keyType;
    }

    public Binding destinationType(@Nullable String destinationType) {
        this.destinationType = destinationType;
        return this;
    }

    @Nullable
    @JsonProperty(value="destinationType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDestinationType() {
        return this.destinationType;
    }

    @JsonProperty(value="destinationType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDestinationType(@Nullable String destinationType) {
        this.destinationType = destinationType;
    }

    public Binding destinationName(@Nonnull String destinationName) {
        this.destinationName = destinationName;
        return this;
    }

    @Nonnull
    @JsonProperty(value="destinationName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getDestinationName() {
        return this.destinationName;
    }

    @JsonProperty(value="destinationName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDestinationName(@Nonnull String destinationName) {
        this.destinationName = destinationName;
    }

    public Binding qoS(@Nullable String qoS) {
        this.qoS = qoS;
        return this;
    }

    @Nullable
    @JsonProperty(value="qoS")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getQoS() {
        return this.qoS;
    }

    @JsonProperty(value="qoS")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setQoS(@Nullable String qoS) {
        this.qoS = qoS;
    }

    public Binding persistent(@Nullable Boolean persistent) {
        this.persistent = persistent;
        return this;
    }

    @Nullable
    @JsonProperty(value="persistent")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getPersistent() {
        return this.persistent;
    }

    @JsonProperty(value="persistent")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPersistent(@Nullable Boolean persistent) {
        this.persistent = persistent;
    }

    public Binding method(@Nullable String method) {
        this.method = method;
        return this;
    }

    @Nullable
    @JsonProperty(value="method")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMethod() {
        return this.method;
    }

    @JsonProperty(value="method")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMethod(@Nullable String method) {
        this.method = method;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Binding binding = (Binding)o;
        return Objects.equals((Object)this.type, (Object)binding.type) && Objects.equals(this.keyType, binding.keyType) && Objects.equals(this.destinationType, binding.destinationType) && Objects.equals(this.destinationName, binding.destinationName) && Objects.equals(this.qoS, binding.qoS) && Objects.equals(this.persistent, binding.persistent) && Objects.equals(this.method, binding.method);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.keyType, this.destinationType, this.destinationName, this.qoS, this.persistent, this.method});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Binding {\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    keyType: ").append(this.toIndentedString(this.keyType)).append("\n");
        sb.append("    destinationType: ").append(this.toIndentedString(this.destinationType)).append("\n");
        sb.append("    destinationName: ").append(this.toIndentedString(this.destinationName)).append("\n");
        sb.append("    qoS: ").append(this.toIndentedString(this.qoS)).append("\n");
        sb.append("    persistent: ").append(this.toIndentedString(this.persistent)).append("\n");
        sb.append("    method: ").append(this.toIndentedString(this.method)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getType() != null) {
            joiner.add(String.format("%stype%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString((Object)this.getType()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getKeyType() != null) {
            joiner.add(String.format("%skeyType%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(this.getKeyType()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getDestinationType() != null) {
            joiner.add(String.format("%sdestinationType%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(this.getDestinationType()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getDestinationName() != null) {
            joiner.add(String.format("%sdestinationName%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(this.getDestinationName()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getQoS() != null) {
            joiner.add(String.format("%sqoS%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(this.getQoS()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getPersistent() != null) {
            joiner.add(String.format("%spersistent%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(this.getPersistent()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getMethod() != null) {
            joiner.add(String.format("%smethod%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(this.getMethod()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        return joiner.toString();
    }

    public static enum TypeEnum {
        KAFKA(String.valueOf("KAFKA")),
        MQTT(String.valueOf("MQTT")),
        WS(String.valueOf("WS")),
        AMQP(String.valueOf("AMQP")),
        NATS(String.valueOf("NATS")),
        GOOGLEPUBSUB(String.valueOf("GOOGLEPUBSUB"));

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

