/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.github.microcks.client.ApiClient;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"createdOn", "lastUpdate", "annotations", "labels"})
public class Metadata {
    public static final String JSON_PROPERTY_CREATED_ON = "createdOn";
    @Nonnull
    private BigDecimal createdOn;
    public static final String JSON_PROPERTY_LAST_UPDATE = "lastUpdate";
    @Nonnull
    private BigDecimal lastUpdate;
    public static final String JSON_PROPERTY_ANNOTATIONS = "annotations";
    @Nullable
    private Map<String, String> annotations = new HashMap<String, String>();
    public static final String JSON_PROPERTY_LABELS = "labels";
    @Nullable
    private Map<String, String> labels = new HashMap<String, String>();

    public Metadata() {
    }

    @JsonCreator
    public Metadata(@JsonProperty(value="createdOn") BigDecimal createdOn, @JsonProperty(value="lastUpdate") BigDecimal lastUpdate) {
        this();
        this.createdOn = createdOn;
        this.lastUpdate = lastUpdate;
    }

    @Nonnull
    @JsonProperty(value="createdOn")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public BigDecimal getCreatedOn() {
        return this.createdOn;
    }

    @Nonnull
    @JsonProperty(value="lastUpdate")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public BigDecimal getLastUpdate() {
        return this.lastUpdate;
    }

    public Metadata annotations(@Nullable Map<String, String> annotations) {
        this.annotations = annotations;
        return this;
    }

    public Metadata putAnnotationsItem(String key, String annotationsItem) {
        if (this.annotations == null) {
            this.annotations = new HashMap<String, String>();
        }
        this.annotations.put(key, annotationsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="annotations")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, String> getAnnotations() {
        return this.annotations;
    }

    @JsonProperty(value="annotations")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAnnotations(@Nullable Map<String, String> annotations) {
        this.annotations = annotations;
    }

    public Metadata labels(@Nullable Map<String, String> labels) {
        this.labels = labels;
        return this;
    }

    public Metadata putLabelsItem(String key, String labelsItem) {
        if (this.labels == null) {
            this.labels = new HashMap<String, String>();
        }
        this.labels.put(key, labelsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="labels")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, String> getLabels() {
        return this.labels;
    }

    @JsonProperty(value="labels")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLabels(@Nullable Map<String, String> labels) {
        this.labels = labels;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Metadata metadata = (Metadata)o;
        return Objects.equals(this.createdOn, metadata.createdOn) && Objects.equals(this.lastUpdate, metadata.lastUpdate) && Objects.equals(this.annotations, metadata.annotations) && Objects.equals(this.labels, metadata.labels);
    }

    public int hashCode() {
        return Objects.hash(this.createdOn, this.lastUpdate, this.annotations, this.labels);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Metadata {\n");
        sb.append("    createdOn: ").append(this.toIndentedString(this.createdOn)).append("\n");
        sb.append("    lastUpdate: ").append(this.toIndentedString(this.lastUpdate)).append("\n");
        sb.append("    annotations: ").append(this.toIndentedString(this.annotations)).append("\n");
        sb.append("    labels: ").append(this.toIndentedString(this.labels)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getCreatedOn() != null) {
            joiner.add(String.format("%screatedOn%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(this.getCreatedOn()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getLastUpdate() != null) {
            joiner.add(String.format("%slastUpdate%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(this.getLastUpdate()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getAnnotations() != null) {
            for (String _key : this.getAnnotations().keySet()) {
                joiner.add(String.format("%sannotations%s%s=%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, _key, containerSuffix), this.getAnnotations().get(_key), URLEncoder.encode(ApiClient.valueToString(this.getAnnotations().get(_key)), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
            }
        }
        if (this.getLabels() != null) {
            for (String _key : this.getLabels().keySet()) {
                joiner.add(String.format("%slabels%s%s=%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, _key, containerSuffix), this.getLabels().get(_key), URLEncoder.encode(ApiClient.valueToString(this.getLabels().get(_key)), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
            }
        }
        return joiner.toString();
    }
}

