/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.github.microcks.client.ApiClient;
import io.github.microcks.client.model.HeaderDTO;
import io.github.microcks.client.model.OAuth2AuthorizedClient;
import io.github.microcks.client.model.SecretRef;
import io.github.microcks.client.model.TestCaseResult;
import io.github.microcks.client.model.TestRunnerType;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"id", "version", "testNumber", "testDate", "testedEndpoint", "serviceId", "elapsedTime", "success", "inProgress", "runnerType", "testCaseResults", "secretRef", "operationHeaders", "timeout", "authorizedClient"})
public class TestResult {
    public static final String JSON_PROPERTY_ID = "id";
    @Nonnull
    private String id;
    public static final String JSON_PROPERTY_VERSION = "version";
    @Nonnull
    private BigDecimal version;
    public static final String JSON_PROPERTY_TEST_NUMBER = "testNumber";
    @Nonnull
    private BigDecimal testNumber;
    public static final String JSON_PROPERTY_TEST_DATE = "testDate";
    @Nonnull
    private Long testDate;
    public static final String JSON_PROPERTY_TESTED_ENDPOINT = "testedEndpoint";
    @Nonnull
    private String testedEndpoint;
    public static final String JSON_PROPERTY_SERVICE_ID = "serviceId";
    @Nonnull
    private String serviceId;
    public static final String JSON_PROPERTY_ELAPSED_TIME = "elapsedTime";
    @Nullable
    private BigDecimal elapsedTime;
    public static final String JSON_PROPERTY_SUCCESS = "success";
    @Nonnull
    private Boolean success;
    public static final String JSON_PROPERTY_IN_PROGRESS = "inProgress";
    @Nonnull
    private Boolean inProgress;
    public static final String JSON_PROPERTY_RUNNER_TYPE = "runnerType";
    @Nonnull
    private TestRunnerType runnerType;
    public static final String JSON_PROPERTY_TEST_CASE_RESULTS = "testCaseResults";
    @Nullable
    private List<TestCaseResult> testCaseResults = new ArrayList<TestCaseResult>();
    public static final String JSON_PROPERTY_SECRET_REF = "secretRef";
    @Nullable
    private SecretRef secretRef;
    public static final String JSON_PROPERTY_OPERATION_HEADERS = "operationHeaders";
    @Nullable
    private Map<String, List<HeaderDTO>> operationHeaders = new HashMap<String, List<HeaderDTO>>();
    public static final String JSON_PROPERTY_TIMEOUT = "timeout";
    @Nullable
    private Integer timeout;
    public static final String JSON_PROPERTY_AUTHORIZED_CLIENT = "authorizedClient";
    @Nullable
    private OAuth2AuthorizedClient authorizedClient;

    public TestResult id(@Nonnull String id) {
        this.id = id;
        return this;
    }

    @Nonnull
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setId(@Nonnull String id) {
        this.id = id;
    }

    public TestResult version(@Nonnull BigDecimal version) {
        this.version = version;
        return this;
    }

    @Nonnull
    @JsonProperty(value="version")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public BigDecimal getVersion() {
        return this.version;
    }

    @JsonProperty(value="version")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setVersion(@Nonnull BigDecimal version) {
        this.version = version;
    }

    public TestResult testNumber(@Nonnull BigDecimal testNumber) {
        this.testNumber = testNumber;
        return this;
    }

    @Nonnull
    @JsonProperty(value="testNumber")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public BigDecimal getTestNumber() {
        return this.testNumber;
    }

    @JsonProperty(value="testNumber")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setTestNumber(@Nonnull BigDecimal testNumber) {
        this.testNumber = testNumber;
    }

    public TestResult testDate(@Nonnull Long testDate) {
        this.testDate = testDate;
        return this;
    }

    @Nonnull
    @JsonProperty(value="testDate")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Long getTestDate() {
        return this.testDate;
    }

    @JsonProperty(value="testDate")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setTestDate(@Nonnull Long testDate) {
        this.testDate = testDate;
    }

    public TestResult testedEndpoint(@Nonnull String testedEndpoint) {
        this.testedEndpoint = testedEndpoint;
        return this;
    }

    @Nonnull
    @JsonProperty(value="testedEndpoint")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getTestedEndpoint() {
        return this.testedEndpoint;
    }

    @JsonProperty(value="testedEndpoint")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setTestedEndpoint(@Nonnull String testedEndpoint) {
        this.testedEndpoint = testedEndpoint;
    }

    public TestResult serviceId(@Nonnull String serviceId) {
        this.serviceId = serviceId;
        return this;
    }

    @Nonnull
    @JsonProperty(value="serviceId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getServiceId() {
        return this.serviceId;
    }

    @JsonProperty(value="serviceId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setServiceId(@Nonnull String serviceId) {
        this.serviceId = serviceId;
    }

    public TestResult elapsedTime(@Nullable BigDecimal elapsedTime) {
        this.elapsedTime = elapsedTime;
        return this;
    }

    @Nullable
    @JsonProperty(value="elapsedTime")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public BigDecimal getElapsedTime() {
        return this.elapsedTime;
    }

    @JsonProperty(value="elapsedTime")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setElapsedTime(@Nullable BigDecimal elapsedTime) {
        this.elapsedTime = elapsedTime;
    }

    public TestResult success(@Nonnull Boolean success) {
        this.success = success;
        return this;
    }

    @Nonnull
    @JsonProperty(value="success")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getSuccess() {
        return this.success;
    }

    @JsonProperty(value="success")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSuccess(@Nonnull Boolean success) {
        this.success = success;
    }

    public TestResult inProgress(@Nonnull Boolean inProgress) {
        this.inProgress = inProgress;
        return this;
    }

    @Nonnull
    @JsonProperty(value="inProgress")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getInProgress() {
        return this.inProgress;
    }

    @JsonProperty(value="inProgress")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setInProgress(@Nonnull Boolean inProgress) {
        this.inProgress = inProgress;
    }

    public TestResult runnerType(@Nonnull TestRunnerType runnerType) {
        this.runnerType = runnerType;
        return this;
    }

    @Nonnull
    @JsonProperty(value="runnerType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public TestRunnerType getRunnerType() {
        return this.runnerType;
    }

    @JsonProperty(value="runnerType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setRunnerType(@Nonnull TestRunnerType runnerType) {
        this.runnerType = runnerType;
    }

    public TestResult testCaseResults(@Nullable List<TestCaseResult> testCaseResults) {
        this.testCaseResults = testCaseResults;
        return this;
    }

    public TestResult addTestCaseResultsItem(TestCaseResult testCaseResultsItem) {
        if (this.testCaseResults == null) {
            this.testCaseResults = new ArrayList<TestCaseResult>();
        }
        this.testCaseResults.add(testCaseResultsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="testCaseResults")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<TestCaseResult> getTestCaseResults() {
        return this.testCaseResults;
    }

    @JsonProperty(value="testCaseResults")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTestCaseResults(@Nullable List<TestCaseResult> testCaseResults) {
        this.testCaseResults = testCaseResults;
    }

    public TestResult secretRef(@Nullable SecretRef secretRef) {
        this.secretRef = secretRef;
        return this;
    }

    @Nullable
    @JsonProperty(value="secretRef")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SecretRef getSecretRef() {
        return this.secretRef;
    }

    @JsonProperty(value="secretRef")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSecretRef(@Nullable SecretRef secretRef) {
        this.secretRef = secretRef;
    }

    public TestResult operationHeaders(@Nullable Map<String, List<HeaderDTO>> operationHeaders) {
        this.operationHeaders = operationHeaders;
        return this;
    }

    public TestResult putOperationHeadersItem(String key, List<HeaderDTO> operationHeadersItem) {
        if (this.operationHeaders == null) {
            this.operationHeaders = new HashMap<String, List<HeaderDTO>>();
        }
        this.operationHeaders.put(key, operationHeadersItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="operationHeaders")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, List<HeaderDTO>> getOperationHeaders() {
        return this.operationHeaders;
    }

    @JsonProperty(value="operationHeaders")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOperationHeaders(@Nullable Map<String, List<HeaderDTO>> operationHeaders) {
        this.operationHeaders = operationHeaders;
    }

    public TestResult timeout(@Nullable Integer timeout) {
        this.timeout = timeout;
        return this;
    }

    @Nullable
    @JsonProperty(value="timeout")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getTimeout() {
        return this.timeout;
    }

    @JsonProperty(value="timeout")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTimeout(@Nullable Integer timeout) {
        this.timeout = timeout;
    }

    public TestResult authorizedClient(@Nullable OAuth2AuthorizedClient authorizedClient) {
        this.authorizedClient = authorizedClient;
        return this;
    }

    @Nullable
    @JsonProperty(value="authorizedClient")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OAuth2AuthorizedClient getAuthorizedClient() {
        return this.authorizedClient;
    }

    @JsonProperty(value="authorizedClient")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAuthorizedClient(@Nullable OAuth2AuthorizedClient authorizedClient) {
        this.authorizedClient = authorizedClient;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TestResult testResult = (TestResult)o;
        return Objects.equals(this.id, testResult.id) && Objects.equals(this.version, testResult.version) && Objects.equals(this.testNumber, testResult.testNumber) && Objects.equals(this.testDate, testResult.testDate) && Objects.equals(this.testedEndpoint, testResult.testedEndpoint) && Objects.equals(this.serviceId, testResult.serviceId) && Objects.equals(this.elapsedTime, testResult.elapsedTime) && Objects.equals(this.success, testResult.success) && Objects.equals(this.inProgress, testResult.inProgress) && Objects.equals((Object)this.runnerType, (Object)testResult.runnerType) && Objects.equals(this.testCaseResults, testResult.testCaseResults) && Objects.equals(this.secretRef, testResult.secretRef) && Objects.equals(this.operationHeaders, testResult.operationHeaders) && Objects.equals(this.timeout, testResult.timeout) && Objects.equals(this.authorizedClient, testResult.authorizedClient);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.version, this.testNumber, this.testDate, this.testedEndpoint, this.serviceId, this.elapsedTime, this.success, this.inProgress, this.runnerType, this.testCaseResults, this.secretRef, this.operationHeaders, this.timeout, this.authorizedClient});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TestResult {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    testNumber: ").append(this.toIndentedString(this.testNumber)).append("\n");
        sb.append("    testDate: ").append(this.toIndentedString(this.testDate)).append("\n");
        sb.append("    testedEndpoint: ").append(this.toIndentedString(this.testedEndpoint)).append("\n");
        sb.append("    serviceId: ").append(this.toIndentedString(this.serviceId)).append("\n");
        sb.append("    elapsedTime: ").append(this.toIndentedString(this.elapsedTime)).append("\n");
        sb.append("    success: ").append(this.toIndentedString(this.success)).append("\n");
        sb.append("    inProgress: ").append(this.toIndentedString(this.inProgress)).append("\n");
        sb.append("    runnerType: ").append(this.toIndentedString((Object)this.runnerType)).append("\n");
        sb.append("    testCaseResults: ").append(this.toIndentedString(this.testCaseResults)).append("\n");
        sb.append("    secretRef: ").append(this.toIndentedString(this.secretRef)).append("\n");
        sb.append("    operationHeaders: ").append(this.toIndentedString(this.operationHeaders)).append("\n");
        sb.append("    timeout: ").append(this.toIndentedString(this.timeout)).append("\n");
        sb.append("    authorizedClient: ").append(this.toIndentedString(this.authorizedClient)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getId() != null) {
            joiner.add(String.format("%sid%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(this.getId()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getVersion() != null) {
            joiner.add(String.format("%sversion%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(this.getVersion()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getTestNumber() != null) {
            joiner.add(String.format("%stestNumber%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(this.getTestNumber()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getTestDate() != null) {
            joiner.add(String.format("%stestDate%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(this.getTestDate()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getTestedEndpoint() != null) {
            joiner.add(String.format("%stestedEndpoint%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(this.getTestedEndpoint()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getServiceId() != null) {
            joiner.add(String.format("%sserviceId%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(this.getServiceId()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getElapsedTime() != null) {
            joiner.add(String.format("%selapsedTime%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(this.getElapsedTime()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getSuccess() != null) {
            joiner.add(String.format("%ssuccess%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(this.getSuccess()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getInProgress() != null) {
            joiner.add(String.format("%sinProgress%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(this.getInProgress()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getRunnerType() != null) {
            joiner.add(String.format("%srunnerType%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString((Object)this.getRunnerType()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getTestCaseResults() != null) {
            for (int i = 0; i < this.getTestCaseResults().size(); ++i) {
                if (this.getTestCaseResults().get(i) == null) continue;
                joiner.add(this.getTestCaseResults().get(i).toUrlQueryString(String.format("%stestCaseResults%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
            }
        }
        if (this.getSecretRef() != null) {
            joiner.add(this.getSecretRef().toUrlQueryString((String)prefix + JSON_PROPERTY_SECRET_REF + suffix));
        }
        if (this.getOperationHeaders() != null) {
            for (String _key : this.getOperationHeaders().keySet()) {
                joiner.add(String.format("%soperationHeaders%s%s=%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, _key, containerSuffix), this.getOperationHeaders().get(_key), URLEncoder.encode(ApiClient.valueToString(this.getOperationHeaders().get(_key)), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
            }
        }
        if (this.getTimeout() != null) {
            joiner.add(String.format("%stimeout%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(this.getTimeout()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getAuthorizedClient() != null) {
            joiner.add(this.getAuthorizedClient().toUrlQueryString((String)prefix + JSON_PROPERTY_AUTHORIZED_CLIENT + suffix));
        }
        return joiner.toString();
    }
}

