/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.github.microcks.client.ApiClient;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"id", "day", "serviceName", "serviceVersion", "dailyCount", "hourlyCount", "minuteCount"})
public class DailyInvocationStatistic {
    public static final String JSON_PROPERTY_ID = "id";
    @Nonnull
    private String id;
    public static final String JSON_PROPERTY_DAY = "day";
    @Nonnull
    private String day;
    public static final String JSON_PROPERTY_SERVICE_NAME = "serviceName";
    @Nonnull
    private String serviceName;
    public static final String JSON_PROPERTY_SERVICE_VERSION = "serviceVersion";
    @Nonnull
    private String serviceVersion;
    public static final String JSON_PROPERTY_DAILY_COUNT = "dailyCount";
    @Nonnull
    private BigDecimal dailyCount;
    public static final String JSON_PROPERTY_HOURLY_COUNT = "hourlyCount";
    @Nullable
    private Map<String, Object> hourlyCount = new HashMap<String, Object>();
    public static final String JSON_PROPERTY_MINUTE_COUNT = "minuteCount";
    @Nullable
    private Map<String, Object> minuteCount = new HashMap<String, Object>();

    public DailyInvocationStatistic id(@Nonnull String id) {
        this.id = id;
        return this;
    }

    @Nonnull
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setId(@Nonnull String id) {
        this.id = id;
    }

    public DailyInvocationStatistic day(@Nonnull String day) {
        this.day = day;
        return this;
    }

    @Nonnull
    @JsonProperty(value="day")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getDay() {
        return this.day;
    }

    @JsonProperty(value="day")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDay(@Nonnull String day) {
        this.day = day;
    }

    public DailyInvocationStatistic serviceName(@Nonnull String serviceName) {
        this.serviceName = serviceName;
        return this;
    }

    @Nonnull
    @JsonProperty(value="serviceName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getServiceName() {
        return this.serviceName;
    }

    @JsonProperty(value="serviceName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setServiceName(@Nonnull String serviceName) {
        this.serviceName = serviceName;
    }

    public DailyInvocationStatistic serviceVersion(@Nonnull String serviceVersion) {
        this.serviceVersion = serviceVersion;
        return this;
    }

    @Nonnull
    @JsonProperty(value="serviceVersion")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getServiceVersion() {
        return this.serviceVersion;
    }

    @JsonProperty(value="serviceVersion")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setServiceVersion(@Nonnull String serviceVersion) {
        this.serviceVersion = serviceVersion;
    }

    public DailyInvocationStatistic dailyCount(@Nonnull BigDecimal dailyCount) {
        this.dailyCount = dailyCount;
        return this;
    }

    @Nonnull
    @JsonProperty(value="dailyCount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public BigDecimal getDailyCount() {
        return this.dailyCount;
    }

    @JsonProperty(value="dailyCount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDailyCount(@Nonnull BigDecimal dailyCount) {
        this.dailyCount = dailyCount;
    }

    public DailyInvocationStatistic hourlyCount(@Nullable Map<String, Object> hourlyCount) {
        this.hourlyCount = hourlyCount;
        return this;
    }

    public DailyInvocationStatistic putHourlyCountItem(String key, Object hourlyCountItem) {
        if (this.hourlyCount == null) {
            this.hourlyCount = new HashMap<String, Object>();
        }
        this.hourlyCount.put(key, hourlyCountItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="hourlyCount")
    @JsonInclude(content=JsonInclude.Include.ALWAYS, value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, Object> getHourlyCount() {
        return this.hourlyCount;
    }

    @JsonProperty(value="hourlyCount")
    @JsonInclude(content=JsonInclude.Include.ALWAYS, value=JsonInclude.Include.USE_DEFAULTS)
    public void setHourlyCount(@Nullable Map<String, Object> hourlyCount) {
        this.hourlyCount = hourlyCount;
    }

    public DailyInvocationStatistic minuteCount(@Nullable Map<String, Object> minuteCount) {
        this.minuteCount = minuteCount;
        return this;
    }

    public DailyInvocationStatistic putMinuteCountItem(String key, Object minuteCountItem) {
        if (this.minuteCount == null) {
            this.minuteCount = new HashMap<String, Object>();
        }
        this.minuteCount.put(key, minuteCountItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="minuteCount")
    @JsonInclude(content=JsonInclude.Include.ALWAYS, value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, Object> getMinuteCount() {
        return this.minuteCount;
    }

    @JsonProperty(value="minuteCount")
    @JsonInclude(content=JsonInclude.Include.ALWAYS, value=JsonInclude.Include.USE_DEFAULTS)
    public void setMinuteCount(@Nullable Map<String, Object> minuteCount) {
        this.minuteCount = minuteCount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DailyInvocationStatistic dailyInvocationStatistic = (DailyInvocationStatistic)o;
        return Objects.equals(this.id, dailyInvocationStatistic.id) && Objects.equals(this.day, dailyInvocationStatistic.day) && Objects.equals(this.serviceName, dailyInvocationStatistic.serviceName) && Objects.equals(this.serviceVersion, dailyInvocationStatistic.serviceVersion) && Objects.equals(this.dailyCount, dailyInvocationStatistic.dailyCount) && Objects.equals(this.hourlyCount, dailyInvocationStatistic.hourlyCount) && Objects.equals(this.minuteCount, dailyInvocationStatistic.minuteCount);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.day, this.serviceName, this.serviceVersion, this.dailyCount, this.hourlyCount, this.minuteCount);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DailyInvocationStatistic {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    day: ").append(this.toIndentedString(this.day)).append("\n");
        sb.append("    serviceName: ").append(this.toIndentedString(this.serviceName)).append("\n");
        sb.append("    serviceVersion: ").append(this.toIndentedString(this.serviceVersion)).append("\n");
        sb.append("    dailyCount: ").append(this.toIndentedString(this.dailyCount)).append("\n");
        sb.append("    hourlyCount: ").append(this.toIndentedString(this.hourlyCount)).append("\n");
        sb.append("    minuteCount: ").append(this.toIndentedString(this.minuteCount)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getId() != null) {
            joiner.add(String.format("%sid%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(this.getId()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getDay() != null) {
            joiner.add(String.format("%sday%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(this.getDay()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getServiceName() != null) {
            joiner.add(String.format("%sserviceName%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(this.getServiceName()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getServiceVersion() != null) {
            joiner.add(String.format("%sserviceVersion%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(this.getServiceVersion()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getDailyCount() != null) {
            joiner.add(String.format("%sdailyCount%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(this.getDailyCount()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getHourlyCount() != null) {
            for (String _key : this.getHourlyCount().keySet()) {
                joiner.add(String.format("%shourlyCount%s%s=%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, _key, containerSuffix), this.getHourlyCount().get(_key), URLEncoder.encode(ApiClient.valueToString(this.getHourlyCount().get(_key)), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
            }
        }
        if (this.getMinuteCount() != null) {
            for (String _key : this.getMinuteCount().keySet()) {
                joiner.add(String.format("%sminuteCount%s%s=%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, _key, containerSuffix), this.getMinuteCount().get(_key), URLEncoder.encode(ApiClient.valueToString(this.getMinuteCount().get(_key)), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
            }
        }
        return joiner.toString();
    }
}

