/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.github.microcks.client.ApiClient;
import io.github.microcks.client.model.Header;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"id", "name", "content", "operationId", "testCaseId", "headers", "mediaType", "dispatchCriteria"})
public class EventMessage {
    public static final String JSON_PROPERTY_ID = "id";
    @Nonnull
    private String id;
    public static final String JSON_PROPERTY_NAME = "name";
    @Nonnull
    private String name;
    public static final String JSON_PROPERTY_CONTENT = "content";
    @Nullable
    private String content;
    public static final String JSON_PROPERTY_OPERATION_ID = "operationId";
    @Nonnull
    private String operationId;
    public static final String JSON_PROPERTY_TEST_CASE_ID = "testCaseId";
    @Nullable
    private String testCaseId;
    public static final String JSON_PROPERTY_HEADERS = "headers";
    @Nullable
    private List<Header> headers = new ArrayList<Header>();
    public static final String JSON_PROPERTY_MEDIA_TYPE = "mediaType";
    @Nonnull
    private String mediaType;
    public static final String JSON_PROPERTY_DISPATCH_CRITERIA = "dispatchCriteria";
    @Nullable
    private String dispatchCriteria;

    public EventMessage id(@Nonnull String id) {
        this.id = id;
        return this;
    }

    @Nonnull
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setId(@Nonnull String id) {
        this.id = id;
    }

    public EventMessage name(@Nonnull String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(@Nonnull String name) {
        this.name = name;
    }

    public EventMessage content(@Nullable String content) {
        this.content = content;
        return this;
    }

    @Nullable
    @JsonProperty(value="content")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getContent() {
        return this.content;
    }

    @JsonProperty(value="content")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setContent(@Nullable String content) {
        this.content = content;
    }

    public EventMessage operationId(@Nonnull String operationId) {
        this.operationId = operationId;
        return this;
    }

    @Nonnull
    @JsonProperty(value="operationId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getOperationId() {
        return this.operationId;
    }

    @JsonProperty(value="operationId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setOperationId(@Nonnull String operationId) {
        this.operationId = operationId;
    }

    public EventMessage testCaseId(@Nullable String testCaseId) {
        this.testCaseId = testCaseId;
        return this;
    }

    @Nullable
    @JsonProperty(value="testCaseId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTestCaseId() {
        return this.testCaseId;
    }

    @JsonProperty(value="testCaseId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTestCaseId(@Nullable String testCaseId) {
        this.testCaseId = testCaseId;
    }

    public EventMessage headers(@Nullable List<Header> headers) {
        this.headers = headers;
        return this;
    }

    public EventMessage addHeadersItem(Header headersItem) {
        if (this.headers == null) {
            this.headers = new ArrayList<Header>();
        }
        this.headers.add(headersItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="headers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Header> getHeaders() {
        return this.headers;
    }

    @JsonProperty(value="headers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHeaders(@Nullable List<Header> headers) {
        this.headers = headers;
    }

    public EventMessage mediaType(@Nonnull String mediaType) {
        this.mediaType = mediaType;
        return this;
    }

    @Nonnull
    @JsonProperty(value="mediaType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getMediaType() {
        return this.mediaType;
    }

    @JsonProperty(value="mediaType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setMediaType(@Nonnull String mediaType) {
        this.mediaType = mediaType;
    }

    public EventMessage dispatchCriteria(@Nullable String dispatchCriteria) {
        this.dispatchCriteria = dispatchCriteria;
        return this;
    }

    @Nullable
    @JsonProperty(value="dispatchCriteria")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDispatchCriteria() {
        return this.dispatchCriteria;
    }

    @JsonProperty(value="dispatchCriteria")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDispatchCriteria(@Nullable String dispatchCriteria) {
        this.dispatchCriteria = dispatchCriteria;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EventMessage eventMessage = (EventMessage)o;
        return Objects.equals(this.id, eventMessage.id) && Objects.equals(this.name, eventMessage.name) && Objects.equals(this.content, eventMessage.content) && Objects.equals(this.operationId, eventMessage.operationId) && Objects.equals(this.testCaseId, eventMessage.testCaseId) && Objects.equals(this.headers, eventMessage.headers) && Objects.equals(this.mediaType, eventMessage.mediaType) && Objects.equals(this.dispatchCriteria, eventMessage.dispatchCriteria);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.content, this.operationId, this.testCaseId, this.headers, this.mediaType, this.dispatchCriteria);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EventMessage {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    content: ").append(this.toIndentedString(this.content)).append("\n");
        sb.append("    operationId: ").append(this.toIndentedString(this.operationId)).append("\n");
        sb.append("    testCaseId: ").append(this.toIndentedString(this.testCaseId)).append("\n");
        sb.append("    headers: ").append(this.toIndentedString(this.headers)).append("\n");
        sb.append("    mediaType: ").append(this.toIndentedString(this.mediaType)).append("\n");
        sb.append("    dispatchCriteria: ").append(this.toIndentedString(this.dispatchCriteria)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getId() != null) {
            joiner.add(String.format("%sid%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(this.getId()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getName() != null) {
            joiner.add(String.format("%sname%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(this.getName()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getContent() != null) {
            joiner.add(String.format("%scontent%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(this.getContent()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getOperationId() != null) {
            joiner.add(String.format("%soperationId%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(this.getOperationId()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getTestCaseId() != null) {
            joiner.add(String.format("%stestCaseId%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(this.getTestCaseId()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getHeaders() != null) {
            for (int i = 0; i < this.getHeaders().size(); ++i) {
                if (this.getHeaders().get(i) == null) continue;
                joiner.add(this.getHeaders().get(i).toUrlQueryString(String.format("%sheaders%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
            }
        }
        if (this.getMediaType() != null) {
            joiner.add(String.format("%smediaType%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(this.getMediaType()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getDispatchCriteria() != null) {
            joiner.add(String.format("%sdispatchCriteria%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(this.getDispatchCriteria()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        return joiner.toString();
    }
}

