/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.github.microcks.client.ApiClient;
import io.github.microcks.client.model.OAuth2GrantType;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"grantType", "principalName", "tokenUri", "scopes"})
public class OAuth2AuthorizedClient {
    public static final String JSON_PROPERTY_GRANT_TYPE = "grantType";
    @Nonnull
    private OAuth2GrantType grantType;
    public static final String JSON_PROPERTY_PRINCIPAL_NAME = "principalName";
    @Nonnull
    private String principalName;
    public static final String JSON_PROPERTY_TOKEN_URI = "tokenUri";
    @Nonnull
    private String tokenUri;
    public static final String JSON_PROPERTY_SCOPES = "scopes";
    @Nullable
    private String scopes;

    public OAuth2AuthorizedClient grantType(@Nonnull OAuth2GrantType grantType) {
        this.grantType = grantType;
        return this;
    }

    @Nonnull
    @JsonProperty(value="grantType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public OAuth2GrantType getGrantType() {
        return this.grantType;
    }

    @JsonProperty(value="grantType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setGrantType(@Nonnull OAuth2GrantType grantType) {
        this.grantType = grantType;
    }

    public OAuth2AuthorizedClient principalName(@Nonnull String principalName) {
        this.principalName = principalName;
        return this;
    }

    @Nonnull
    @JsonProperty(value="principalName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getPrincipalName() {
        return this.principalName;
    }

    @JsonProperty(value="principalName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setPrincipalName(@Nonnull String principalName) {
        this.principalName = principalName;
    }

    public OAuth2AuthorizedClient tokenUri(@Nonnull String tokenUri) {
        this.tokenUri = tokenUri;
        return this;
    }

    @Nonnull
    @JsonProperty(value="tokenUri")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getTokenUri() {
        return this.tokenUri;
    }

    @JsonProperty(value="tokenUri")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setTokenUri(@Nonnull String tokenUri) {
        this.tokenUri = tokenUri;
    }

    public OAuth2AuthorizedClient scopes(@Nullable String scopes) {
        this.scopes = scopes;
        return this;
    }

    @Nullable
    @JsonProperty(value="scopes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getScopes() {
        return this.scopes;
    }

    @JsonProperty(value="scopes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setScopes(@Nullable String scopes) {
        this.scopes = scopes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OAuth2AuthorizedClient oauth2AuthorizedClient = (OAuth2AuthorizedClient)o;
        return Objects.equals((Object)this.grantType, (Object)oauth2AuthorizedClient.grantType) && Objects.equals(this.principalName, oauth2AuthorizedClient.principalName) && Objects.equals(this.tokenUri, oauth2AuthorizedClient.tokenUri) && Objects.equals(this.scopes, oauth2AuthorizedClient.scopes);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.grantType, this.principalName, this.tokenUri, this.scopes});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OAuth2AuthorizedClient {\n");
        sb.append("    grantType: ").append(this.toIndentedString((Object)this.grantType)).append("\n");
        sb.append("    principalName: ").append(this.toIndentedString(this.principalName)).append("\n");
        sb.append("    tokenUri: ").append(this.toIndentedString(this.tokenUri)).append("\n");
        sb.append("    scopes: ").append(this.toIndentedString(this.scopes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getGrantType() != null) {
            joiner.add(String.format("%sgrantType%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString((Object)this.getGrantType()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getPrincipalName() != null) {
            joiner.add(String.format("%sprincipalName%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(this.getPrincipalName()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getTokenUri() != null) {
            joiner.add(String.format("%stokenUri%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(this.getTokenUri()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getScopes() != null) {
            joiner.add(String.format("%sscopes%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(this.getScopes()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        return joiner.toString();
    }
}

