/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.github.microcks.client.ApiClient;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"clientId", "clientSecret", "tokenUri", "username", "password", "refreshToken", "scopes", "grantType"})
public class OAuth2ClientContext {
    public static final String JSON_PROPERTY_CLIENT_ID = "clientId";
    @Nonnull
    private String clientId;
    public static final String JSON_PROPERTY_CLIENT_SECRET = "clientSecret";
    @Nonnull
    private String clientSecret;
    public static final String JSON_PROPERTY_TOKEN_URI = "tokenUri";
    @Nonnull
    private String tokenUri;
    public static final String JSON_PROPERTY_USERNAME = "username";
    @Nullable
    private String username;
    public static final String JSON_PROPERTY_PASSWORD = "password";
    @Nullable
    private String password;
    public static final String JSON_PROPERTY_REFRESH_TOKEN = "refreshToken";
    @Nullable
    private String refreshToken;
    public static final String JSON_PROPERTY_SCOPES = "scopes";
    @Nullable
    private String scopes;
    public static final String JSON_PROPERTY_GRANT_TYPE = "grantType";
    @Nonnull
    private GrantTypeEnum grantType;

    public OAuth2ClientContext clientId(@Nonnull String clientId) {
        this.clientId = clientId;
        return this;
    }

    @Nonnull
    @JsonProperty(value="clientId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getClientId() {
        return this.clientId;
    }

    @JsonProperty(value="clientId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setClientId(@Nonnull String clientId) {
        this.clientId = clientId;
    }

    public OAuth2ClientContext clientSecret(@Nonnull String clientSecret) {
        this.clientSecret = clientSecret;
        return this;
    }

    @Nonnull
    @JsonProperty(value="clientSecret")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getClientSecret() {
        return this.clientSecret;
    }

    @JsonProperty(value="clientSecret")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setClientSecret(@Nonnull String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public OAuth2ClientContext tokenUri(@Nonnull String tokenUri) {
        this.tokenUri = tokenUri;
        return this;
    }

    @Nonnull
    @JsonProperty(value="tokenUri")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getTokenUri() {
        return this.tokenUri;
    }

    @JsonProperty(value="tokenUri")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setTokenUri(@Nonnull String tokenUri) {
        this.tokenUri = tokenUri;
    }

    public OAuth2ClientContext username(@Nullable String username) {
        this.username = username;
        return this;
    }

    @Nullable
    @JsonProperty(value="username")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getUsername() {
        return this.username;
    }

    @JsonProperty(value="username")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUsername(@Nullable String username) {
        this.username = username;
    }

    public OAuth2ClientContext password(@Nullable String password) {
        this.password = password;
        return this;
    }

    @Nullable
    @JsonProperty(value="password")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPassword() {
        return this.password;
    }

    @JsonProperty(value="password")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPassword(@Nullable String password) {
        this.password = password;
    }

    public OAuth2ClientContext refreshToken(@Nullable String refreshToken) {
        this.refreshToken = refreshToken;
        return this;
    }

    @Nullable
    @JsonProperty(value="refreshToken")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRefreshToken() {
        return this.refreshToken;
    }

    @JsonProperty(value="refreshToken")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRefreshToken(@Nullable String refreshToken) {
        this.refreshToken = refreshToken;
    }

    public OAuth2ClientContext scopes(@Nullable String scopes) {
        this.scopes = scopes;
        return this;
    }

    @Nullable
    @JsonProperty(value="scopes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getScopes() {
        return this.scopes;
    }

    @JsonProperty(value="scopes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setScopes(@Nullable String scopes) {
        this.scopes = scopes;
    }

    public OAuth2ClientContext grantType(@Nonnull GrantTypeEnum grantType) {
        this.grantType = grantType;
        return this;
    }

    @Nonnull
    @JsonProperty(value="grantType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public GrantTypeEnum getGrantType() {
        return this.grantType;
    }

    @JsonProperty(value="grantType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setGrantType(@Nonnull GrantTypeEnum grantType) {
        this.grantType = grantType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OAuth2ClientContext oauth2ClientContext = (OAuth2ClientContext)o;
        return Objects.equals(this.clientId, oauth2ClientContext.clientId) && Objects.equals(this.clientSecret, oauth2ClientContext.clientSecret) && Objects.equals(this.tokenUri, oauth2ClientContext.tokenUri) && Objects.equals(this.username, oauth2ClientContext.username) && Objects.equals(this.password, oauth2ClientContext.password) && Objects.equals(this.refreshToken, oauth2ClientContext.refreshToken) && Objects.equals(this.scopes, oauth2ClientContext.scopes) && Objects.equals((Object)this.grantType, (Object)oauth2ClientContext.grantType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.clientId, this.clientSecret, this.tokenUri, this.username, this.password, this.refreshToken, this.scopes, this.grantType});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OAuth2ClientContext {\n");
        sb.append("    clientId: ").append(this.toIndentedString(this.clientId)).append("\n");
        sb.append("    clientSecret: ").append("*").append("\n");
        sb.append("    tokenUri: ").append(this.toIndentedString(this.tokenUri)).append("\n");
        sb.append("    username: ").append(this.toIndentedString(this.username)).append("\n");
        sb.append("    password: ").append(this.toIndentedString(this.password)).append("\n");
        sb.append("    refreshToken: ").append(this.toIndentedString(this.refreshToken)).append("\n");
        sb.append("    scopes: ").append(this.toIndentedString(this.scopes)).append("\n");
        sb.append("    grantType: ").append(this.toIndentedString((Object)this.grantType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getClientId() != null) {
            joiner.add(String.format("%sclientId%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(this.getClientId()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getClientSecret() != null) {
            joiner.add(String.format("%sclientSecret%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(this.getClientSecret()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getTokenUri() != null) {
            joiner.add(String.format("%stokenUri%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(this.getTokenUri()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getUsername() != null) {
            joiner.add(String.format("%susername%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(this.getUsername()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getPassword() != null) {
            joiner.add(String.format("%spassword%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(this.getPassword()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getRefreshToken() != null) {
            joiner.add(String.format("%srefreshToken%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(this.getRefreshToken()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getScopes() != null) {
            joiner.add(String.format("%sscopes%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(this.getScopes()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getGrantType() != null) {
            joiner.add(String.format("%sgrantType%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString((Object)this.getGrantType()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        return joiner.toString();
    }

    public static enum GrantTypeEnum {
        PASSWORD(String.valueOf("PASSWORD")),
        CLIENT_CREDENTIALS(String.valueOf("CLIENT_CREDENTIALS")),
        REFRESH_TOKEN(String.valueOf("REFRESH_TOKEN"));

        private String value;

        private GrantTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static GrantTypeEnum fromValue(String value) {
            for (GrantTypeEnum b : GrantTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

