/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum OAuth2GrantType {
    PASSWORD("PASSWORD"),
    CLIENT_CREDENTIALS("CLIENT_CREDENTIALS"),
    REFRESH_TOKEN("REFRESH_TOKEN");

    private String value;

    private OAuth2GrantType(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    @JsonCreator
    public static OAuth2GrantType fromValue(String value) {
        for (OAuth2GrantType b : OAuth2GrantType.values()) {
            if (!b.value.equals(value)) continue;
            return b;
        }
        throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public String toUrlQueryString(String prefix) {
        if (prefix == null) {
            prefix = "";
        }
        return String.format("%s=%s", prefix, this.toString());
    }
}

