/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.github.microcks.client.ApiClient;
import io.github.microcks.client.model.Header;
import io.github.microcks.client.model.Parameter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"id", "name", "content", "operationId", "testCaseId", "headers", "responseId", "queryParameters"})
public class Request {
    public static final String JSON_PROPERTY_ID = "id";
    @Nullable
    private String id;
    public static final String JSON_PROPERTY_NAME = "name";
    @Nonnull
    private String name;
    public static final String JSON_PROPERTY_CONTENT = "content";
    @Nullable
    private String content;
    public static final String JSON_PROPERTY_OPERATION_ID = "operationId";
    @Nonnull
    private String operationId;
    public static final String JSON_PROPERTY_TEST_CASE_ID = "testCaseId";
    @Nullable
    private String testCaseId;
    public static final String JSON_PROPERTY_HEADERS = "headers";
    @Nullable
    private List<Header> headers = new ArrayList<Header>();
    public static final String JSON_PROPERTY_RESPONSE_ID = "responseId";
    @Nullable
    private String responseId;
    public static final String JSON_PROPERTY_QUERY_PARAMETERS = "queryParameters";
    @Nullable
    private List<Parameter> queryParameters = new ArrayList<Parameter>();

    public Request id(@Nullable String id) {
        this.id = id;
        return this;
    }

    @Nullable
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setId(@Nullable String id) {
        this.id = id;
    }

    public Request name(@Nonnull String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(@Nonnull String name) {
        this.name = name;
    }

    public Request content(@Nullable String content) {
        this.content = content;
        return this;
    }

    @Nullable
    @JsonProperty(value="content")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getContent() {
        return this.content;
    }

    @JsonProperty(value="content")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setContent(@Nullable String content) {
        this.content = content;
    }

    public Request operationId(@Nonnull String operationId) {
        this.operationId = operationId;
        return this;
    }

    @Nonnull
    @JsonProperty(value="operationId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getOperationId() {
        return this.operationId;
    }

    @JsonProperty(value="operationId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setOperationId(@Nonnull String operationId) {
        this.operationId = operationId;
    }

    public Request testCaseId(@Nullable String testCaseId) {
        this.testCaseId = testCaseId;
        return this;
    }

    @Nullable
    @JsonProperty(value="testCaseId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTestCaseId() {
        return this.testCaseId;
    }

    @JsonProperty(value="testCaseId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTestCaseId(@Nullable String testCaseId) {
        this.testCaseId = testCaseId;
    }

    public Request headers(@Nullable List<Header> headers) {
        this.headers = headers;
        return this;
    }

    public Request addHeadersItem(Header headersItem) {
        if (this.headers == null) {
            this.headers = new ArrayList<Header>();
        }
        this.headers.add(headersItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="headers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Header> getHeaders() {
        return this.headers;
    }

    @JsonProperty(value="headers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHeaders(@Nullable List<Header> headers) {
        this.headers = headers;
    }

    public Request responseId(@Nullable String responseId) {
        this.responseId = responseId;
        return this;
    }

    @Nullable
    @JsonProperty(value="responseId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getResponseId() {
        return this.responseId;
    }

    @JsonProperty(value="responseId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setResponseId(@Nullable String responseId) {
        this.responseId = responseId;
    }

    public Request queryParameters(@Nullable List<Parameter> queryParameters) {
        this.queryParameters = queryParameters;
        return this;
    }

    public Request addQueryParametersItem(Parameter queryParametersItem) {
        if (this.queryParameters == null) {
            this.queryParameters = new ArrayList<Parameter>();
        }
        this.queryParameters.add(queryParametersItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="queryParameters")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Parameter> getQueryParameters() {
        return this.queryParameters;
    }

    @JsonProperty(value="queryParameters")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setQueryParameters(@Nullable List<Parameter> queryParameters) {
        this.queryParameters = queryParameters;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Request request = (Request)o;
        return Objects.equals(this.id, request.id) && Objects.equals(this.name, request.name) && Objects.equals(this.content, request.content) && Objects.equals(this.operationId, request.operationId) && Objects.equals(this.testCaseId, request.testCaseId) && Objects.equals(this.headers, request.headers) && Objects.equals(this.responseId, request.responseId) && Objects.equals(this.queryParameters, request.queryParameters);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.content, this.operationId, this.testCaseId, this.headers, this.responseId, this.queryParameters);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Request {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    content: ").append(this.toIndentedString(this.content)).append("\n");
        sb.append("    operationId: ").append(this.toIndentedString(this.operationId)).append("\n");
        sb.append("    testCaseId: ").append(this.toIndentedString(this.testCaseId)).append("\n");
        sb.append("    headers: ").append(this.toIndentedString(this.headers)).append("\n");
        sb.append("    responseId: ").append(this.toIndentedString(this.responseId)).append("\n");
        sb.append("    queryParameters: ").append(this.toIndentedString(this.queryParameters)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        int i;
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getId() != null) {
            joiner.add(String.format("%sid%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(this.getId()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getName() != null) {
            joiner.add(String.format("%sname%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(this.getName()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getContent() != null) {
            joiner.add(String.format("%scontent%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(this.getContent()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getOperationId() != null) {
            joiner.add(String.format("%soperationId%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(this.getOperationId()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getTestCaseId() != null) {
            joiner.add(String.format("%stestCaseId%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(this.getTestCaseId()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getHeaders() != null) {
            for (i = 0; i < this.getHeaders().size(); ++i) {
                if (this.getHeaders().get(i) == null) continue;
                joiner.add(this.getHeaders().get(i).toUrlQueryString(String.format("%sheaders%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
            }
        }
        if (this.getResponseId() != null) {
            joiner.add(String.format("%sresponseId%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(this.getResponseId()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getQueryParameters() != null) {
            for (i = 0; i < this.getQueryParameters().size(); ++i) {
                if (this.getQueryParameters().get(i) == null) continue;
                joiner.add(this.getQueryParameters().get(i).toUrlQueryString(String.format("%squeryParameters%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
            }
        }
        return joiner.toString();
    }
}

