/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.github.microcks.client.ApiClient;
import io.github.microcks.client.model.ResourceType;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"id", "name", "content", "type", "serviceId", "path", "sourceArtifact"})
public class Resource {
    public static final String JSON_PROPERTY_ID = "id";
    @Nonnull
    private String id;
    public static final String JSON_PROPERTY_NAME = "name";
    @Nonnull
    private String name;
    public static final String JSON_PROPERTY_CONTENT = "content";
    @Nonnull
    private String content;
    public static final String JSON_PROPERTY_TYPE = "type";
    @Nonnull
    private ResourceType type;
    public static final String JSON_PROPERTY_SERVICE_ID = "serviceId";
    @Nonnull
    private String serviceId;
    public static final String JSON_PROPERTY_PATH = "path";
    @Nullable
    private String path;
    public static final String JSON_PROPERTY_SOURCE_ARTIFACT = "sourceArtifact";
    @Nullable
    private String sourceArtifact;

    public Resource id(@Nonnull String id) {
        this.id = id;
        return this;
    }

    @Nonnull
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setId(@Nonnull String id) {
        this.id = id;
    }

    public Resource name(@Nonnull String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(@Nonnull String name) {
        this.name = name;
    }

    public Resource content(@Nonnull String content) {
        this.content = content;
        return this;
    }

    @Nonnull
    @JsonProperty(value="content")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getContent() {
        return this.content;
    }

    @JsonProperty(value="content")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setContent(@Nonnull String content) {
        this.content = content;
    }

    public Resource type(@Nonnull ResourceType type) {
        this.type = type;
        return this;
    }

    @Nonnull
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public ResourceType getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setType(@Nonnull ResourceType type) {
        this.type = type;
    }

    public Resource serviceId(@Nonnull String serviceId) {
        this.serviceId = serviceId;
        return this;
    }

    @Nonnull
    @JsonProperty(value="serviceId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getServiceId() {
        return this.serviceId;
    }

    @JsonProperty(value="serviceId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setServiceId(@Nonnull String serviceId) {
        this.serviceId = serviceId;
    }

    public Resource path(@Nullable String path) {
        this.path = path;
        return this;
    }

    @Nullable
    @JsonProperty(value="path")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPath() {
        return this.path;
    }

    @JsonProperty(value="path")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPath(@Nullable String path) {
        this.path = path;
    }

    public Resource sourceArtifact(@Nullable String sourceArtifact) {
        this.sourceArtifact = sourceArtifact;
        return this;
    }

    @Nullable
    @JsonProperty(value="sourceArtifact")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSourceArtifact() {
        return this.sourceArtifact;
    }

    @JsonProperty(value="sourceArtifact")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSourceArtifact(@Nullable String sourceArtifact) {
        this.sourceArtifact = sourceArtifact;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Resource resource = (Resource)o;
        return Objects.equals(this.id, resource.id) && Objects.equals(this.name, resource.name) && Objects.equals(this.content, resource.content) && Objects.equals((Object)this.type, (Object)resource.type) && Objects.equals(this.serviceId, resource.serviceId) && Objects.equals(this.path, resource.path) && Objects.equals(this.sourceArtifact, resource.sourceArtifact);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.content, this.type, this.serviceId, this.path, this.sourceArtifact});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Resource {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    content: ").append(this.toIndentedString(this.content)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    serviceId: ").append(this.toIndentedString(this.serviceId)).append("\n");
        sb.append("    path: ").append(this.toIndentedString(this.path)).append("\n");
        sb.append("    sourceArtifact: ").append(this.toIndentedString(this.sourceArtifact)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getId() != null) {
            joiner.add(String.format("%sid%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(this.getId()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getName() != null) {
            joiner.add(String.format("%sname%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(this.getName()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getContent() != null) {
            joiner.add(String.format("%scontent%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(this.getContent()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getType() != null) {
            joiner.add(String.format("%stype%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString((Object)this.getType()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getServiceId() != null) {
            joiner.add(String.format("%sserviceId%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(this.getServiceId()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getPath() != null) {
            joiner.add(String.format("%spath%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(this.getPath()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getSourceArtifact() != null) {
            joiner.add(String.format("%ssourceArtifact%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(this.getSourceArtifact()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        return joiner.toString();
    }
}

