/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.github.microcks.client.ApiClient;
import io.github.microcks.client.model.HeaderDTO;
import io.github.microcks.client.model.OAuth2ClientContext;
import io.github.microcks.client.model.TestRunnerType;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"serviceId", "testEndpoint", "runnerType", "timeout", "filteredOperations", "secretName", "oAuth2Context", "operationsHeaders"})
public class TestRequest {
    public static final String JSON_PROPERTY_SERVICE_ID = "serviceId";
    @Nonnull
    private String serviceId;
    public static final String JSON_PROPERTY_TEST_ENDPOINT = "testEndpoint";
    @Nonnull
    private String testEndpoint;
    public static final String JSON_PROPERTY_RUNNER_TYPE = "runnerType";
    @Nonnull
    private TestRunnerType runnerType;
    public static final String JSON_PROPERTY_TIMEOUT = "timeout";
    @Nonnull
    private Long timeout;
    public static final String JSON_PROPERTY_FILTERED_OPERATIONS = "filteredOperations";
    @Nullable
    private List<String> filteredOperations = new ArrayList<String>();
    public static final String JSON_PROPERTY_SECRET_NAME = "secretName";
    @Nullable
    private String secretName;
    public static final String JSON_PROPERTY_O_AUTH2_CONTEXT = "oAuth2Context";
    @Nullable
    private OAuth2ClientContext oAuth2Context;
    public static final String JSON_PROPERTY_OPERATIONS_HEADERS = "operationsHeaders";
    @Nullable
    private Map<String, List<HeaderDTO>> operationsHeaders = new HashMap<String, List<HeaderDTO>>();

    public TestRequest serviceId(@Nonnull String serviceId) {
        this.serviceId = serviceId;
        return this;
    }

    @Nonnull
    @JsonProperty(value="serviceId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getServiceId() {
        return this.serviceId;
    }

    @JsonProperty(value="serviceId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setServiceId(@Nonnull String serviceId) {
        this.serviceId = serviceId;
    }

    public TestRequest testEndpoint(@Nonnull String testEndpoint) {
        this.testEndpoint = testEndpoint;
        return this;
    }

    @Nonnull
    @JsonProperty(value="testEndpoint")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getTestEndpoint() {
        return this.testEndpoint;
    }

    @JsonProperty(value="testEndpoint")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setTestEndpoint(@Nonnull String testEndpoint) {
        this.testEndpoint = testEndpoint;
    }

    public TestRequest runnerType(@Nonnull TestRunnerType runnerType) {
        this.runnerType = runnerType;
        return this;
    }

    @Nonnull
    @JsonProperty(value="runnerType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public TestRunnerType getRunnerType() {
        return this.runnerType;
    }

    @JsonProperty(value="runnerType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setRunnerType(@Nonnull TestRunnerType runnerType) {
        this.runnerType = runnerType;
    }

    public TestRequest timeout(@Nonnull Long timeout) {
        this.timeout = timeout;
        return this;
    }

    @Nonnull
    @JsonProperty(value="timeout")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Long getTimeout() {
        return this.timeout;
    }

    @JsonProperty(value="timeout")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setTimeout(@Nonnull Long timeout) {
        this.timeout = timeout;
    }

    public TestRequest filteredOperations(@Nullable List<String> filteredOperations) {
        this.filteredOperations = filteredOperations;
        return this;
    }

    public TestRequest addFilteredOperationsItem(String filteredOperationsItem) {
        if (this.filteredOperations == null) {
            this.filteredOperations = new ArrayList<String>();
        }
        this.filteredOperations.add(filteredOperationsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="filteredOperations")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getFilteredOperations() {
        return this.filteredOperations;
    }

    @JsonProperty(value="filteredOperations")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFilteredOperations(@Nullable List<String> filteredOperations) {
        this.filteredOperations = filteredOperations;
    }

    public TestRequest secretName(@Nullable String secretName) {
        this.secretName = secretName;
        return this;
    }

    @Nullable
    @JsonProperty(value="secretName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSecretName() {
        return this.secretName;
    }

    @JsonProperty(value="secretName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSecretName(@Nullable String secretName) {
        this.secretName = secretName;
    }

    public TestRequest oAuth2Context(@Nullable OAuth2ClientContext oAuth2Context) {
        this.oAuth2Context = oAuth2Context;
        return this;
    }

    @Nullable
    @JsonProperty(value="oAuth2Context")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OAuth2ClientContext getoAuth2Context() {
        return this.oAuth2Context;
    }

    @JsonProperty(value="oAuth2Context")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setoAuth2Context(@Nullable OAuth2ClientContext oAuth2Context) {
        this.oAuth2Context = oAuth2Context;
    }

    public TestRequest operationsHeaders(@Nullable Map<String, List<HeaderDTO>> operationsHeaders) {
        this.operationsHeaders = operationsHeaders;
        return this;
    }

    public TestRequest putOperationsHeadersItem(String key, List<HeaderDTO> operationsHeadersItem) {
        if (this.operationsHeaders == null) {
            this.operationsHeaders = new HashMap<String, List<HeaderDTO>>();
        }
        this.operationsHeaders.put(key, operationsHeadersItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="operationsHeaders")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, List<HeaderDTO>> getOperationsHeaders() {
        return this.operationsHeaders;
    }

    @JsonProperty(value="operationsHeaders")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOperationsHeaders(@Nullable Map<String, List<HeaderDTO>> operationsHeaders) {
        this.operationsHeaders = operationsHeaders;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TestRequest testRequest = (TestRequest)o;
        return Objects.equals(this.serviceId, testRequest.serviceId) && Objects.equals(this.testEndpoint, testRequest.testEndpoint) && Objects.equals((Object)this.runnerType, (Object)testRequest.runnerType) && Objects.equals(this.timeout, testRequest.timeout) && Objects.equals(this.filteredOperations, testRequest.filteredOperations) && Objects.equals(this.secretName, testRequest.secretName) && Objects.equals(this.oAuth2Context, testRequest.oAuth2Context) && Objects.equals(this.operationsHeaders, testRequest.operationsHeaders);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.serviceId, this.testEndpoint, this.runnerType, this.timeout, this.filteredOperations, this.secretName, this.oAuth2Context, this.operationsHeaders});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TestRequest {\n");
        sb.append("    serviceId: ").append(this.toIndentedString(this.serviceId)).append("\n");
        sb.append("    testEndpoint: ").append(this.toIndentedString(this.testEndpoint)).append("\n");
        sb.append("    runnerType: ").append(this.toIndentedString((Object)this.runnerType)).append("\n");
        sb.append("    timeout: ").append(this.toIndentedString(this.timeout)).append("\n");
        sb.append("    filteredOperations: ").append(this.toIndentedString(this.filteredOperations)).append("\n");
        sb.append("    secretName: ").append(this.toIndentedString(this.secretName)).append("\n");
        sb.append("    oAuth2Context: ").append(this.toIndentedString(this.oAuth2Context)).append("\n");
        sb.append("    operationsHeaders: ").append(this.toIndentedString(this.operationsHeaders)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getServiceId() != null) {
            joiner.add(String.format("%sserviceId%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(this.getServiceId()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getTestEndpoint() != null) {
            joiner.add(String.format("%stestEndpoint%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(this.getTestEndpoint()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getRunnerType() != null) {
            joiner.add(String.format("%srunnerType%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString((Object)this.getRunnerType()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getTimeout() != null) {
            joiner.add(String.format("%stimeout%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(this.getTimeout()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getFilteredOperations() != null) {
            for (int i = 0; i < this.getFilteredOperations().size(); ++i) {
                joiner.add(String.format("%sfilteredOperations%s%s=%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix), URLEncoder.encode(ApiClient.valueToString(this.getFilteredOperations().get(i)), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
            }
        }
        if (this.getSecretName() != null) {
            joiner.add(String.format("%ssecretName%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(this.getSecretName()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getoAuth2Context() != null) {
            joiner.add(this.getoAuth2Context().toUrlQueryString((String)prefix + JSON_PROPERTY_O_AUTH2_CONTEXT + suffix));
        }
        if (this.getOperationsHeaders() != null) {
            for (String _key : this.getOperationsHeaders().keySet()) {
                joiner.add(String.format("%soperationsHeaders%s%s=%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, _key, containerSuffix), this.getOperationsHeaders().get(_key), URLEncoder.encode(ApiClient.valueToString(this.getOperationsHeaders().get(_key)), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
            }
        }
        return joiner.toString();
    }
}

