/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.utils;

import com.epam.reportportal.exception.InternalReportPortalClientException;
import com.google.common.io.Resources;
import java.io.InputStream;
import java.net.URL;
import java.security.KeyStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SslUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(SslUtils.class);

    public static KeyStore loadKeyStore(String keyStore, String password) {
        KeyStore keyStore2;
        block8: {
            InputStream is = Resources.asByteSource((URL)Resources.getResource((String)keyStore)).openStream();
            try {
                KeyStore trustStore = KeyStore.getInstance("JKS");
                trustStore.load(is, password.toCharArray());
                keyStore2 = trustStore;
                if (is == null) break block8;
            }
            catch (Throwable trustStore) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable) {
                            trustStore.addSuppressed(throwable);
                        }
                    }
                    throw trustStore;
                }
                catch (Exception e) {
                    String error = "Unable to load trust store";
                    LOGGER.error(error, (Throwable)e);
                    throw new InternalReportPortalClientException(error, e);
                }
            }
            is.close();
        }
        return keyStore2;
    }
}

