/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.service.statistics;

import com.epam.reportportal.listeners.ListenerParameters;
import com.epam.reportportal.service.statistics.DummyClient;
import com.epam.reportportal.service.statistics.Statistics;
import com.epam.reportportal.service.statistics.StatisticsClient;
import com.epam.reportportal.service.statistics.item.StatisticsEvent;
import com.epam.reportportal.utils.properties.ClientProperties;
import com.epam.reportportal.utils.properties.DefaultProperties;
import com.epam.reportportal.utils.properties.SystemAttributesExtractor;
import com.epam.ta.reportportal.ws.model.attribute.ItemAttributeResource;
import com.epam.ta.reportportal.ws.model.launch.StartLaunchRQ;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.reactivex.Scheduler;
import io.reactivex.schedulers.Schedulers;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import okhttp3.ResponseBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatisticsService
implements Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(StatisticsService.class);
    public static final String DISABLE_PROPERTY = "AGENT_NO_ANALYTICS";
    private static final String CLIENT_PROPERTIES_FILE = "client.properties";
    private static final String START_LAUNCH_EVENT_ACTION = "Start launch";
    private static final String CATEGORY_VALUE_FORMAT = "Client name \"%s\", version \"%s\", interpreter \"Java %s\"";
    private static final String LABEL_VALUE_FORMAT = "Agent name \"%s\", version \"%s\"";
    private final ExecutorService statisticsExecutor = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat("rp-stat-%s").setDaemon(true).build());
    private final Scheduler scheduler = Schedulers.from((Executor)this.statisticsExecutor);
    private final Statistics statistics;
    private final List<Completable> dependencies = new CopyOnWriteArrayList<Completable>();
    private final ListenerParameters parameters;

    public StatisticsService(ListenerParameters listenerParameters) {
        this.parameters = listenerParameters;
        boolean isDisabled = System.getenv(DISABLE_PROPERTY) != null;
        this.statistics = isDisabled ? new DummyClient() : new StatisticsClient("UA-173456809-1", this.parameters);
    }

    protected Statistics getStatistics() {
        return this.statistics;
    }

    public void sendEvent(Maybe<String> launchIdMaybe, StartLaunchRQ rq) {
        StatisticsEvent.StatisticsEventBuilder statisticsEventBuilder = StatisticsEvent.builder().withAction(START_LAUNCH_EVENT_ACTION);
        SystemAttributesExtractor.extract(CLIENT_PROPERTIES_FILE, this.getClass().getClassLoader(), ClientProperties.CLIENT).stream().map(ItemAttributeResource::getValue).map(a -> a.split(Pattern.quote("|"))).filter(a -> ((String[])a).length >= 2).map(a -> {
            Object[] r = new Object[((String[])a).length + 1];
            System.arraycopy(a, 0, r, 0, ((String[])a).length);
            r[a.length] = System.getProperty("java.version");
            return r;
        }).findFirst().ifPresent(clientAttribute -> statisticsEventBuilder.withCategory(String.format(CATEGORY_VALUE_FORMAT, clientAttribute)));
        Optional.ofNullable(rq.getAttributes()).flatMap(r -> r.stream().filter(attribute -> attribute.isSystem() && DefaultProperties.AGENT.getName().equalsIgnoreCase(attribute.getKey())).findAny()).map(ItemAttributeResource::getValue).map(a -> a.split(Pattern.quote("|"))).filter(a -> ((String[])a).length >= 2).ifPresent(agentAttribute -> statisticsEventBuilder.withLabel(String.format(LABEL_VALUE_FORMAT, agentAttribute)));
        Maybe statisticsMaybe = launchIdMaybe.flatMap(l -> this.getStatistics().send(statisticsEventBuilder.build())).cache().subscribeOn(this.scheduler);
        this.dependencies.add(statisticsMaybe.ignoreElement());
        statisticsMaybe.subscribe(t -> {
            Optional.ofNullable((ResponseBody)t.body()).ifPresent(ResponseBody::close);
            this.getStatistics().close();
        }, t -> {
            LOGGER.error("Unable to send statistics", t);
            this.getStatistics().close();
        });
    }

    @Override
    public void close() {
        Throwable result = Completable.concat(this.dependencies).timeout((long)this.parameters.getReportingTimeout().intValue(), TimeUnit.SECONDS).blockingGet();
        if (result != null) {
            LOGGER.warn("Unable to complete execution of all dependencies", result);
        }
        this.statisticsExecutor.shutdown();
        try {
            if (!this.statisticsExecutor.awaitTermination(this.parameters.getReportingTimeout().intValue(), TimeUnit.SECONDS)) {
                this.statisticsExecutor.shutdownNow();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        try {
            this.getStatistics().close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

