/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.utils.http;

import com.epam.reportportal.exception.InternalReportPortalClientException;
import com.epam.reportportal.utils.MimeTypeDetector;
import com.epam.ta.reportportal.ws.model.log.SaveLogRQ;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.io.ByteSource;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpRequestUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpRequestUtils.class);
    public static final String DEFAULT_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    public static final ObjectMapper MAPPER = new ObjectMapper();
    private static final String DEFAULT_TYPE = "application/octet-stream";
    public static final String TYPICAL_MULTIPART_BOUNDARY = "--972dbca3abacfd01fb4aea0571532b52";
    public static final String TYPICAL_JSON_PART_HEADER = "--972dbca3abacfd01fb4aea0571532b52\r\nContent-Disposition: form-data; name=\"json_request_part\"\r\nContent-Type: application/json\r\n\r\n";
    public static final String TYPICAL_FILE_PART_HEADER = "--972dbca3abacfd01fb4aea0571532b52\r\nContent-Disposition: form-data; name=\"file\"; filename=\"%s\"\r\nContent-Type: %s\r\n\r\n";
    public static final int TYPICAL_JSON_PART_HEADER_LENGTH;
    public static final String TYPICAL_MULTIPART_FOOTER = "\r\n--972dbca3abacfd01fb4aea0571532b52--";
    public static final int TYPICAL_MULTIPART_FOOTER_LENGTH;
    public static final String TYPICAL_JSON_ARRAY = "[]";
    public static final int TYPICAL_JSON_ARRAY_LENGTH;
    public static final String TYPICAL_JSON_ARRAY_ELEMENT = ",";
    public static final int TYPICAL_JSON_ARRAY_ELEMENT_LENGTH;

    private HttpRequestUtils() {
        throw new IllegalStateException("Static only class");
    }

    public static List<MultipartBody.Part> buildLogMultiPartRequest(List<SaveLogRQ> rqs) {
        ArrayList<MultipartBody.Part> result = new ArrayList<MultipartBody.Part>();
        try {
            result.add(MultipartBody.Part.createFormData((String)"json_request_part", null, (RequestBody)RequestBody.create((MediaType)MediaType.get((String)"application/json; charset=utf-8"), (String)MAPPER.writerFor((TypeReference)new TypeReference<List<SaveLogRQ>>(){}).writeValueAsString(rqs))));
        }
        catch (JsonProcessingException e) {
            throw new InternalReportPortalClientException("Unable to process JSON", e);
        }
        for (SaveLogRQ rq : rqs) {
            MediaType type;
            SaveLogRQ.File file = rq.getFile();
            if (null == file) continue;
            try {
                type = StringUtils.isBlank((CharSequence)file.getContentType()) ? MediaType.get((String)MimeTypeDetector.detect(ByteSource.wrap((byte[])file.getContent()), file.getName())) : MediaType.get((String)file.getContentType());
            }
            catch (IOException | IllegalArgumentException e) {
                LOGGER.error("Unable to parse content media type, default value was used: application/octet-stream", (Throwable)e);
                type = MediaType.get((String)DEFAULT_TYPE);
            }
            result.add(MultipartBody.Part.createFormData((String)"binary_part", (String)file.getName(), (RequestBody)RequestBody.create((MediaType)type, (byte[])file.getContent())));
        }
        return result;
    }

    private static long calculateJsonPartSize(SaveLogRQ request) {
        try {
            long size = MAPPER.writerFor((TypeReference)new TypeReference<SaveLogRQ>(){}).writeValueAsString((Object)request).length();
        }
        catch (JsonProcessingException e) {
            throw new InternalReportPortalClientException("Unable to process JSON", e);
        }
        size += (long)TYPICAL_JSON_PART_HEADER_LENGTH;
        size += (long)TYPICAL_JSON_ARRAY_LENGTH;
        return size += (long)TYPICAL_JSON_ARRAY_ELEMENT_LENGTH;
    }

    private static long calculateFilePartSize(SaveLogRQ request) {
        if (request.getFile() == null || request.getFile().getContent() == null) {
            return 0L;
        }
        SaveLogRQ.File file = request.getFile();
        long size = String.format(TYPICAL_FILE_PART_HEADER, file.getName(), file.getContentType()).length();
        return size += (long)file.getContent().length;
    }

    public static long calculateRequestSize(SaveLogRQ request) {
        return HttpRequestUtils.calculateJsonPartSize(request) + HttpRequestUtils.calculateFilePartSize(request);
    }

    static {
        MAPPER.setDateFormat((DateFormat)new SimpleDateFormat(DEFAULT_DATE_FORMAT));
        MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        TYPICAL_JSON_PART_HEADER_LENGTH = TYPICAL_JSON_PART_HEADER.length();
        TYPICAL_MULTIPART_FOOTER_LENGTH = TYPICAL_MULTIPART_FOOTER.length();
        TYPICAL_JSON_ARRAY_LENGTH = TYPICAL_JSON_ARRAY.length();
        TYPICAL_JSON_ARRAY_ELEMENT_LENGTH = TYPICAL_JSON_ARRAY_ELEMENT.length();
    }
}

