/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.service;

import com.epam.reportportal.listeners.ListenerParameters;
import com.epam.reportportal.message.TypeAwareByteSource;
import com.epam.reportportal.service.ReportPortalClient;
import com.epam.reportportal.service.logs.LogBatchingFlowable;
import com.epam.reportportal.service.logs.LoggingSubscriber;
import com.epam.reportportal.utils.RetryWithDelay;
import com.epam.reportportal.utils.files.ImageConverter;
import com.epam.reportportal.utils.http.HttpRequestUtils;
import com.epam.ta.reportportal.ws.model.BatchSaveOperatingRS;
import com.epam.ta.reportportal.ws.model.log.SaveLogRQ;
import com.google.common.io.ByteSource;
import io.reactivex.Completable;
import io.reactivex.Flowable;
import io.reactivex.FlowableSubscriber;
import io.reactivex.Maybe;
import io.reactivex.Scheduler;
import io.reactivex.functions.Predicate;
import io.reactivex.internal.operators.flowable.FlowableFromObservable;
import io.reactivex.plugins.RxJavaPlugins;
import io.reactivex.subjects.PublishSubject;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class LaunchLoggingContext {
    private static final int DEFAULT_RETRY_COUNT = 5;
    private static final int DEFAULT_RETRY_TIMEOUT = 2;
    static final String DEFAULT_LAUNCH_KEY = "default";
    private static final ConcurrentHashMap<String, LaunchLoggingContext> loggingContextMap = new ConcurrentHashMap();
    private final PublishSubject<Maybe<SaveLogRQ>> emitter;
    private final Maybe<String> launchUuid;
    private final boolean convertImages;

    private LaunchLoggingContext(@Nonnull Maybe<String> launchUuid, @Nonnull ReportPortalClient client, @Nonnull Scheduler scheduler, @Nonnull ListenerParameters parameters, @Nonnull FlowableSubscriber<BatchSaveOperatingRS> loggingSubscriber) {
        this.launchUuid = launchUuid;
        this.emitter = PublishSubject.create();
        this.convertImages = parameters.isConvertImage();
        RxJavaPlugins.onAssembly((Flowable)new LogBatchingFlowable((Flowable<SaveLogRQ>)new FlowableFromObservable(this.emitter).flatMap(Maybe::toFlowable), parameters).onBackpressureBuffer(parameters.getRxBufferSize(), false, true)).flatMap(rqs -> client.log(HttpRequestUtils.buildLogMultiPartRequest(rqs)).toFlowable().retry((Predicate)new RetryWithDelay((Predicate<? super Throwable>)((Predicate)e -> true), 5L, TimeUnit.SECONDS.toMillis(2L)))).observeOn(scheduler).onBackpressureBuffer(parameters.getRxBufferSize(), false, true).subscribe(loggingSubscriber);
    }

    @Nullable
    public static LaunchLoggingContext context(@Nonnull String key) {
        return loggingContextMap.get(key);
    }

    public static LaunchLoggingContext init(@Nonnull Maybe<String> launchUuid, @Nonnull ReportPortalClient client, @Nonnull Scheduler scheduler, @Nonnull ListenerParameters parameters, @Nonnull FlowableSubscriber<BatchSaveOperatingRS> loggingSubscriber) {
        LaunchLoggingContext context = new LaunchLoggingContext(launchUuid, client, scheduler, parameters, loggingSubscriber);
        loggingContextMap.put(DEFAULT_LAUNCH_KEY, context);
        return context;
    }

    public static LaunchLoggingContext init(@Nonnull Maybe<String> launchUuid, @Nonnull ReportPortalClient client, @Nonnull Scheduler scheduler, @Nonnull ListenerParameters parameters) {
        return LaunchLoggingContext.init(launchUuid, client, scheduler, parameters, new LoggingSubscriber());
    }

    static LaunchLoggingContext init(@Nonnull Maybe<String> launchUuid, ReportPortalClient client, @Nonnull Scheduler scheduler) {
        return LaunchLoggingContext.init(launchUuid, client, scheduler, 10, false);
    }

    static LaunchLoggingContext init(@Nonnull Maybe<String> launchUuid, @Nonnull ReportPortalClient client, @Nonnull Scheduler scheduler, int batchLogsSize, boolean convertImages) {
        ListenerParameters params = new ListenerParameters();
        params.setBatchLogsSize(batchLogsSize);
        params.setConvertImage(convertImages);
        return LaunchLoggingContext.init(launchUuid, client, scheduler, params, new LoggingSubscriber());
    }

    public static Completable complete() {
        LaunchLoggingContext loggingContext = loggingContextMap.get(DEFAULT_LAUNCH_KEY);
        if (null != loggingContext) {
            return loggingContext.completed();
        }
        return Maybe.empty().ignoreElement();
    }

    void emit(@Nonnull Function<String, SaveLogRQ> logSupplier) {
        this.emitter.onNext((Object)this.launchUuid.map(input -> {
            SaveLogRQ rq = (SaveLogRQ)logSupplier.apply((String)input);
            SaveLogRQ.File file = rq.getFile();
            if (this.convertImages && null != file && ImageConverter.isImage(file.getContentType())) {
                TypeAwareByteSource source = ImageConverter.convert(ByteSource.wrap((byte[])file.getContent()));
                file.setContent(source.read());
                file.setContentType(source.getMediaType());
            }
            return rq;
        }));
    }

    private Completable completed() {
        this.emitter.onComplete();
        return this.emitter.ignoreElements();
    }
}

