/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.service.statistics.item;

import com.epam.reportportal.service.statistics.item.StatisticsItem;
import com.google.common.collect.Maps;
import io.reactivex.annotations.Nullable;
import java.util.Map;

public class StatisticsEvent
implements StatisticsItem {
    private static final String TYPE = "event";
    private final Map<String, String> params;

    public StatisticsEvent(@Nullable String eventCategory, @Nullable String eventAction, @Nullable String eventLabel) {
        this.params = Maps.newHashMapWithExpectedSize((int)4);
        this.params.put("t", TYPE);
        this.params.put("ec", eventCategory);
        this.params.put("ea", eventAction);
        this.params.put("el", eventLabel);
    }

    private StatisticsEvent(Map<String, String> params) {
        this.params = params;
    }

    public static StatisticsEventBuilder builder() {
        return new StatisticsEventBuilder();
    }

    @Override
    public Map<String, String> getParams() {
        return this.params;
    }

    public static class StatisticsEventBuilder {
        private final Map<String, String> params = Maps.newHashMapWithExpectedSize((int)4);

        public StatisticsEventBuilder() {
            this.params.put("t", StatisticsEvent.TYPE);
        }

        public StatisticsEventBuilder withCategory(String category) {
            this.params.put("ec", category);
            return this;
        }

        public StatisticsEventBuilder withAction(String action) {
            this.params.put("ea", action);
            return this;
        }

        public StatisticsEventBuilder withLabel(String label) {
            this.params.put("el", label);
            return this;
        }

        public StatisticsEvent build() {
            return new StatisticsEvent(this.params);
        }
    }
}

