/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.utils.reflect;

import com.epam.reportportal.utils.reflect.AccessibleField;
import com.epam.reportportal.utils.reflect.AccessibleMethod;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class Accessible {
    private final Object object;

    public Accessible(Object object) {
        this.object = object;
    }

    public AccessibleMethod method(Method m) {
        return new AccessibleMethod(this.object, m);
    }

    public AccessibleField field(Field f) {
        return new AccessibleField(this.object, f);
    }

    public AccessibleField field(String name) throws NoSuchFieldException {
        return new AccessibleField(this.object, this.getField(name));
    }

    public static Accessible on(Object object) {
        return new Accessible(object);
    }

    private Field getField(String fieldName) throws NoSuchFieldException {
        Class<?> clazz = this.object.getClass();
        try {
            return clazz.getField(fieldName);
        }
        catch (NoSuchFieldException e) {
            while (true) {
                try {
                    return clazz.getDeclaredField(fieldName);
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    if ((clazz = clazz.getSuperclass()) != null) continue;
                    throw e;
                }
                break;
            }
        }
    }
}

