package com.epam.reportportal.service.logs;

import com.epam.ta.reportportal.ws.model.log.SaveLogRQ;

import java.util.LinkedList;
import java.util.List;

class LoggingContext {
    private final List<SaveLogRQ> logRQList;

    private LoggingContext() {
        logRQList = new LinkedList<>();
    }

    public void appendLog(SaveLogRQ saveLogRQ) {
        logRQList.add(saveLogRQ);
    }

    public List<SaveLogRQ> getLogRQList() {
        return new LinkedList<>(logRQList);
    }

    public void clearLogRQList() {
        logRQList.clear();
    }

    public int size() {
        return logRQList.size();
    }

    public boolean isEmpty() {
        return logRQList.isEmpty();
    }

    public static LoggingContext getInstance() {
        return LoggingContextInstance.INSTANCE;
    }

    private static class LoggingContextInstance {
        private static final LoggingContext INSTANCE = new LoggingContext();
    }

}
