/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.service.logs;

import com.epam.reportportal.listeners.ListenerParameters;
import com.epam.reportportal.utils.http.HttpRequestUtils;
import com.epam.ta.reportportal.ws.model.log.SaveLogRQ;
import io.reactivex.Flowable;
import io.reactivex.FlowableSubscriber;
import io.reactivex.internal.fuseable.HasUpstreamPublisher;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.internal.util.BackpressureHelper;
import io.reactivex.plugins.RxJavaPlugins;
import io.reactivex.subscribers.SerializedSubscriber;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public class LogBatchingFlowable
extends Flowable<List<SaveLogRQ>>
implements HasUpstreamPublisher<SaveLogRQ> {
    private final int maxSize;
    private final long payloadLimit;
    private final Flowable<SaveLogRQ> source;

    public LogBatchingFlowable(Flowable<SaveLogRQ> flowableSource, ListenerParameters parameters) {
        this.source = flowableSource;
        this.maxSize = parameters.getBatchLogsSize();
        this.payloadLimit = parameters.getBatchPayloadLimit();
    }

    protected void subscribeActual(Subscriber<? super List<SaveLogRQ>> s) {
        this.source.subscribe((FlowableSubscriber)new BufferSubscriber((Subscriber<List<SaveLogRQ>>)new SerializedSubscriber(s), this.maxSize, this.payloadLimit));
    }

    public Publisher<SaveLogRQ> source() {
        return this.source;
    }

    private static final class BufferSubscriber
    implements FlowableSubscriber<SaveLogRQ>,
    Subscription {
        private final Subscriber<List<SaveLogRQ>> downstream;
        private final int maxSize;
        private final long payloadLimit;
        private List<SaveLogRQ> buffer;
        private long payloadSize;
        private Subscription upstream;
        boolean done;

        public BufferSubscriber(Subscriber<List<SaveLogRQ>> actual, int batchMaxSize, long batchPayloadLimit) {
            this.downstream = actual;
            this.maxSize = batchMaxSize;
            this.payloadLimit = batchPayloadLimit;
        }

        public void onSubscribe(@Nonnull Subscription s) {
            if (!SubscriptionHelper.validate((Subscription)this.upstream, (Subscription)s)) {
                return;
            }
            this.upstream = s;
            this.buffer = new ArrayList<SaveLogRQ>();
            this.payloadSize = HttpRequestUtils.TYPICAL_MULTIPART_FOOTER_LENGTH;
            this.downstream.onSubscribe((Subscription)this);
        }

        private void reset() {
            this.buffer = new ArrayList<SaveLogRQ>();
            this.payloadSize = HttpRequestUtils.TYPICAL_MULTIPART_FOOTER_LENGTH;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onNext(SaveLogRQ t) {
            if (this.done) {
                return;
            }
            long size = HttpRequestUtils.calculateRequestSize(t);
            ArrayList<List<SaveLogRQ>> toSend = new ArrayList<List<SaveLogRQ>>();
            BufferSubscriber bufferSubscriber = this;
            synchronized (bufferSubscriber) {
                if (this.buffer == null) {
                    return;
                }
                if (this.payloadSize + size > this.payloadLimit && this.buffer.size() > 0) {
                    toSend.add(this.buffer);
                    this.reset();
                }
                this.buffer.add(t);
                this.payloadSize += size;
                if (this.buffer.size() >= this.maxSize) {
                    toSend.add(this.buffer);
                    this.reset();
                }
            }
            toSend.forEach(arg_0 -> this.downstream.onNext(arg_0));
        }

        public void onError(Throwable t) {
            if (this.done) {
                RxJavaPlugins.onError((Throwable)t);
                return;
            }
            this.done = true;
            this.downstream.onError(t);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            ArrayList<List<SaveLogRQ>> toSend = new ArrayList<List<SaveLogRQ>>();
            BufferSubscriber bufferSubscriber = this;
            synchronized (bufferSubscriber) {
                if (this.buffer != null && !this.buffer.isEmpty()) {
                    toSend.add(this.buffer);
                    this.reset();
                }
            }
            toSend.forEach(arg_0 -> this.downstream.onNext(arg_0));
            this.downstream.onComplete();
        }

        public void request(long n) {
            if (SubscriptionHelper.validate((long)n)) {
                this.upstream.request(BackpressureHelper.multiplyCap((long)n, (long)this.maxSize));
            }
        }

        public void cancel() {
            this.upstream.cancel();
        }
    }
}

