/*
 * Decompiled with CFR 0.152.
 */
package JavaLineArray;

import ArmyC2.C2SD.Utilities.ErrorLogger;
import ArmyC2.C2SD.Utilities.RendererException;
import JavaLineArray.Channels;
import JavaLineArray.POINT2;
import JavaLineArray.Shape2;
import JavaLineArray.countsupport;
import JavaLineArray.flot;
import JavaLineArray.lineutility;
import java.util.ArrayList;

public final class CELineArray {
    private static final String _className = "CELineArray";
    private static String _client = "";

    public static int CGetChannel2Double(double[] lpsaUpperVBPoints, double[] lpsaLowerVBPoints, double[] resultVBPoints, int vblUpperCounter, int vblLowerCounter, int vbiDrawThis, int vblChannelWidth, int usePtr, ArrayList<Shape2> shapes, int rev) throws Exception {
        int lResult = -1;
        try {
            lResult = Channels.GetChannel1Double(lpsaUpperVBPoints, lpsaLowerVBPoints, resultVBPoints, vblUpperCounter, vblLowerCounter, vbiDrawThis, vblChannelWidth, usePtr, shapes, rev);
        }
        catch (Exception exc) {
            ErrorLogger.LogException((String)_className, (String)"CGetChannel2Double", (Exception)new RendererException("Failed inside CGetChannel2Double " + Integer.toString(vbiDrawThis), (Throwable)exc));
        }
        return lResult;
    }

    public static int CGetLineCountDouble(double[] plArrayOfLongs, int lElements, int lineType, int ChannelWidth, int rev) {
        int lResult = 0;
        try {
            int lPtrcntr = 0;
            int lLowerFlotCount = 0;
            int lUpperFlotCount = 0;
            POINT2[] pLinePoints = new POINT2[lElements];
            POINT2[] pLowerLinePoints = new POINT2[lElements];
            POINT2[] pUpperLinePoints = new POINT2[lElements];
            POINT2[] pUpperLowerLinePoints = new POINT2[2 * lElements + 2];
            int i = 0;
            if (lElements <= 0) {
                return -1;
            }
            lineutility.InitializePOINT2Array(pLinePoints);
            lineutility.InitializePOINT2Array(pUpperLinePoints);
            lineutility.InitializePOINT2Array(pLowerLinePoints);
            for (i = 0; i < lElements; i = (int)((short)(i + 1))) {
                pLinePoints[i].x = plArrayOfLongs[lPtrcntr];
                pLinePoints[i].y = plArrayOfLongs[++lPtrcntr];
                ++lPtrcntr;
            }
            for (i = 0; i < lElements; i = (int)((short)(i + 1))) {
                pLowerLinePoints[i] = new POINT2(pLinePoints[i]);
                pUpperLinePoints[i] = new POINT2(pLinePoints[i]);
            }
            switch (lineType) {
                case 231113001: 
                case 231113002: 
                case 231113003: {
                    lResult = 2 * lElements;
                    break;
                }
                case 22320000: 
                case 22320001: 
                case 22521100: 
                case 22521200: 
                case 22521410: 
                case 22521411: 
                case 22521420: 
                case 22521421: {
                    lResult = 2 * lElements + 8;
                    break;
                }
                case 21700000: {
                    lResult = 2 * lElements + 8;
                    break;
                }
                case 21710000: {
                    lResult = 2 * lElements + 17;
                    break;
                }
                case 22521300: {
                    lResult = 2 * lElements + 19;
                    break;
                }
                case 22123000: {
                    pUpperLinePoints = Channels.GetChannelArray2Double(1, pUpperLinePoints, 1, lElements, lineType, ChannelWidth);
                    pLowerLinePoints = Channels.GetChannelArray2Double(1, pLowerLinePoints, 0, lElements, lineType, ChannelWidth);
                    lUpperFlotCount = flot.GetFlotCountDouble(pUpperLinePoints, lElements);
                    lLowerFlotCount = flot.GetFlotCountDouble(pLowerLinePoints, lElements);
                    lResult = lUpperFlotCount + lLowerFlotCount;
                    break;
                }
                default: {
                    lResult = countsupport.GetCountersDouble(lineType, lElements, pLinePoints, null, rev);
                }
            }
            pLinePoints = null;
            pLowerLinePoints = null;
            pUpperLinePoints = null;
            pUpperLowerLinePoints = null;
        }
        catch (Exception exc) {
            ErrorLogger.LogException((String)_className, (String)"CGetLineCountDouble", (Exception)new RendererException("Failed inside CGetLineCount " + Integer.toString(lineType), (Throwable)exc));
        }
        return lResult;
    }

    public static int CGetLinetypeFromString(String strLine, int rev) {
        try {
            if (strLine.length() < 15) {
                if (rev == 1) {
                    if (strLine.equalsIgnoreCase("SCREEN")) {
                        return 212210001;
                    }
                    if (strLine.equalsIgnoreCase("COVER")) {
                        return 212230001;
                    }
                    if (strLine.equalsIgnoreCase("GUARD")) {
                        return 212220001;
                    }
                    if (strLine.equalsIgnoreCase("SEIZE")) {
                        return 212300001;
                    }
                }
                if (strLine.equalsIgnoreCase("BS_LINE")) {
                    return 10000000;
                }
                if (strLine.equalsIgnoreCase("BS_AREA")) {
                    return 11000000;
                }
                if (strLine.equalsIgnoreCase("BS_CROSS")) {
                    return 12000000;
                }
                if (strLine.equalsIgnoreCase("BS_RECTANGLE")) {
                    return 14000000;
                }
                if (strLine.equalsIgnoreCase("PBS_RECTANGLE")) {
                    return 14000001;
                }
                if (strLine.equalsIgnoreCase("PBS_SQUARE")) {
                    return 14000002;
                }
                if (strLine.equalsIgnoreCase("BBS_LINE")) {
                    return 15000000;
                }
                if (strLine.equalsIgnoreCase("BBS_AREA")) {
                    return 15000001;
                }
                if (strLine.equalsIgnoreCase("BBS_POINT")) {
                    return 15000002;
                }
                if (strLine.equalsIgnoreCase("BBS_RECTANGLE")) {
                    return 15000003;
                }
                if (strLine.equalsIgnoreCase("BS_BBOX")) {
                    return 15000004;
                }
                if (strLine.equalsIgnoreCase("BS_ELLIPSE")) {
                    return 13000000;
                }
                if (strLine.equalsIgnoreCase("PBS_ELLIPSE")) {
                    return 13000001;
                }
                if (strLine.equalsIgnoreCase("PBS_CIRCLE")) {
                    return 13000002;
                }
                if (strLine.equalsIgnoreCase("OVERHEAD_WIRE")) {
                    return 23200000;
                }
                if (strLine.equalsIgnoreCase("CORDONSEARCH")) {
                    return 212500000;
                }
                if (strLine.equalsIgnoreCase("CORDONKNOCK")) {
                    return 212600000;
                }
                if (strLine.equalsIgnoreCase("NAVIGATION")) {
                    return 26220000;
                }
                if (strLine.equalsIgnoreCase("BLOCK")) {
                    return 21100000;
                }
                if (strLine.equalsIgnoreCase("BREACH")) {
                    return 21200000;
                }
                if (strLine.equalsIgnoreCase("BYPASS")) {
                    return 21300000;
                }
                if (strLine.equalsIgnoreCase("CANALIZE")) {
                    return 21400000;
                }
                if (strLine.equalsIgnoreCase("CLEAR")) {
                    return 21500000;
                }
                if (strLine.equalsIgnoreCase("CONTAIN")) {
                    return 21600000;
                }
                if (strLine.equalsIgnoreCase("CATK")) {
                    return 21700000;
                }
                if (strLine.equalsIgnoreCase("CATKBYFIRE")) {
                    return 21710000;
                }
                if (strLine.equalsIgnoreCase("DELAY")) {
                    return 21800000;
                }
                if (strLine.equalsIgnoreCase("DISRUPT")) {
                    return 211000000;
                }
                if (strLine.equalsIgnoreCase("FIX")) {
                    return 211100000;
                }
                if (strLine.equalsIgnoreCase("FOLLA")) {
                    return 211200000;
                }
                if (strLine.equalsIgnoreCase("FOLSP")) {
                    return 211210000;
                }
                if (strLine.equalsIgnoreCase("ISOLATE")) {
                    return 211400000;
                }
                if (strLine.equalsIgnoreCase("OCCUPY")) {
                    return 211600000;
                }
                if (strLine.equalsIgnoreCase("RIP")) {
                    return 211800000;
                }
                if (strLine.equalsIgnoreCase("RETAIN")) {
                    return 211900000;
                }
                if (strLine.equalsIgnoreCase("RETIRE")) {
                    return 212000000;
                }
                if (strLine.equalsIgnoreCase("SECURE")) {
                    return 212100000;
                }
                if (strLine.equalsIgnoreCase("SCREEN")) {
                    return 212210000;
                }
                if (strLine.equalsIgnoreCase("COVER")) {
                    return 212230000;
                }
                if (strLine.equalsIgnoreCase("GUARD")) {
                    return 212220000;
                }
                if (strLine.equalsIgnoreCase("SEZIE")) {
                    return 212300000;
                }
                if (strLine.equalsIgnoreCase("WITHDRAW")) {
                    return 212400000;
                }
                if (strLine.equalsIgnoreCase("WDRAWUP")) {
                    return 212410000;
                }
                if (strLine.equalsIgnoreCase("BOUNDARY")) {
                    return 22121000;
                }
                if (strLine.equalsIgnoreCase("FLOT")) {
                    return 22122000;
                }
                if (strLine.equalsIgnoreCase("LC")) {
                    return 22123000;
                }
                if (strLine.equalsIgnoreCase("PL")) {
                    return 22124000;
                }
                if (strLine.equalsIgnoreCase("LL")) {
                    return 22125000;
                }
                if (strLine.equalsIgnoreCase("GENERAL")) {
                    return 22131000;
                }
                if (strLine.equalsIgnoreCase("GENERIC")) {
                    return 22131001;
                }
                if (strLine.equalsIgnoreCase("ASSY")) {
                    return 22132000;
                }
                if (strLine.equalsIgnoreCase("EA")) {
                    return 22133000;
                }
                if (strLine.equalsIgnoreCase("FORT")) {
                    return 22134000;
                }
                if (strLine.equalsIgnoreCase("DZ")) {
                    return 22135000;
                }
                if (strLine.equalsIgnoreCase("EZ")) {
                    return 22136000;
                }
                if (strLine.equalsIgnoreCase("LZ")) {
                    return 22137000;
                }
                if (strLine.equalsIgnoreCase("PZ")) {
                    return 22138000;
                }
                if (strLine.equalsIgnoreCase("SARA")) {
                    return 22139000;
                }
                if (strLine.equalsIgnoreCase("LAA")) {
                    return 221310000;
                }
                if (strLine.equalsIgnoreCase("AIRFIELD")) {
                    return 221311000;
                }
                if (strLine.equalsIgnoreCase("AC")) {
                    return 22221000;
                }
                if (strLine.equalsIgnoreCase("MRR")) {
                    return 22222000;
                }
                if (strLine.equalsIgnoreCase("MRR_USAS")) {
                    return 22222001;
                }
                if (strLine.equalsIgnoreCase("SAAFR")) {
                    return 22223000;
                }
                if (strLine.equalsIgnoreCase("UAV")) {
                    return 22224000;
                }
                if (strLine.equalsIgnoreCase("UAV_USAS")) {
                    return 22224001;
                }
                if (strLine.equalsIgnoreCase("LLTR")) {
                    return 22225000;
                }
                if (strLine.equalsIgnoreCase("ROZ")) {
                    return 22231000;
                }
                if (strLine.equalsIgnoreCase("SHORADZ")) {
                    return 22232000;
                }
                if (strLine.equalsIgnoreCase("FAADZ")) {
                    return 22232000;
                }
                if (strLine.equalsIgnoreCase("HIDACZ")) {
                    return 22233000;
                }
                if (strLine.equalsIgnoreCase("MEZ")) {
                    return 22234000;
                }
                if (strLine.equalsIgnoreCase("LOMEZ")) {
                    return 22234100;
                }
                if (strLine.equalsIgnoreCase("HIMEZ")) {
                    return 22234200;
                }
                if (strLine.equalsIgnoreCase("WFZ")) {
                    return 22235000;
                }
                if (strLine.equalsIgnoreCase("DECEIVE")) {
                    return 22310000;
                }
                if (strLine.equalsIgnoreCase("AAFNT")) {
                    return 22320000;
                }
                if (strLine.equalsIgnoreCase("DIRATKFNT")) {
                    return 22330000;
                }
                if (strLine.equalsIgnoreCase("DMA")) {
                    return 22340000;
                }
                if (strLine.equalsIgnoreCase("DMAF")) {
                    return 22350000;
                }
                if (strLine.equalsIgnoreCase("DUMMY")) {
                    return 0x222248;
                }
                if (strLine.equalsIgnoreCase("FEBA")) {
                    return 22421000;
                }
                if (strLine.equalsIgnoreCase("PDF")) {
                    return 22422000;
                }
                if (strLine.equalsIgnoreCase("BATTLE")) {
                    return 22431000;
                }
                if (strLine.equalsIgnoreCase("PNO")) {
                    return 22431100;
                }
                if (strLine.equalsIgnoreCase("EA1")) {
                    return 22432000;
                }
                if (strLine.equalsIgnoreCase("AXAD")) {
                    return 22521100;
                }
                if (strLine.equalsIgnoreCase("AIRAOA")) {
                    return 22521200;
                }
                if (strLine.equalsIgnoreCase("AAAAA")) {
                    return 22521300;
                }
                if (strLine.equalsIgnoreCase("ROTARY")) {
                    return 22521300;
                }
                if (strLine.equalsIgnoreCase("MAIN")) {
                    return 22521410;
                }
                if (strLine.equalsIgnoreCase("SPT")) {
                    return 22521420;
                }
                if (strLine.equalsIgnoreCase("DIRATKAIR")) {
                    return 22522100;
                }
                if (strLine.equalsIgnoreCase("DIRATKGND")) {
                    return 22522210;
                }
                if (strLine.equalsIgnoreCase("DIRATKSPT")) {
                    return 22522220;
                }
                if (strLine.equalsIgnoreCase("FCL")) {
                    return 22523000;
                }
                if (strLine.equalsIgnoreCase("IL")) {
                    return 22524000;
                }
                if (strLine.equalsIgnoreCase("LOA")) {
                    return 22525000;
                }
                if (strLine.equalsIgnoreCase("LOD")) {
                    return 22526000;
                }
                if (strLine.equalsIgnoreCase("LDLC")) {
                    return 22527000;
                }
                if (strLine.equalsIgnoreCase("PLD")) {
                    return 22528000;
                }
                if (strLine.equalsIgnoreCase("ASSAULT")) {
                    return 22531000;
                }
                if (strLine.equalsIgnoreCase("ATKPOS")) {
                    return 22532000;
                }
                if (strLine.equalsIgnoreCase("ATKBYFIRE")) {
                    return 22533000;
                }
                if (strLine.equalsIgnoreCase("SPTBYFIRE")) {
                    return 22534000;
                }
                if (strLine.equalsIgnoreCase("ENCIRCLE")) {
                    return 22624000;
                }
                if (strLine.equalsIgnoreCase("SEIZE")) {
                    return 212300000;
                }
                if (strLine.equalsIgnoreCase("OBJ")) {
                    return 22535000;
                }
                if (strLine.equalsIgnoreCase("PEN")) {
                    return 22536000;
                }
                if (strLine.equalsIgnoreCase("PENETRATE")) {
                    return 211700000;
                }
                if (strLine.equalsIgnoreCase("AMBUSH")) {
                    return 22611000;
                }
                if (strLine.equalsIgnoreCase("HOLD")) {
                    return 22612000;
                }
                if (strLine.equalsIgnoreCase("RELEASE")) {
                    return 22613000;
                }
                if (strLine.equalsIgnoreCase("BRDGHD")) {
                    return 22623000;
                }
                if (strLine.equalsIgnoreCase("AO")) {
                    return 22621000;
                }
                if (strLine.equalsIgnoreCase("AIRHEAD")) {
                    return 22622000;
                }
                if (strLine.equalsIgnoreCase("NAI")) {
                    return 22625000;
                }
                if (strLine.equalsIgnoreCase("TAI")) {
                    return 22626000;
                }
                if (strLine.equalsIgnoreCase("BELT")) {
                    return 23111000;
                }
                if (strLine.equalsIgnoreCase("BELT1")) {
                    return 23111001;
                }
                if (strLine.equalsIgnoreCase("LINE")) {
                    return 23112000;
                }
                if (strLine.equalsIgnoreCase("ZONE")) {
                    return 23113000;
                }
                if (strLine.equalsIgnoreCase("OBSFAREA")) {
                    return 23114000;
                }
                if (strLine.equalsIgnoreCase("OBSAREA")) {
                    return 23115000;
                }
                if (strLine.equalsIgnoreCase("ABATIS")) {
                    return 23120000;
                }
                if (strLine.equalsIgnoreCase("ATDITCH")) {
                    return 23131100;
                }
                if (strLine.equalsIgnoreCase("ATDITCHC")) {
                    return 23131200;
                }
                if (strLine.equalsIgnoreCase("ATDITCHM")) {
                    return 23132000;
                }
                if (strLine.equalsIgnoreCase("ATWALL")) {
                    return 23134000;
                }
                if (strLine.equalsIgnoreCase("CLUSTER")) {
                    return 23157000;
                }
                if (strLine.equalsIgnoreCase("DEPICT")) {
                    return 23162000;
                }
                if (strLine.equalsIgnoreCase("GAP")) {
                    return 23163000;
                }
                if (strLine.equalsIgnoreCase("MINED")) {
                    return 23164000;
                }
                if (strLine.equalsIgnoreCase("MNFLDBLK")) {
                    return 23171000;
                }
                if (strLine.equalsIgnoreCase("MNFLDFIX")) {
                    return 23172000;
                }
                if (strLine.equalsIgnoreCase("TURN")) {
                    return 23173000;
                }
                if (strLine.equalsIgnoreCase("MNFLDDIS")) {
                    return 23174000;
                }
                if (strLine.equalsIgnoreCase("UXO")) {
                    return 23180000;
                }
                if (strLine.equalsIgnoreCase("PLANNED")) {
                    return 23191000;
                }
                if (strLine.equalsIgnoreCase("ESR1")) {
                    return 23192000;
                }
                if (strLine.equalsIgnoreCase("ESR2")) {
                    return 23193000;
                }
                if (strLine.equalsIgnoreCase("ROADBLK")) {
                    return 23194000;
                }
                if (strLine.equalsIgnoreCase("TRIP")) {
                    return 231100000;
                }
                if (strLine.equalsIgnoreCase("UNSP")) {
                    return 231111000;
                }
                if (strLine.equalsIgnoreCase("SFENCE")) {
                    return 231112000;
                }
                if (strLine.equalsIgnoreCase("DFENCE")) {
                    return 231113000;
                }
                if (strLine.equalsIgnoreCase("DOUBLEA")) {
                    return 231114000;
                }
                if (strLine.equalsIgnoreCase("LWFENCE")) {
                    return 231115000;
                }
                if (strLine.equalsIgnoreCase("HWFENCE")) {
                    return 231116000;
                }
                if (strLine.equalsIgnoreCase("SINGLEC")) {
                    return 231117100;
                }
                if (strLine.equalsIgnoreCase("DOUBLEC")) {
                    return 231117200;
                }
                if (strLine.equalsIgnoreCase("TRIPLE")) {
                    return 231117300;
                }
                if (strLine.equalsIgnoreCase("EASY")) {
                    return 23211000;
                }
                if (strLine.equalsIgnoreCase("BYDIF")) {
                    return 23212000;
                }
                if (strLine.equalsIgnoreCase("BYIMP")) {
                    return 23213000;
                }
                if (strLine.equalsIgnoreCase("ASLTXING")) {
                    return 23221000;
                }
                if (strLine.equalsIgnoreCase("BRIDGE")) {
                    return 23222000;
                }
                if (strLine.equalsIgnoreCase("FERRY")) {
                    return 23223000;
                }
                if (strLine.equalsIgnoreCase("FORD")) {
                    return 23224000;
                }
                if (strLine.equalsIgnoreCase("FORDSITE")) {
                    return 23224000;
                }
                if (strLine.equalsIgnoreCase("FORDIF")) {
                    return 23225000;
                }
                if (strLine.equalsIgnoreCase("LANE")) {
                    return 23226000;
                }
                if (strLine.equalsIgnoreCase("MFLANE")) {
                    return 23226000;
                }
                if (strLine.equalsIgnoreCase("RAFT")) {
                    return 23227000;
                }
                if (strLine.equalsIgnoreCase("FORTL")) {
                    return 23330000;
                }
                if (strLine.equalsIgnoreCase("FOXHOLE")) {
                    return 23340000;
                }
                if (strLine.equalsIgnoreCase("STRONG")) {
                    return 23350000;
                }
                if (strLine.equalsIgnoreCase("MSDZ")) {
                    return 23410000;
                }
                if (strLine.equalsIgnoreCase("RAD")) {
                    return 23440000;
                }
                if (strLine.equalsIgnoreCase("CHEM")) {
                    return 23460000;
                }
                if (strLine.equalsIgnoreCase("BIO")) {
                    return 23450000;
                }
                if (strLine.equalsIgnoreCase("DRCL")) {
                    return 23490000;
                }
                if (strLine.equalsIgnoreCase("LINTGT")) {
                    return 24250000;
                }
                if (strLine.equalsIgnoreCase("LINTGTS")) {
                    return 24211000;
                }
                if (strLine.equalsIgnoreCase("FPF")) {
                    return 24260000;
                }
                if (strLine.equalsIgnoreCase("FSCL")) {
                    return 24210000;
                }
                if (strLine.equalsIgnoreCase("CFL")) {
                    return 24220000;
                }
                if (strLine.equalsIgnoreCase("NFL")) {
                    return 24230000;
                }
                if (strLine.equalsIgnoreCase("MFP")) {
                    return 24225000;
                }
                if (strLine.equalsIgnoreCase("TGMF")) {
                    return 24226000;
                }
                if (strLine.equalsIgnoreCase("RFL")) {
                    return 24240000;
                }
                if (strLine.equalsIgnoreCase("AT")) {
                    return 24330000;
                }
                if (strLine.equalsIgnoreCase("RECTANGULAR")) {
                    return 24311000;
                }
                if (strLine.equalsIgnoreCase("CIRCULAR")) {
                    return 24312000;
                }
                if (strLine.equalsIgnoreCase("SERIES")) {
                    return 24313000;
                }
                if (strLine.equalsIgnoreCase("SMOKE")) {
                    return 24314000;
                }
                if (strLine.equalsIgnoreCase("BOMB")) {
                    return 24315000;
                }
                if (strLine.equalsIgnoreCase("FSA")) {
                    return 24321100;
                }
                if (strLine.equalsIgnoreCase("FSA_RECTANGULAR")) {
                    return 24321200;
                }
                if (strLine.equalsIgnoreCase("FSA_CIRCULAR")) {
                    return 24321300;
                }
                if (strLine.equalsIgnoreCase("ACA")) {
                    return 24322100;
                }
                if (strLine.equalsIgnoreCase("ACA_RECTANGULAR")) {
                    return 24322200;
                }
                if (strLine.equalsIgnoreCase("ACA_CIRCULAR")) {
                    return 24322300;
                }
                if (strLine.equalsIgnoreCase("FFA")) {
                    return 24323100;
                }
                if (strLine.equalsIgnoreCase("FFA_RECTANGULAR")) {
                    return 24323200;
                }
                if (strLine.equalsIgnoreCase("FFA_CIRCULAR")) {
                    return 24323300;
                }
                if (strLine.equalsIgnoreCase("NFA")) {
                    return 24324100;
                }
                if (strLine.equalsIgnoreCase("NFA_RECTANGULAR")) {
                    return 24324200;
                }
                if (strLine.equalsIgnoreCase("NFA_CIRCULAR")) {
                    return 24324300;
                }
                if (strLine.equalsIgnoreCase("RFA")) {
                    return 24325100;
                }
                if (strLine.equalsIgnoreCase("RFA_RECTANGULAR")) {
                    return 24325200;
                }
                if (strLine.equalsIgnoreCase("RFA_CIRCULAR")) {
                    return 24325300;
                }
                if (strLine.equalsIgnoreCase("PAA")) {
                    return 243100000;
                }
                if (strLine.equalsIgnoreCase("PAA_RECTANGULAR")) {
                    return 24326101;
                }
                if (strLine.equalsIgnoreCase("PAA_RECTANGULAR_REVC")) {
                    return 24326101;
                }
                if (strLine.equalsIgnoreCase("PAA_CIRCULAR")) {
                    return 24326200;
                }
                if (strLine.equalsIgnoreCase("ATI")) {
                    return 24331100;
                }
                if (strLine.equalsIgnoreCase("ATI_RECTANGULAR")) {
                    return 24331200;
                }
                if (strLine.equalsIgnoreCase("ATI_CIRCULAR")) {
                    return 24331300;
                }
                if (strLine.equalsIgnoreCase("CFFZ")) {
                    return 24332100;
                }
                if (strLine.equalsIgnoreCase("CFFZ_RECTANGULAR")) {
                    return 24332200;
                }
                if (strLine.equalsIgnoreCase("CFFZ_CIRCULAR")) {
                    return 24332300;
                }
                if (strLine.equalsIgnoreCase("SENSOR")) {
                    return 24333100;
                }
                if (strLine.equalsIgnoreCase("SENSOR_RECTANGULAR")) {
                    return 24333200;
                }
                if (strLine.equalsIgnoreCase("SENSOR_CIRCULAR")) {
                    return 24333300;
                }
                if (strLine.equalsIgnoreCase("CENSOR")) {
                    return 24334100;
                }
                if (strLine.equalsIgnoreCase("CENSOR_RECTANGULAR")) {
                    return 24334200;
                }
                if (strLine.equalsIgnoreCase("CENSOR_CIRCULAR")) {
                    return 24334300;
                }
                if (strLine.equalsIgnoreCase("DA")) {
                    return 24335100;
                }
                if (strLine.equalsIgnoreCase("DA_RECTANGULAR")) {
                    return 24335200;
                }
                if (strLine.equalsIgnoreCase("DA_CIRCULAR")) {
                    return 24335300;
                }
                if (strLine.equalsIgnoreCase("CFZ")) {
                    return 24336100;
                }
                if (strLine.equalsIgnoreCase("CFZ_RECTANGULAR")) {
                    return 24336200;
                }
                if (strLine.equalsIgnoreCase("CFZ_CIRCULAR")) {
                    return 24336300;
                }
                if (strLine.equalsIgnoreCase("ZOR")) {
                    return 24337100;
                }
                if (strLine.equalsIgnoreCase("ZOR_RECTANGULAR")) {
                    return 24337200;
                }
                if (strLine.equalsIgnoreCase("ZOR_CIRCULAR")) {
                    return 24337300;
                }
                if (strLine.equalsIgnoreCase("TBA")) {
                    return 24338100;
                }
                if (strLine.equalsIgnoreCase("TBA_RECTANGULAR")) {
                    return 24338200;
                }
                if (strLine.equalsIgnoreCase("TBA_CIRCULAR")) {
                    return 24338300;
                }
                if (strLine.equalsIgnoreCase("TVAR")) {
                    return 24339100;
                }
                if (strLine.equalsIgnoreCase("TVAR_RECTANGULAR")) {
                    return 24339200;
                }
                if (strLine.equalsIgnoreCase("TVAR_CIRCULAR")) {
                    return 24339300;
                }
                if (strLine.equalsIgnoreCase("KILLBOXBLUE")) {
                    return 24351000;
                }
                if (strLine.equalsIgnoreCase("KILLBOXBLUE_RECTANGULAR")) {
                    return 24352000;
                }
                if (strLine.equalsIgnoreCase("KILLBOXBLUE_CIRCULAR")) {
                    return 24353000;
                }
                if (strLine.equalsIgnoreCase("KILLBOXPURPLE")) {
                    return 24361000;
                }
                if (strLine.equalsIgnoreCase("KILLBOXPURPLE_RECTANGULAR")) {
                    return 24362000;
                }
                if (strLine.equalsIgnoreCase("KILLBOXPURPLE_CIRCULAR")) {
                    return 24363000;
                }
                if (strLine.equalsIgnoreCase("RANGE_FAN")) {
                    return 243111000;
                }
                if (strLine.equalsIgnoreCase("RANGEFAN")) {
                    return 243111000;
                }
                if (strLine.equalsIgnoreCase("RANGE_FANS")) {
                    return 243111000;
                }
                if (strLine.equalsIgnoreCase("RANGEFANS")) {
                    return 243111000;
                }
                if (strLine.equalsIgnoreCase("SECTOR")) {
                    return 243112000;
                }
                if (strLine.equalsIgnoreCase("CONVOY")) {
                    return 25211000;
                }
                if (strLine.equalsIgnoreCase("HCONVOY")) {
                    return 25212000;
                }
                if (strLine.equalsIgnoreCase("MSR")) {
                    return 25221000;
                }
                if (strLine.equalsIgnoreCase("ASR")) {
                    return 25222000;
                }
                if (strLine.equalsIgnoreCase("ONEWAY")) {
                    return 25223000;
                }
                if (strLine.equalsIgnoreCase("TWOWAY")) {
                    return 25225000;
                }
                if (strLine.equalsIgnoreCase("ALT")) {
                    return 25224000;
                }
                if (strLine.equalsIgnoreCase("DHA")) {
                    return 25310000;
                }
                if (strLine.equalsIgnoreCase("EPW")) {
                    return 25320000;
                }
                if (strLine.equalsIgnoreCase("FARP")) {
                    return 25330000;
                }
                if (strLine.equalsIgnoreCase("RHA")) {
                    return 25340000;
                }
                if (strLine.equalsIgnoreCase("BSA")) {
                    return 25351000;
                }
                if (strLine.equalsIgnoreCase("DSA")) {
                    return 25352000;
                }
                if (strLine.equalsIgnoreCase("RSA")) {
                    return 25353000;
                }
                if (strLine.equalsIgnoreCase("BEARING")) {
                    return 26400000;
                }
                if (strLine.equalsIgnoreCase("ELECTRO")) {
                    return 26410000;
                }
                if (strLine.equalsIgnoreCase("ACOUSTIC")) {
                    return 26420000;
                }
                if (strLine.equalsIgnoreCase("TORPEDO")) {
                    return 26430000;
                }
                if (strLine.equalsIgnoreCase("OPTICAL")) {
                    return 26440000;
                }
            }
            if (strLine.equalsIgnoreCase("FSA_RECTANGULAR")) {
                return 24321200;
            }
            if (strLine.equalsIgnoreCase("ACA_RECTANGULAR")) {
                return 24322200;
            }
            if (strLine.equalsIgnoreCase("FFA_RECTANGULAR")) {
                return 24323200;
            }
            if (strLine.equalsIgnoreCase("NFA_RECTANGULAR")) {
                return 24324200;
            }
            if (strLine.equalsIgnoreCase("RFA_RECTANGULAR")) {
                return 24325200;
            }
            if (strLine.equalsIgnoreCase("ATI_RECTANGULAR")) {
                return 24331200;
            }
            if (strLine.equalsIgnoreCase("CFFZ_RECTANGULAR")) {
                return 24332200;
            }
            if (strLine.equalsIgnoreCase("SENSOR_RECTANGULAR")) {
                return 24333200;
            }
            if (strLine.equalsIgnoreCase("SENSOR_CIRCULAR")) {
                return 24333300;
            }
            if (strLine.equalsIgnoreCase("CENSOR_RECTANGULAR")) {
                return 24334200;
            }
            if (strLine.equalsIgnoreCase("CENSOR_CIRCULAR")) {
                return 24334300;
            }
            if (strLine.equalsIgnoreCase("DA_RECTANGULAR")) {
                return 24335200;
            }
            if (strLine.equalsIgnoreCase("CFZ_RECTANGULAR")) {
                return 24336200;
            }
            if (strLine.equalsIgnoreCase("ZOR_RECTANGULAR")) {
                return 24337200;
            }
            if (strLine.equalsIgnoreCase("TBA_RECTANGULAR")) {
                return 24338200;
            }
            if (strLine.equalsIgnoreCase("TVAR_RECTANGULAR")) {
                return 24339200;
            }
            if (strLine.equalsIgnoreCase("GENERIC---****X")) {
                return 22131001;
            }
            String c0 = strLine.substring(0, 1);
            String c1 = strLine.substring(1, 2);
            String c2 = strLine.substring(2, 3);
            String str1 = strLine.substring(4, 5);
            String str2 = strLine.substring(4, 6);
            String str3 = strLine.substring(4, 7);
            String str4 = strLine.substring(4, 8);
            String str5 = strLine.substring(4, 9);
            String str6 = strLine.substring(3, 9);
            String str7 = strLine.substring(3, 10);
            String str10 = strLine.substring(3, 13);
            if (strLine.equalsIgnoreCase("BS_LINE--------")) {
                return 10000000;
            }
            if (strLine.equalsIgnoreCase("BS_AREA--------")) {
                return 11000000;
            }
            if (strLine.equalsIgnoreCase("BS_CROSS-------")) {
                return 12000000;
            }
            if (strLine.equalsIgnoreCase("BS_ELLIPSE-----")) {
                return 13000000;
            }
            if (strLine.equalsIgnoreCase("PBS_ELLIPSE----")) {
                return 13000001;
            }
            if (strLine.equalsIgnoreCase("PBS_CIRCLE-----")) {
                return 13000002;
            }
            if (strLine.equalsIgnoreCase("BS_RECTANGLE---")) {
                return 14000000;
            }
            if (strLine.equalsIgnoreCase("BBS_LINE-------")) {
                return 15000000;
            }
            if (strLine.equalsIgnoreCase("BBS_AREA-------")) {
                return 15000001;
            }
            if (strLine.equalsIgnoreCase("BBS_POINT------")) {
                return 15000002;
            }
            if (strLine.equalsIgnoreCase("BBS_RECTANGLE--")) {
                return 15000003;
            }
            if (strLine.equalsIgnoreCase("BS_BBOX--------")) {
                return 15000004;
            }
            if (c0.equals("W") && c1.equals("A")) {
                if (str7.equals("DPXSQ--")) {
                    return 31143000;
                }
                if (str7.equals("DPFC---")) {
                    return 31131000;
                }
                if (str7.equals("DPFC-FG")) {
                    return 31131200;
                }
                if (str7.equals("DPFC-FY")) {
                    return 31131300;
                }
                if (str7.equals("DPFW-FG")) {
                    return 31132200;
                }
                if (str7.equals("DPFW-FY")) {
                    return 31132300;
                }
                if (str7.equals("DPFOU--")) {
                    return 31133100;
                }
                if (str7.equals("DPFO-FY")) {
                    return 31133200;
                }
                if (str7.equals("DPFSU--")) {
                    return 31134100;
                }
                if (str7.equals("DPFS-FG")) {
                    return 31134200;
                }
                if (str7.equals("DPFS-FY")) {
                    return 31134300;
                }
                if (str7.equals("DPXIL--")) {
                    return 31144000;
                }
                if (str7.equals("DPXSH--")) {
                    return 31145000;
                }
                if (str7.equals("DPXITCZ")) {
                    return 31146000;
                }
                if (str7.equals("DPXCV--")) {
                    return 31147000;
                }
                if (str7.equals("DPXITD-")) {
                    return 31148000;
                }
                if (str7.equals("DWJ----")) {
                    return 31430000;
                }
                if (str7.equals("DWS----")) {
                    return 31440000;
                }
                if (str7.equals("DBAIF--")) {
                    return 31710000;
                }
                if (str7.equals("DBAMV--")) {
                    return 31720000;
                }
                if (str7.equals("DBATB--")) {
                    return 31730000;
                }
                if (str7.equals("DBAI---")) {
                    return 31740000;
                }
                if (str7.equals("DBALPNC")) {
                    return 31750000;
                }
                if (str7.equals("DBALPC-")) {
                    return 31751000;
                }
                if (str7.equals("DBAFP--")) {
                    return 31760000;
                }
                if (str7.equals("DBAT---")) {
                    return 31770000;
                }
                if (str7.equals("DBAFG--")) {
                    return 31780000;
                }
                if (str7.equals("DBAD---")) {
                    return 31790000;
                }
                if (str7.equals("DBAFF--")) {
                    return 317100000;
                }
                if (str7.equals("DIPIB--")) {
                    return 31810000;
                }
                if (str7.equals("DIPCO--")) {
                    return 31820000;
                }
                if (str7.equals("DIPIS--")) {
                    return 31830000;
                }
                if (str7.equals("DIPIT--")) {
                    return 31840000;
                }
                if (str7.equals("DIPID--")) {
                    return 31850000;
                }
                if (str7.equals("DIPTH--")) {
                    return 31860000;
                }
                if (str7.equals("DIPFF--")) {
                    return 31870000;
                }
                if (str3.equals("PXR")) {
                    return 31142000;
                }
                if (str3.equals("PXT")) {
                    return 31141000;
                }
                if (str4.equals("PFCU")) {
                    return 31131100;
                }
                if (str3.equals("PFO")) {
                    return 31133000;
                }
                if (str3.equals("PFS")) {
                    return 31134000;
                }
                if (str4.equals("PFWU")) {
                    return 31132100;
                }
                if (str3.equals("PFW")) {
                    return 31132000;
                }
                if (str3.equals("PFC")) {
                    return 31131000;
                }
            }
            if (c0.equals("W") && c1.equals("O")) {
                if (str10.equals("DHCF----L-")) {
                    return 32225100;
                }
                if (str10.equals("DHCF-----A")) {
                    return 32225200;
                }
                if (str10.equals("DHPBA---L-")) {
                    return 32231400;
                }
                if (str10.equals("DHPBA----A")) {
                    return 32231500;
                }
                if (str10.equals("DHPMO---L-")) {
                    return 32233400;
                }
                if (str10.equals("DHPMO----A")) {
                    return 32233500;
                }
            }
            if (c0.equals("W") && c1.equals("O")) {
                if (str7.equals("DIDID--")) {
                    return 32134000;
                }
                if (str7.equals("DILOV--")) {
                    return 32151000;
                }
                if (str7.equals("DILUC--")) {
                    return 32152000;
                }
                if (str7.equals("DILOR--")) {
                    return 32153000;
                }
                if (str7.equals("DILIEO-")) {
                    return 32154000;
                }
                if (str7.equals("DILIEE-")) {
                    return 32155000;
                }
                if (str7.equals("DILIER-")) {
                    return 32156000;
                }
                if (str7.equals("DIOC---")) {
                    return 32161000;
                }
                if (str7.equals("DIOCS--")) {
                    return 32162000;
                }
                if (str7.equals("DIOL---")) {
                    return 32163000;
                }
                if (str7.equals("DIOLF--")) {
                    return 32164000;
                }
                if (str7.equals("DHDDL--")) {
                    return 32212000;
                }
                if (str7.equals("DHDDC--")) {
                    return 32213000;
                }
                if (str7.equals("DHDDA--")) {
                    return 32214000;
                }
                if (str7.equals("DHCC---")) {
                    return 32221000;
                }
                if (str7.equals("DHCI---")) {
                    return 32222000;
                }
                if (str7.equals("DHCB---")) {
                    return 32223000;
                }
                if (str7.equals("DHCW---")) {
                    return 32224000;
                }
                if (str7.equals("DHPBP--")) {
                    return 32231700;
                }
                if (str7.equals("-HPFF--")) {
                    return 32232400;
                }
                if (str7.equals("-HHDR--")) {
                    return 322510000;
                }
                if (str7.equals("DHPMD--")) {
                    return 32233100;
                }
                if (str7.equals("DHPMRA-")) {
                    return 32233600;
                }
                if (str7.equals("DHPMRB-")) {
                    return 32233700;
                }
                if (str7.equals("DHPSPA-")) {
                    return 32234100;
                }
                if (str7.equals("DHPSPB-")) {
                    return 32234200;
                }
                if (str7.equals("DHPSPS-")) {
                    return 32234300;
                }
                if (str7.equals("DHABP--")) {
                    return 32244200;
                }
                if (str7.equals("DHALLA-")) {
                    return 32246000;
                }
                if (str7.equals("DHHD---")) {
                    return 32253000;
                }
                if (str7.equals("DHHDF--")) {
                    return 32254200;
                }
                if (str7.equals("DHHDK--")) {
                    return 32255200;
                }
                if (str7.equals("DHHDB--")) {
                    return 32259000;
                }
                if (str7.equals("DHHDD--")) {
                    return 322512000;
                }
                if (str7.equals("DTCCCFE")) {
                    return 32272000;
                }
                if (str7.equals("DTCCCFF")) {
                    return 32273000;
                }
                if (str7.equals("DL-RA--")) {
                    return 32530000;
                }
                if (str7.equals("DMPA---")) {
                    return 32680000;
                }
                if (str7.equals("DL-TA--")) {
                    return 32550000;
                }
                if (str7.equals("DOBVA--")) {
                    return 32311000;
                }
                if (str7.equals("DOBVB--")) {
                    return 32312000;
                }
                if (str7.equals("DOBVC--")) {
                    return 32313000;
                }
                if (str7.equals("DOBVD--")) {
                    return 32314000;
                }
                if (str7.equals("DOBVE--")) {
                    return 32315000;
                }
                if (str7.equals("DOBVF--")) {
                    return 32316000;
                }
                if (str7.equals("DOBVG--")) {
                    return 32317000;
                }
                if (str7.equals("DOBVH--")) {
                    return 32318000;
                }
                if (str7.equals("DOBVI--")) {
                    return 32319000;
                }
                if (str7.equals("DBSF---")) {
                    return 32321000;
                }
                if (str7.equals("DBSG---")) {
                    return 32322000;
                }
                if (str7.equals("DBSM---")) {
                    return 32323000;
                }
                if (str7.equals("DBST---")) {
                    return 32324000;
                }
                if (str7.equals("DGMSR--")) {
                    return 32411100;
                }
                if (str7.equals("DGMSC--")) {
                    return 32411200;
                }
                if (str7.equals("DGMSSVS")) {
                    return 32411300;
                }
                if (str7.equals("DGMSSC-")) {
                    return 32411400;
                }
                if (str7.equals("DGMSSM-")) {
                    return 32411500;
                }
                if (str7.equals("DGMSSF-")) {
                    return 32411600;
                }
                if (str7.equals("DGMSSVF")) {
                    return 32411700;
                }
                if (str7.equals("DGMSIVF")) {
                    return 32411800;
                }
                if (str7.equals("DGMSIF-")) {
                    return 32411900;
                }
                if (str7.equals("DGMSIM-")) {
                    return 324111000;
                }
                if (str7.equals("DGMSIC-")) {
                    return 324111100;
                }
                if (str7.equals("DGMSB--")) {
                    return 324111200;
                }
                if (str7.equals("DGMS-CO")) {
                    return 324111300;
                }
                if (str7.equals("DGMS-PH")) {
                    return 324111400;
                }
                if (str7.equals("DGMS-SH")) {
                    return 324111500;
                }
                if (str7.equals("DGML---")) {
                    return 324111600;
                }
                if (str7.equals("DGMN---")) {
                    return 324111700;
                }
                if (str7.equals("DGMRS--")) {
                    return 32412100;
                }
                if (str7.equals("DGMRM--")) {
                    return 32412200;
                }
                if (str7.equals("DGMRR--")) {
                    return 32412300;
                }
                if (str7.equals("DGMCL--")) {
                    return 32413100;
                }
                if (str7.equals("DGMCM--")) {
                    return 32413200;
                }
                if (str7.equals("DGMCH--")) {
                    return 32413300;
                }
                if (str7.equals("DGMIBA-")) {
                    return 32414100;
                }
                if (str7.equals("DGMIBB-")) {
                    return 32414200;
                }
                if (str7.equals("DGMIBC-")) {
                    return 32414300;
                }
                if (str7.equals("DGMIBD-")) {
                    return 32414400;
                }
                if (str7.equals("DGMIBE-")) {
                    return 32414500;
                }
                if (str7.equals("DGMBCA-")) {
                    return 32415100;
                }
                if (str7.equals("DGMBCB-")) {
                    return 32415200;
                }
                if (str7.equals("DGMBCC-")) {
                    return 32415300;
                }
                if (str7.equals("DGMBTA-")) {
                    return 32416100;
                }
                if (str7.equals("DGMBTB-")) {
                    return 32416200;
                }
                if (str7.equals("DGMBTC-")) {
                    return 32416300;
                }
                if (str7.equals("DGMBTD-")) {
                    return 32416400;
                }
                if (str7.equals("DGMBTE-")) {
                    return 32416500;
                }
                if (str7.equals("DGMBTF-")) {
                    return 32416600;
                }
                if (str7.equals("DGMBTG-")) {
                    return 32416700;
                }
                if (str7.equals("DGMBTH-")) {
                    return 32416800;
                }
                if (str7.equals("DGMBTI-")) {
                    return 32416900;
                }
                if (str7.equals("DL-SA--")) {
                    return 32540000;
                }
                if (str7.equals("DMOA---")) {
                    return 32670000;
                }
                if (str7.equals("DMCC---")) {
                    return 32620000;
                }
                if (str7.equals("DMCA---")) {
                    return 32610000;
                }
                if (str7.equals("DL-ML--")) {
                    return 32510000;
                }
                if (str7.equals("DL-MA--")) {
                    return 32520000;
                }
                if (str7.equals("DMCD---")) {
                    return 32630000;
                }
                if (str7.equals("DL-O---")) {
                    return 32560000;
                }
            }
            if (str5.equals("OLAGS") && c0.equals("G") && c2.equals("G")) {
                return 22521420;
            }
            if (str5.equals("OLAGM") && c0.equals("G") && c2.equals("G")) {
                return 22521410;
            }
            if (str5.equals("OLKGM") && c0.equals("G") && c2.equals("G")) {
                return 22522210;
            }
            if (str5.equals("OLKGS") && c0.equals("G") && c2.equals("G")) {
                return 22522220;
            }
            if (str4.equals("OLAA") && c0.equals("G") && c2.equals("G")) {
                return 22521200;
            }
            if (str4.equals("OLAR") && c0.equals("G") && c2.equals("G")) {
                return 22521300;
            }
            if (str4.equals("OLKA") && c0.equals("G") && c2.equals("G")) {
                return 22522100;
            }
            if (str4.equals("OLAV") && c0.equals("G") && c2.equals("G")) {
                return 22521100;
            }
            if (str4.equals("OADU") && c0.equals("G") && c2.equals("M")) {
                return 23131100;
            }
            if (str4.equals("OADC") && c0.equals("G") && c2.equals("M")) {
                return 23131200;
            }
            if (str4.equals("AAML") && c0.equals("G") && c2.equals("G")) {
                return 22234100;
            }
            if (str4.equals("AAMH") && c0.equals("G") && c2.equals("G")) {
                return 22234200;
            }
            if (str4.equals("DABP") && c0.equals("G") && c2.equals("G")) {
                return 22431100;
            }
            if (str4.equals("OWCT") && c0.equals("G") && c2.equals("M")) {
                return 231117300;
            }
            if (str4.equals("OWCD") && c0.equals("G") && c2.equals("M")) {
                return 231117200;
            }
            if (str4.equals("OWCS") && c0.equals("G") && c2.equals("M")) {
                return 231117100;
            }
            if (str4.equals("ACPR") && c0.equals("G") && c2.equals("F")) {
                return 24326101;
            }
            if (str4.equals("ACSI") && c0.equals("G") && c2.equals("F")) {
                return 24321100;
            }
            if (str4.equals("ACSR") && c0.equals("G") && c2.equals("F")) {
                return 24321200;
            }
            if (str4.equals("ACSC") && c0.equals("G") && c2.equals("F")) {
                return 24321300;
            }
            if (str4.equals("ACAI") && c0.equals("G") && c2.equals("F")) {
                return 24322100;
            }
            if (str4.equals("ACAR") && c0.equals("G") && c2.equals("F")) {
                return 24322200;
            }
            if (str4.equals("ACAC") && c0.equals("G") && c2.equals("F")) {
                return 24322300;
            }
            if (str4.equals("ACFI") && c0.equals("G") && c2.equals("F")) {
                return 24323100;
            }
            if (str4.equals("ACFR") && c0.equals("G") && c2.equals("F")) {
                return 24323200;
            }
            if (str4.equals("ACFC") && c0.equals("G") && c2.equals("F")) {
                return 24323300;
            }
            if (str4.equals("ACNI") && c0.equals("G") && c2.equals("F")) {
                return 24324100;
            }
            if (str4.equals("ACNR") && c0.equals("G") && c2.equals("F")) {
                return 24324200;
            }
            if (str4.equals("ACNC") && c0.equals("G") && c2.equals("F")) {
                return 24324300;
            }
            if (str4.equals("ACRI") && c0.equals("G") && c2.equals("F")) {
                return 24325100;
            }
            if (str4.equals("ACRR") && c0.equals("G") && c2.equals("F")) {
                return 24325200;
            }
            if (str4.equals("ACRC") && c0.equals("G") && c2.equals("F")) {
                return 24325300;
            }
            if (str4.equals("ACPC") && c0.equals("G") && c2.equals("F")) {
                return 24326200;
            }
            if (str4.equals("AZII") && c0.equals("G") && c2.equals("F")) {
                return 24331100;
            }
            if (str4.equals("AZIR") && c0.equals("G") && c2.equals("F")) {
                return 24331200;
            }
            if (str4.equals("AZIC") && c0.equals("G") && c2.equals("F")) {
                return 24331300;
            }
            if (str4.equals("AZXI") && c0.equals("G") && c2.equals("F")) {
                return 24332100;
            }
            if (str4.equals("AZXR") && c0.equals("G") && c2.equals("F")) {
                return 24332200;
            }
            if (str4.equals("AZXC") && c0.equals("G") && c2.equals("F")) {
                return 24332300;
            }
            if (str4.equals("AZSI") && c0.equals("G") && c2.equals("F")) {
                return 24333100;
            }
            if (str4.equals("ACEI") && c0.equals("G") && c2.equals("F")) {
                return 24333100;
            }
            if (str4.equals("AZSR") && c0.equals("G") && c2.equals("F")) {
                return 24333200;
            }
            if (str4.equals("ACER") && c0.equals("G") && c2.equals("F")) {
                return 24333200;
            }
            if (str4.equals("AZSC") && c0.equals("G") && c2.equals("F")) {
                return 24333300;
            }
            if (str4.equals("ACEC") && c0.equals("G") && c2.equals("F")) {
                return 24333300;
            }
            if (str4.equals("AZCI") && c0.equals("G") && c2.equals("F")) {
                return 24334100;
            }
            if (str4.equals("AZCR") && c0.equals("G") && c2.equals("F")) {
                return 24334200;
            }
            if (str4.equals("AZCC") && c0.equals("G") && c2.equals("F")) {
                return 24334300;
            }
            if (str4.equals("AZDI") && c0.equals("G") && c2.equals("F")) {
                return 24335100;
            }
            if (str4.equals("ACDI") && c0.equals("G") && c2.equals("F")) {
                return 24335100;
            }
            if (str4.equals("AZDR") && c0.equals("G") && c2.equals("F")) {
                return 24335200;
            }
            if (str4.equals("ACDR") && c0.equals("G") && c2.equals("F")) {
                return 24335200;
            }
            if (str4.equals("AZDC") && c0.equals("G") && c2.equals("F")) {
                return 24335300;
            }
            if (str4.equals("ACDC") && c0.equals("G") && c2.equals("F")) {
                return 24335300;
            }
            if (str4.equals("ACFZ") && c0.equals("G") && c2.equals("F")) {
                return 24336100;
            }
            if (str4.equals("AZFI") && c0.equals("G") && c2.equals("F")) {
                return 24336100;
            }
            if (str4.equals("AZFR") && c0.equals("G") && c2.equals("F")) {
                return 24336200;
            }
            if (str4.equals("AZFC") && c0.equals("G") && c2.equals("F")) {
                return 24336300;
            }
            if (str4.equals("AZZI") && c0.equals("G") && c2.equals("F")) {
                return 24337100;
            }
            if (str4.equals("AZOR") && c0.equals("G") && c2.equals("F")) {
                return 24337100;
            }
            if (str4.equals("ACZI") && c0.equals("G") && c2.equals("F")) {
                return 24337100;
            }
            if (str4.equals("AZZR") && c0.equals("G") && c2.equals("F")) {
                return 24337200;
            }
            if (str4.equals("ACZR") && c0.equals("G") && c2.equals("F")) {
                return 24337200;
            }
            if (str4.equals("AZZC") && c0.equals("G") && c2.equals("F")) {
                return 24337300;
            }
            if (str4.equals("ACZC") && c0.equals("G") && c2.equals("F")) {
                return 24337300;
            }
            if (str4.equals("AZBI") && c0.equals("G") && c2.equals("F")) {
                return 24338100;
            }
            if (str4.equals("ATBA") && c0.equals("G") && c2.equals("F")) {
                return 24338100;
            }
            if (str4.equals("ACBI") && c0.equals("G") && c2.equals("F")) {
                return 24338100;
            }
            if (str4.equals("AZBR") && c0.equals("G") && c2.equals("F")) {
                return 24338200;
            }
            if (str4.equals("ACBR") && c0.equals("G") && c2.equals("F")) {
                return 24338200;
            }
            if (str4.equals("AZBC") && c0.equals("G") && c2.equals("F")) {
                return 24338300;
            }
            if (str4.equals("ACBC") && c0.equals("G") && c2.equals("F")) {
                return 24338300;
            }
            if (str4.equals("AZVI") && c0.equals("G") && c2.equals("F")) {
                return 24339100;
            }
            if (str4.equals("ACVI") && c0.equals("G") && c2.equals("F")) {
                return 24339100;
            }
            if (str4.equals("AZVR") && c0.equals("G") && c2.equals("F")) {
                return 24339200;
            }
            if (str4.equals("ACVR") && c0.equals("G") && c2.equals("F")) {
                return 24339200;
            }
            if (str4.equals("AZVC") && c0.equals("G") && c2.equals("F")) {
                return 24339300;
            }
            if (str4.equals("ACVC") && c0.equals("G") && c2.equals("F")) {
                return 24339300;
            }
            if (str4.equals("AKBI") && c0.equals("G") && c2.equals("F")) {
                return 24351000;
            }
            if (str4.equals("AKBR") && c0.equals("G") && c2.equals("F")) {
                return 24352000;
            }
            if (str4.equals("AKBC") && c0.equals("G") && c2.equals("F")) {
                return 24353000;
            }
            if (str4.equals("AKPI") && c0.equals("G") && c2.equals("F")) {
                return 24361000;
            }
            if (str4.equals("AKPR") && c0.equals("G") && c2.equals("F")) {
                return 24362000;
            }
            if (str4.equals("AKPC") && c0.equals("G") && c2.equals("F")) {
                return 24363000;
            }
            if (str3.equals("LCR") && c0.equals("G") && c2.equals("F")) {
                return 24240000;
            }
            if (str3.equals("LCN") && c0.equals("G") && c2.equals("F")) {
                return 24230000;
            }
            if (str3.equals("LCM") && c0.equals("G") && c2.equals("F")) {
                return 24225000;
            }
            if (str3.equals("LCC") && c0.equals("G") && c2.equals("F")) {
                return 24220000;
            }
            if (str3.equals("LCF") && c0.equals("G") && c2.equals("F")) {
                return 24210000;
            }
            if (str3.equals("LTS") && c0.equals("G") && c2.equals("F")) {
                return 24211000;
            }
            if (str3.equals("AXC") && c0.equals("G") && c2.equals("F")) {
                return 243111000;
            }
            if (str3.equals("AXS") && c0.equals("G") && c2.equals("F")) {
                return 243112000;
            }
            if (str3.equals("LTF") && c0.equals("G") && c2.equals("F")) {
                return 24260000;
            }
            if (str3.equals("OWS") && c0.equals("G") && c2.equals("M")) {
                return 231112000;
            }
            if (str3.equals("OWD") && c0.equals("G") && c2.equals("M")) {
                return 231113000;
            }
            if (str3.equals("OWA") && c0.equals("G") && c2.equals("M")) {
                return 231114000;
            }
            if (str3.equals("OWU") && c0.equals("G") && c2.equals("M")) {
                return 231111000;
            }
            if (str3.equals("OWL") && c0.equals("G") && c2.equals("M")) {
                return 231115000;
            }
            if (str3.equals("OWH") && c0.equals("G") && c2.equals("M")) {
                return 231116000;
            }
            if (str3.equals("OAR") && c0.equals("G") && c2.equals("M")) {
                return 23132000;
            }
            if (str3.equals("OGB") && c0.equals("G") && c2.equals("M")) {
                return 23111000;
            }
            if (str3.equals("OAW") && c0.equals("G") && c2.equals("M")) {
                return 23134000;
            }
            if (str3.equals("SLA") && c0.equals("G") && c2.equals("G")) {
                return 22611000;
            }
            if (str3.equals("AAR") && c0.equals("G") && c2.equals("G")) {
                return 22231000;
            }
            if (str3.equals("OLI") && c0.equals("G") && c2.equals("G")) {
                return 22524000;
            }
            if (str3.equals("ORP") && c0.equals("G") && c2.equals("M")) {
                return 23191000;
            }
            if (str3.equals("ORS") && c0.equals("G") && c2.equals("M")) {
                return 23192000;
            }
            if (str3.equals("ORA") && c0.equals("G") && c2.equals("M")) {
                return 23193000;
            }
            if (str3.equals("ORC") && c0.equals("G") && c2.equals("M")) {
                return 23194000;
            }
            if (str3.equals("OLP") && c0.equals("G") && c2.equals("G")) {
                return 22528000;
            }
            if (str3.equals("BDD") && c0.equals("G") && c2.equals("M")) {
                return 23212000;
            }
            if (str3.equals("BDI") && c0.equals("G") && c2.equals("M")) {
                return 23213000;
            }
            if (str3.equals("BDE") && c0.equals("G") && c2.equals("M")) {
                return 23211000;
            }
            if (str3.equals("GLF") && c0.equals("G") && c2.equals("G")) {
                return 22122000;
            }
            if (str3.equals("GLC") && c0.equals("G") && c2.equals("G")) {
                return 22123000;
            }
            if (str3.equals("OLC") && c0.equals("G") && c2.equals("G")) {
                return 22527000;
            }
            if (str3.equals("OGZ") && c0.equals("G") && c2.equals("M")) {
                return 23113000;
            }
            if (str3.equals("SAE") && c0.equals("G") && c2.equals("G")) {
                return 22624000;
            }
            if (str3.equals("DAB") && c0.equals("G") && c2.equals("G")) {
                return 22431000;
            }
            if (str3.equals("GAA") && c0.equals("G") && c2.equals("G")) {
                return 22132000;
            }
            if (str3.equals("SAT") && c0.equals("G") && c2.equals("G")) {
                return 22626000;
            }
            if (str3.equals("ASB") && c0.equals("G") && c2.equals("S")) {
                return 25351000;
            }
            if (str3.equals("ASD") && c0.equals("G") && c2.equals("S")) {
                return 25352000;
            }
            if (str3.equals("GAE") && c0.equals("G") && c2.equals("G")) {
                return 22133000;
            }
            if (str3.equals("SAN") && c0.equals("G") && c2.equals("G")) {
                return 22625000;
            }
            if (str3.equals("GAF") && c0.equals("G") && c2.equals("G")) {
                return 22134000;
            }
            if (str3.equals("OGR") && c0.equals("G") && c2.equals("M")) {
                return 23115000;
            }
            if (str3.equals("OGF") && c0.equals("G") && c2.equals("M")) {
                return 23114000;
            }
            if (str3.equals("GAP") && c0.equals("G") && c2.equals("G")) {
                return 22138000;
            }
            if (str3.equals("GAL") && c0.equals("G") && c2.equals("G")) {
                return 22137000;
            }
            if (str3.equals("GAD") && c0.equals("G") && c2.equals("G")) {
                return 22135000;
            }
            if (str3.equals("AAF") && c0.equals("G") && c2.equals("G")) {
                return 22232000;
            }
            if (str3.equals("AAM") && c0.equals("G") && c2.equals("G")) {
                return 22234000;
            }
            if (str3.equals("AAW") && c0.equals("G") && c2.equals("G")) {
                return 22235000;
            }
            if (str3.equals("DLF") && c0.equals("G") && c2.equals("G")) {
                return 22421000;
            }
            if (str3.equals("ALS") && c0.equals("G") && c2.equals("G")) {
                return 22223000;
            }
            if (str3.equals("ALL") && c0.equals("G") && c2.equals("G")) {
                return 22225000;
            }
            if (str3.equals("ALC") && c0.equals("G") && c2.equals("G")) {
                return 22221000;
            }
            if (str3.equals("ALM") && c0.equals("G") && c2.equals("G")) {
                return 22222000;
            }
            if (str3.equals("ALU") && c0.equals("G") && c2.equals("G")) {
                return 22224000;
            }
            if (str3.equals("BCF") && c0.equals("G") && c2.equals("M")) {
                return 23223000;
            }
            if (str3.equals("BCB") && c0.equals("G") && c2.equals("M")) {
                return 23222000;
            }
            if (str3.equals("BCA") && c0.equals("G") && c2.equals("M")) {
                return 23221000;
            }
            if (str3.equals("OFG") && c0.equals("G") && c2.equals("M")) {
                return 23163000;
            }
            if (str3.equals("OHO") && c0.equals("G") && c2.equals("M")) {
                return 23200000;
            }
            if (str3.equals("BCE") && c0.equals("G") && c2.equals("M")) {
                return 23224000;
            }
            if (str3.equals("BCL") && c0.equals("G") && c2.equals("M")) {
                return 23226000;
            }
            if (str3.equals("BCR") && c0.equals("G") && c2.equals("M")) {
                return 23227000;
            }
            if (str3.equals("OED") && c0.equals("G") && c2.equals("M")) {
                return 23174000;
            }
            if (str3.equals("LRM") && c0.equals("G") && c2.equals("S")) {
                return 25221000;
            }
            if (str3.equals("LRA") && c0.equals("G") && c2.equals("S")) {
                return 25222000;
            }
            if (str3.equals("GLL") && c0.equals("G") && c2.equals("G")) {
                return 22125000;
            }
            if (str3.equals("OLT") && c0.equals("G") && c2.equals("G")) {
                return 22526000;
            }
            if (str3.equals("GLP") && c0.equals("G") && c2.equals("G")) {
                return 22124000;
            }
            if (str3.equals("OLF") && c0.equals("G") && c2.equals("G")) {
                return 22523000;
            }
            if (str3.equals("OLL") && c0.equals("G") && c2.equals("G")) {
                return 22525000;
            }
            if (str3.equals("SLB") && c0.equals("G") && c2.equals("G")) {
                return 22623000;
            }
            if (str3.equals("OEF") && c0.equals("G") && c2.equals("M")) {
                return 23172000;
            }
            if (str3.equals("OEB") && c0.equals("G") && c2.equals("M")) {
                return 23171000;
            }
            if (str3.equals("LRO") && c0.equals("G") && c2.equals("S")) {
                return 25223000;
            }
            if (str3.equals("LRT") && c0.equals("G") && c2.equals("S")) {
                return 25224000;
            }
            if (str3.equals("LRW") && c0.equals("G") && c2.equals("S")) {
                return 25225000;
            }
            if (str3.equals("ASR") && c0.equals("G") && c2.equals("S")) {
                return 25353000;
            }
            if (str3.equals("GLB") && c0.equals("G") && c2.equals("G")) {
                return 22121000;
            }
            if (str3.equals("GAG") && c0.equals("G") && c2.equals("G")) {
                return 22131000;
            }
            if (str3.equals("GAX") && c0.equals("G") && c2.equals("G")) {
                return 22136000;
            }
            if (str3.equals("GAZ") && c0.equals("G") && c2.equals("G")) {
                return 221311000;
            }
            if (str3.equals("AAH") && c0.equals("G") && c2.equals("G")) {
                return 22233000;
            }
            if (str3.equals("DAE") && c0.equals("G") && c2.equals("G")) {
                return 22432000;
            }
            if (str3.equals("OAA") && c0.equals("G") && c2.equals("G")) {
                return 22531000;
            }
            if (str3.equals("OAK") && c0.equals("G") && c2.equals("G")) {
                return 22532000;
            }
            if (str3.equals("OAO") && c0.equals("G") && c2.equals("G")) {
                return 22535000;
            }
            if (str3.equals("SAO") && c0.equals("G") && c2.equals("G")) {
                return 22621000;
            }
            if (str3.equals("SAA") && c0.equals("G") && c2.equals("G")) {
                return 22622000;
            }
            if (str3.equals("OAP") && c0.equals("G") && c2.equals("G")) {
                return 22536000;
            }
            if (str3.equals("SLH") && c0.equals("G") && c2.equals("G")) {
                return 22612000;
            }
            if (str3.equals("SLR") && c0.equals("G") && c2.equals("G")) {
                return 22613000;
            }
            if (str3.equals("OFD") && c0.equals("G") && c2.equals("M")) {
                return 23162000;
            }
            if (str3.equals("OFA") && c0.equals("G") && c2.equals("M")) {
                return 23164000;
            }
            if (str3.equals("GAS") && c0.equals("G") && c2.equals("G")) {
                return 22139000;
            }
            if (str3.equals("GAY") && c0.equals("G") && c2.equals("G")) {
                return 221310000;
            }
            if (str3.equals("DLP") && c0.equals("G") && c2.equals("G")) {
                return 22422000;
            }
            if (str3.equals("OAF") && c0.equals("G") && c2.equals("G")) {
                return 22533000;
            }
            if (str3.equals("OAS") && c0.equals("G") && c2.equals("G")) {
                return 22534000;
            }
            if (str3.equals("OMC") && c0.equals("G") && c2.equals("M")) {
                return 23157000;
            }
            if (str3.equals("OET") && c0.equals("G") && c2.equals("M")) {
                return 23173000;
            }
            if (str3.equals("LCM") && c0.equals("G") && c2.equals("S")) {
                return 25211000;
            }
            if (str3.equals("LCH") && c0.equals("G") && c2.equals("S")) {
                return 25212000;
            }
            if (str3.equals("OGL") && c0.equals("G") && c2.equals("M")) {
                return 23112000;
            }
            if (str3.equals("BCD") && c0.equals("G") && c2.equals("M")) {
                return 23225000;
            }
            if (str3.equals("DPT") && c0.equals("G") && c2.equals("G")) {
                return 22411000;
            }
            if (str3.equals("ATR") && c0.equals("G") && c2.equals("F")) {
                return 24311000;
            }
            if (str3.equals("ATC") && c0.equals("G") && c2.equals("F")) {
                return 24312000;
            }
            if (str3.equals("ATG") && c0.equals("G") && c2.equals("F")) {
                return 24313000;
            }
            if (str3.equals("ATS") && c0.equals("G") && c2.equals("F")) {
                return 24314000;
            }
            if (str3.equals("ATB") && c0.equals("G") && c2.equals("F")) {
                return 24315000;
            }
            if (str3.equals("ACT") && c0.equals("G") && c2.equals("F")) {
                return 24226000;
            }
            if (str2.equals("OT") && c0.equals("G") && c2.equals("M")) {
                return 231100000;
            }
            if (str2.equals("OS") && c0.equals("G") && c2.equals("M")) {
                return 23120000;
            }
            if (str2.equals("OU") && c0.equals("G") && c2.equals("M")) {
                return 23180000;
            }
            if (str2.equals("AD") && c0.equals("G") && c2.equals("S")) {
                return 25310000;
            }
            if (str2.equals("AE") && c0.equals("G") && c2.equals("S")) {
                return 25320000;
            }
            if (str2.equals("AH") && c0.equals("G") && c2.equals("S")) {
                return 25340000;
            }
            if (str2.equals("NL") && c0.equals("G") && c2.equals("M")) {
                return 23490000;
            }
            if (str2.equals("NR") && c0.equals("G") && c2.equals("M")) {
                return 23440000;
            }
            if (str2.equals("NC") && c0.equals("G") && c2.equals("M")) {
                return 23460000;
            }
            if (str2.equals("NB") && c0.equals("G") && c2.equals("M")) {
                return 23450000;
            }
            if (str2.equals("AF") && c0.equals("G") && c2.equals("F")) {
                return 24323100;
            }
            if (str2.equals("AA") && c0.equals("G") && c2.equals("F")) {
                return 24321100;
            }
            if (str2.equals("AR") && c0.equals("G") && c2.equals("F")) {
                return 24325100;
            }
            if (str2.equals("AS") && c0.equals("G") && c2.equals("T")) {
                return 211210000;
            }
            if (str2.equals("AR") && c0.equals("G") && c2.equals("S")) {
                return 25330000;
            }
            if (str2.equals("PA") && c0.equals("G") && c2.equals("G")) {
                return 22320000;
            }
            if (str2.equals("PF") && c0.equals("G") && c2.equals("G")) {
                return 22330000;
            }
            if (str2.equals("SP") && c0.equals("G") && c2.equals("M")) {
                return 23350000;
            }
            if (str2.equals("LT") && c0.equals("G") && c2.equals("F")) {
                return 24250000;
            }
            if (str2.equals("SL") && c0.equals("G") && c2.equals("M")) {
                return 23330000;
            }
            if (str2.equals("LP") && c0.equals("G") && c2.equals("F")) {
                return 24260000;
            }
            if (str2.equals("AC") && c0.equals("G") && c2.equals("F")) {
                return 24322100;
            }
            if (str2.equals("AT") && c0.equals("G") && c2.equals("F")) {
                return 24330000;
            }
            if (str2.equals("AK") && c0.equals("G") && c2.equals("F")) {
                return 24314000;
            }
            if (str2.equals("AS") && c0.equals("G") && c2.equals("F")) {
                return 24313000;
            }
            if (str2.equals("AB") && c0.equals("G") && c2.equals("F")) {
                return 24315000;
            }
            if (str2.equals("BE") && c0.equals("G") && c2.equals("O")) {
                return 26410000;
            }
            if (str2.equals("BA") && c0.equals("G") && c2.equals("O")) {
                return 26420000;
            }
            if (str2.equals("BT") && c0.equals("G") && c2.equals("O")) {
                return 26430000;
            }
            if (str2.equals("BO") && c0.equals("G") && c2.equals("O")) {
                return 26440000;
            }
            if (str2.equals("PC") && c0.equals("G") && c2.equals("G")) {
                return 0x222248;
            }
            if (str2.equals("PN") && c0.equals("G") && c2.equals("G")) {
                return 22360000;
            }
            if (str2.equals("UC") && c0.equals("G") && c2.equals("T")) {
                if (rev == 1) {
                    return 212230001;
                }
                return 212230000;
            }
            if (str2.equals("US") && c0.equals("G") && c2.equals("T")) {
                if (rev == 1) {
                    return 212210001;
                }
                return 212210000;
            }
            if (str2.equals("UG") && c0.equals("G") && c2.equals("T")) {
                if (rev == 1) {
                    return 212220001;
                }
                return 212220000;
            }
            if (str2.equals("PM") && c0.equals("G") && c2.equals("G")) {
                return 22340000;
            }
            if (str2.equals("PY") && c0.equals("G") && c2.equals("G")) {
                return 22350000;
            }
            if (str2.equals("PD") && c0.equals("G") && c2.equals("G")) {
                return 22310000;
            }
            if (str2.equals("SW") && c0.equals("G") && c2.equals("M")) {
                return 23340000;
            }
            if (str2.equals("KF") && c0.equals("G") && c2.equals("T")) {
                return 21710000;
            }
            if (str2.equals("NL") && c0.equals("G") && c2.equals("M")) {
                return 23490000;
            }
            if (str2.equals("NM") && c0.equals("G") && c2.equals("M")) {
                return 23410000;
            }
            if (str2.equals("WP") && c0.equals("G") && c2.equals("T")) {
                return 212410000;
            }
            if (str2.equals("HN") && c0.equals("G") && c2.equals("O")) {
                return 26220000;
            }
            if (str2.equals("SF") && c0.equals("G") && c2.equals("M")) {
                return 23320000;
            }
            if (str1.equals("R") && c0.equals("G") && c2.equals("T")) {
                return 211800000;
            }
            if (str1.equals("A") && c0.equals("G") && c2.equals("T")) {
                return 211200000;
            }
            if (str1.equals("M") && c0.equals("G") && c2.equals("T")) {
                return 212000000;
            }
            if (str1.equals("B") && c0.equals("G") && c2.equals("O")) {
                return 26400000;
            }
            if (str1.equals("L") && c0.equals("G") && c2.equals("T")) {
                return 21800000;
            }
            if (str1.equals("V") && c0.equals("G") && c2.equals("T")) {
                return 212500000;
            }
            if (str1.equals("2") && c0.equals("G") && c2.equals("T")) {
                return 212600000;
            }
            if (str1.equals("W") && c0.equals("G") && c2.equals("T")) {
                return 212400000;
            }
            if (str1.equals("H") && c0.equals("G") && c2.equals("T")) {
                return 21200000;
            }
            if (str1.equals("C") && c0.equals("G") && c2.equals("T")) {
                return 21400000;
            }
            if (str1.equals("Y") && c0.equals("G") && c2.equals("T")) {
                return 21300000;
            }
            if (str1.equals("B") && c0.equals("G") && c2.equals("T")) {
                return 21100000;
            }
            if (str1.equals("T") && c0.equals("G") && c2.equals("T")) {
                return 211000000;
            }
            if (str1.equals("Z") && c0.equals("G") && c2.equals("T")) {
                if (rev == 1) {
                    return 212300001;
                }
                return 212300000;
            }
            if (str1.equals("S") && c0.equals("G") && c2.equals("T")) {
                return 212100000;
            }
            if (str1.equals("Q") && c0.equals("G") && c2.equals("T")) {
                return 211900000;
            }
            if (str1.equals("P") && c0.equals("G") && c2.equals("T")) {
                return 211700000;
            }
            if (str1.equals("E") && c0.equals("G") && c2.equals("T")) {
                return 211400000;
            }
            if (str1.equals("X") && c0.equals("G") && c2.equals("T")) {
                return 21500000;
            }
            if (str1.equals("J") && c0.equals("G") && c2.equals("T")) {
                return 21600000;
            }
            if (str1.equals("O") && c0.equals("G") && c2.equals("T")) {
                return 211600000;
            }
            if (str1.equals("F") && c0.equals("G") && c2.equals("T")) {
                return 211100000;
            }
            if (str1.equals("K") && c0.equals("G") && c2.equals("T")) {
                return 21700000;
            }
            if (str1.equals("D") && c0.equals("G") && c2.equals("T")) {
                return 21900000;
            }
            if (str1.equals("I") && c0.equals("G") && c2.equals("T")) {
                return 211300000;
            }
            if (str1.equals("N") && c0.equals("G") && c2.equals("T")) {
                return 211500000;
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException((String)_className, (String)"CGetLinetypeFromString", (Exception)new RendererException("Failed inside CGetLinetypeFromString " + strLine, (Throwable)exc));
        }
        return -1;
    }

    public static int CIsChannel(int lineType) {
        int lResult = 0;
        try {
            switch (lineType) {
                case 15000000: 
                case 21700000: 
                case 21710000: 
                case 22123000: 
                case 22123001: 
                case 22320000: 
                case 22320001: 
                case 22521100: 
                case 22521200: 
                case 22521300: 
                case 22521410: 
                case 22521411: 
                case 22521420: 
                case 22521421: 
                case 231111000: 
                case 231112000: 
                case 231113000: 
                case 231113001: 
                case 231113002: 
                case 231113003: 
                case 231114000: 
                case 231115000: 
                case 231116000: 
                case 231117100: 
                case 231117101: 
                case 231117200: 
                case 231117201: 
                case 231117300: 
                case 231117301: {
                    lResult = 1;
                    break;
                }
                default: {
                    lResult = 0;
                    break;
                }
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException((String)_className, (String)"CIsChannel", (Exception)new RendererException("Failed inside CIsChannel " + Integer.toString(lineType), (Throwable)exc));
        }
        return lResult;
    }

    public static void setClient(String value) {
        _client = value;
        Channels.setClient(value);
    }

    public static String getClient() {
        return _client;
    }
}

