/*
 * Decompiled with CFR 0.152.
 */
package ArmyC2.C2SD.Rendering;

import ArmyC2.C2SD.Utilities.IMultiPointRenderer;
import ArmyC2.C2SD.Utilities.IPointConversion;
import ArmyC2.C2SD.Utilities.MilStdSymbol;
import ArmyC2.C2SD.Utilities.RendererSettings;
import ArmyC2.C2SD.Utilities.SymbolDraw;
import ArmyC2.C2SD.Utilities.SymbolUtilities;
import RenderMultipoints.clsRenderer;
import java.util.ArrayList;

public class MultiPointRenderer
implements IMultiPointRenderer {
    private static MultiPointRenderer _instance = null;

    public static synchronized MultiPointRenderer getInstance() {
        if (_instance == null) {
            _instance = new MultiPointRenderer();
        }
        return _instance;
    }

    public MilStdSymbol render(MilStdSymbol symbol, IPointConversion converter, Object clipBounds) {
        try {
            if (SymbolUtilities.getBasicSymbolID((String)symbol.getSymbolID()).equals("G*F*AXS---****X") && symbol.getModifiers_AM_AN_X("AN") != null && symbol.getModifiers_AM_AN_X("AM") != null) {
                int anCount = symbol.getModifiers_AM_AN_X("AN").size();
                int amCount = symbol.getModifiers_AM_AN_X("AM").size();
                ArrayList am = null;
                if (amCount < anCount / 2 + 1 && (Double)(am = symbol.getModifiers_AM_AN_X("AM")).get(0) != 0.0) {
                    am.add(0, 0.0);
                }
            }
            ArrayList modifiers = null;
            clsRenderer.render((MilStdSymbol)symbol, (IPointConversion)converter, (Object)clipBounds);
            modifiers = symbol.getModifierShapes();
            if (RendererSettings.getInstance().getTextBackgroundMethod() != 0) {
                modifiers = SymbolDraw.ProcessModifierBackgrounds((ArrayList)modifiers);
                symbol.setModifierShapes(modifiers);
            }
        }
        catch (Exception exc) {
            String message = "Failed to build multipoint TG";
            if (symbol != null) {
                message = message + ": " + symbol.getSymbolID();
            }
            System.err.println(exc.getMessage());
        }
        catch (Throwable t) {
            String message2 = "Failed to build multipoint TG";
            if (symbol != null) {
                message2 = message2 + ": " + symbol.getSymbolID();
            }
            System.err.println(t.getMessage());
        }
        return symbol;
    }

    public MilStdSymbol renderWithPolylines(MilStdSymbol symbol, IPointConversion converter, Object clipBounds) {
        clsRenderer.renderWithPolylines((MilStdSymbol)symbol, (IPointConversion)converter, (Object)clipBounds);
        return symbol;
    }
}

