/*
 * Decompiled with CFR 0.152.
 */
package armyc2.c5isr.RenderMultipoints;

import armyc2.c5isr.JavaLineArray.POINT2;
import armyc2.c5isr.JavaLineArray.Shape2;
import armyc2.c5isr.JavaLineArray.lineutility;
import armyc2.c5isr.JavaTacticalRenderer.TGLight;
import armyc2.c5isr.renderer.PatternFillRenderer;
import armyc2.c5isr.renderer.utilities.ErrorLogger;
import armyc2.c5isr.renderer.utilities.IPointConversion;
import armyc2.c5isr.renderer.utilities.RendererException;
import armyc2.c5isr.renderer.utilities.ShapeInfo;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.geom.Area;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;

public final class clsUtility {
    private static final String _className = "clsUtility";
    public static final int Hatch_ForwardDiagonal = 2;
    public static final int Hatch_BackwardDiagonal = 3;
    public static final int Hatch_Vertical = 4;
    public static final int Hatch_Horizontal = 5;
    public static final int Hatch_Cross = 8;

    protected static void addHatchFills(TGLight tg, ArrayList<ShapeInfo> shapes) {
        try {
            if (shapes == null || shapes.size() == 0) {
                return;
            }
            int lineType = tg.get_LineType();
            int hatchStyle = tg.get_FillStyle();
            int j = 0;
            int hatch2 = 0;
            Shape2 shape2 = null;
            int index = 0;
            float hatchLineThickness = 1.5f + ((float)tg.get_LineThickness() / 2.0f - 1.5f) * (float)tg.get_patternScale();
            Color hatchColor = tg.get_LineColor();
            int hatchSpacing = (int)(hatchLineThickness * 10.0f);
            if (!armyc2.c5isr.JavaTacticalRenderer.clsUtility.isClosedPolygon(lineType) && !armyc2.c5isr.JavaTacticalRenderer.clsUtility.IsChange1Area(lineType)) {
                switch (lineType) {
                    case 15000000: 
                    case 15000001: 
                    case 15000003: {
                        break;
                    }
                    default: {
                        return;
                    }
                }
            }
            switch (lineType) {
                case 24324100: 
                case 24324200: 
                case 24324300: 
                case 221310000: {
                    hatchStyle = 3;
                    break;
                }
                case 271900: 
                case 23440000: 
                case 23450000: 
                case 23460000: {
                    hatchStyle = 3;
                    hatchColor = Color.yellow;
                    hatchLineThickness = 3.0f + (float)(tg.get_LineThickness() - 3) * (float)tg.get_patternScale();
                    break;
                }
                case 2517200: 
                case 22235000: {
                    hatchStyle = 3;
                    if (tg.get_LineColor() == Color.BLACK) {
                        hatchColor = Color.GRAY;
                    }
                    hatchSpacing /= 2;
                    break;
                }
                case 23115000: {
                    for (j = 0; j < shapes.size(); ++j) {
                        ShapeInfo shape = shapes.get(j);
                        Color color = shape.getLineColor();
                        if (color == null || shape.getLineColor().getRGB() != 0) continue;
                        shapes.remove(j);
                    }
                    hatchStyle = 3;
                    hatchSpacing = (int)((double)hatchSpacing * 1.25);
                    break;
                }
                default: {
                    if (hatchStyle > 0) break;
                    return;
                }
            }
            int n = shapes.size();
            for (j = 0; j < n; ++j) {
                shape2 = (Shape2)shapes.get(j);
                hatch2 = shape2.get_FillStyle();
                if (hatch2 != hatchStyle) continue;
                index = j;
                break;
            }
            n = shapes.size();
            for (int k = 0; k < n; ++k) {
                ShapeInfo shape = null;
                if (lineType == 243111000 || lineType == 243112000 || lineType == 25200700) {
                    shape = shapes.get(k);
                    shape2 = (Shape2)shapes.get(k);
                    hatchStyle = shape2.get_FillStyle();
                } else {
                    shape = shapes.get(index);
                }
                if (hatchStyle < 2) continue;
                if (tg.get_UseHatchFill()) {
                    BufferedImage hatchImg = PatternFillRenderer.MakeHatchPatternFill(hatchStyle, hatchSpacing, (int)hatchLineThickness, hatchColor);
                    shape.setPatternFillImage(hatchImg);
                    Rectangle2D.Double rect = new Rectangle2D.Double(0.0, 0.0, hatchImg.getWidth(), hatchImg.getHeight());
                    TexturePaint tp = new TexturePaint(shape.getPatternFillImage(), rect);
                    shape.setTexturePaint(tp);
                } else if (hatchStyle != 8) {
                    Shape2 shape3 = clsUtility.buildHatchArea(tg, shape, hatchStyle, hatchSpacing);
                    shape3.setStroke(new BasicStroke(hatchLineThickness));
                    shape3.setLineColor(hatchColor);
                    shapes.add(shape3);
                } else {
                    Shape2 shapeBk = clsUtility.buildHatchArea(tg, shape, 3, hatchSpacing);
                    Shape2 shapeFwd = clsUtility.buildHatchArea(tg, shape, 2, hatchSpacing);
                    shapeBk.setStroke(new BasicStroke(hatchLineThickness));
                    shapeBk.setLineColor(hatchColor);
                    shapes.add(shapeBk);
                    shapeFwd.setStroke(new BasicStroke(hatchLineThickness));
                    shapeFwd.setLineColor(hatchColor);
                    shapes.add(shapeFwd);
                }
                if (lineType == 243111000 || lineType == 243112000 || lineType == 25200700) {
                    continue;
                }
                break;
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "addHatchFills", new RendererException("Failed inside addHatchFills", exc));
        }
    }

    protected static Shape2 buildHatchArea(TGLight tg, ShapeInfo shape, int hatchStyle, double spacing) {
        Shape2 hatchLineShape = null;
        try {
            hatchLineShape = new Shape2(Shape2.SHAPE_TYPE_POLYLINE);
            Area hatchLineArea = null;
            Rectangle rect = shape.getBounds();
            double x0 = rect.getX();
            double y0 = rect.getY();
            double width = rect.getWidth();
            double height = rect.getHeight();
            if (width > height) {
                height = width;
            } else {
                width = height;
            }
            if (tg.get_UseHatchFill()) {
                hatchLineShape.set_Fillstyle(hatchStyle);
                hatchLineShape.setShape(lineutility.createStrokedShape(shape.getShape()));
                return hatchLineShape;
            }
            width *= 2.0;
            height *= 2.0;
            int horizLimit = 0;
            int vertLimit = 0;
            int j = 0;
            ArrayList<POINT2> vertPts = new ArrayList<POINT2>();
            ArrayList<POINT2> horizPts = new ArrayList<POINT2>();
            POINT2 vertPt = null;
            POINT2 horizPt = null;
            if (hatchStyle == 3) {
                horizLimit = (int)(width / spacing);
                vertLimit = (int)(height / spacing);
                for (j = 0; j < vertLimit; ++j) {
                    vertPt = new POINT2(x0, y0 + spacing * (double)j);
                    vertPts.add(vertPt);
                }
                for (j = 0; j < horizLimit; ++j) {
                    horizPt = new POINT2(x0 + spacing * (double)j, y0);
                    horizPts.add(horizPt);
                }
                hatchLineShape.moveTo(new POINT2(x0 - spacing / 2.0, y0 - spacing / 2.0));
                hatchLineShape.lineTo(new POINT2(x0, y0));
                for (j = 0; j < vertLimit; ++j) {
                    if (j % 2 == 0) {
                        hatchLineShape.lineTo((POINT2)vertPts.get(j));
                        hatchLineShape.lineTo((POINT2)horizPts.get(j));
                        continue;
                    }
                    hatchLineShape.lineTo((POINT2)horizPts.get(j));
                    hatchLineShape.lineTo((POINT2)vertPts.get(j));
                }
                hatchLineShape.lineTo(new POINT2(x0 + width + spacing / 2.0, y0 + height + spacing / 2.0));
                hatchLineShape.lineTo(new POINT2(x0 + width + spacing, y0 + height + spacing / 2.0));
                hatchLineShape.lineTo(new POINT2(x0 + width + spacing, y0 - spacing / 2.0));
                hatchLineShape.lineTo(new POINT2(x0 - spacing / 2.0, y0 - spacing / 2.0));
            }
            if (hatchStyle == 2) {
                horizLimit = (int)(width / spacing);
                vertLimit = (int)(height / spacing);
                width /= 2.0;
                for (j = 0; j < vertLimit; ++j) {
                    vertPt = new POINT2(x0 + width, y0 + spacing * (double)j);
                    vertPts.add(vertPt);
                }
                for (j = 0; j < horizLimit; ++j) {
                    horizPt = new POINT2(x0 + width - spacing * (double)j, y0);
                    horizPts.add(horizPt);
                }
                hatchLineShape.moveTo(new POINT2(x0 + width + spacing / 2.0, y0 - spacing / 2.0));
                hatchLineShape.lineTo(new POINT2(x0, y0));
                for (j = 0; j < vertLimit; ++j) {
                    if (j % 2 == 0) {
                        hatchLineShape.lineTo((POINT2)vertPts.get(j));
                        hatchLineShape.lineTo((POINT2)horizPts.get(j));
                        continue;
                    }
                    hatchLineShape.lineTo((POINT2)horizPts.get(j));
                    hatchLineShape.lineTo((POINT2)vertPts.get(j));
                }
                hatchLineShape.lineTo(new POINT2(x0 - spacing / 2.0, y0 + height + spacing / 2.0));
                hatchLineShape.lineTo(new POINT2(x0 - spacing, y0 + height + spacing / 2.0));
                hatchLineShape.lineTo(new POINT2(x0 - spacing, y0 - spacing / 2.0));
                hatchLineShape.lineTo(new POINT2(x0 + width + spacing / 2.0, y0 - spacing / 2.0));
            }
            if (hatchStyle == 4) {
                horizLimit = (int)(width / (spacing / 2.0));
                vertLimit = (int)(height / (spacing / 2.0));
                for (j = 0; j < horizLimit; ++j) {
                    if (j % 2 == 0) {
                        vertPt = new POINT2(x0 + spacing / 2.0 * (double)j, y0);
                        vertPts.add(vertPt);
                        vertPt = new POINT2(x0 + spacing / 2.0 * (double)j, y0 + height);
                        vertPts.add(vertPt);
                        continue;
                    }
                    vertPt = new POINT2(x0 + spacing / 2.0 * (double)j, y0 + height);
                    vertPts.add(vertPt);
                    vertPt = new POINT2(x0 + spacing / 2.0 * (double)j, y0);
                    vertPts.add(vertPt);
                }
                hatchLineShape.moveTo(new POINT2(x0 - spacing / 2.0, y0 - spacing / 2.0));
                hatchLineShape.lineTo(new POINT2(x0, y0));
                for (j = 0; j < vertLimit - 1; ++j) {
                    hatchLineShape.lineTo((POINT2)vertPts.get(j));
                }
                hatchLineShape.lineTo(new POINT2(x0 + width + spacing / 2.0, y0 + height + spacing / 2.0));
                hatchLineShape.lineTo(new POINT2(x0 + width + spacing, y0 + height + spacing / 2.0));
                hatchLineShape.lineTo(new POINT2(x0 + width + spacing, y0 - spacing / 2.0));
                hatchLineShape.lineTo(new POINT2(x0 - spacing / 2.0, y0 - spacing / 2.0));
            }
            if (hatchStyle == 5) {
                horizLimit = (int)(width / (spacing / 2.0));
                vertLimit = (int)(height / (spacing / 2.0));
                for (j = 0; j < vertLimit; ++j) {
                    if (j % 2 == 0) {
                        horizPt = new POINT2(x0, y0 + spacing / 2.0 * (double)j);
                        horizPts.add(horizPt);
                        horizPt = new POINT2(x0 + width, y0 + spacing / 2.0 * (double)j);
                        horizPts.add(horizPt);
                        continue;
                    }
                    horizPt = new POINT2(x0 + width, y0 + spacing / 2.0 * (double)j);
                    horizPts.add(horizPt);
                    horizPt = new POINT2(x0, y0 + spacing / 2.0 * (double)j);
                    horizPts.add(horizPt);
                }
                hatchLineShape.moveTo(new POINT2(x0 - spacing / 2.0, y0 - spacing / 2.0));
                hatchLineShape.lineTo(new POINT2(x0, y0));
                for (j = 0; j < vertLimit - 1; ++j) {
                    hatchLineShape.lineTo((POINT2)horizPts.get(j));
                }
                hatchLineShape.lineTo(new POINT2(x0 - spacing / 2.0, y0 + height + spacing / 2.0));
                hatchLineShape.lineTo(new POINT2(x0 - spacing, y0 + height + spacing / 2.0));
                hatchLineShape.lineTo(new POINT2(x0 - spacing, y0 - spacing / 2.0));
                hatchLineShape.lineTo(new POINT2(x0 + width + spacing / 2.0, y0 - spacing / 2.0));
            }
            Area shapeArea = new Area(shape.getShape());
            hatchLineArea = new Area(hatchLineShape.getShape());
            hatchLineArea.intersect(shapeArea);
            hatchLineShape.setShape(hatchLineArea);
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "buildHatchArea", new RendererException("Failed inside buildHatchArea", exc));
        }
        return hatchLineShape;
    }

    protected static Point POINT2ToPoint(POINT2 pt2) {
        Point pt = new Point();
        pt.x = (int)pt2.x;
        pt.y = (int)pt2.y;
        return pt;
    }

    protected static POINT2 PointToPOINT2(Point pt) {
        POINT2 pt2 = new POINT2(pt.x, pt.y);
        return pt2;
    }

    protected static Point2D.Double POINT2ToPoint2D(POINT2 pt2) {
        Point2D.Double pt2d = new Point2D.Double(pt2.x, pt2.y);
        return pt2d;
    }

    protected static ArrayList<POINT2> Points2DToPOINT2(ArrayList<Point2D> pts2d) {
        ArrayList<POINT2> pts = new ArrayList<POINT2>();
        POINT2 pt = null;
        int n = pts2d.size();
        for (int j = 0; j < n; ++j) {
            pt = new POINT2(pts2d.get(j).getX(), pts2d.get(j).getY());
            pts.add(pt);
        }
        return pts;
    }

    protected static POINT2 Point2DToPOINT2(Point2D pt2d) {
        POINT2 pt2 = new POINT2(pt2d.getX(), pt2d.getY());
        return pt2;
    }

    protected static boolean addModifiersBeforeClipping(TGLight tg) {
        boolean result = false;
        int linetype = tg.get_LineType();
        switch (linetype) {
            case 110300: 
            case 220101: 
            case 220104: 
            case 220107: 
            case 220108: 
            case 2514190: 
            case 21700000: 
            case 21710000: 
            case 21800000: 
            case 22121000: 
            case 22122000: 
            case 22123000: 
            case 22124000: 
            case 22125000: 
            case 22221000: 
            case 22222000: 
            case 22223000: 
            case 22224000: 
            case 22225000: 
            case 22422000: 
            case 22522100: 
            case 22523000: 
            case 22524000: 
            case 22525000: 
            case 22526000: 
            case 22527000: 
            case 22528000: 
            case 22612000: 
            case 22612001: 
            case 22613000: 
            case 22623000: 
            case 22623001: 
            case 23163000: 
            case 23410000: 
            case 24210000: 
            case 24211000: 
            case 24220000: 
            case 24225000: 
            case 24230000: 
            case 24240000: 
            case 24250000: 
            case 24260000: 
            case 25110400: 
            case 25140400: 
            case 25141800: 
            case 25152800: 
            case 25170400: 
            case 25170600: 
            case 25190100: 
            case 25190200: 
            case 25211000: 
            case 25212000: 
            case 25221000: 
            case 25222000: 
            case 25260400: 
            case 25300100: 
            case 25330301: 
            case 25330302: 
            case 25330303: 
            case 25330401: 
            case 25330402: 
            case 25330403: 
            case 25330500: 
            case 25330501: 
            case 25330502: 
            case 25343300: 
            case 25344100: 
            case 25344200: 
            case 25344400: 
            case 26400000: 
            case 26410000: 
            case 26420000: 
            case 26430000: 
            case 26440000: 
            case 211800000: 
            case 212000000: 
            case 212210000: 
            case 212220000: 
            case 212230000: 
            case 212400000: 
            case 212410000: 
            case 231100000: 
            case 1325260400: {
                result = true;
                break;
            }
        }
        if (armyc2.c5isr.JavaTacticalRenderer.clsUtility.isClosedPolygon(linetype)) {
            result = true;
        }
        return result;
    }

    protected static void FilterPoints(TGLight tg) {
        try {
            int lineType = tg.get_LineType();
            double minSpikeDistance = 0.0;
            switch (lineType) {
                case 22122000: 
                case 22134000: 
                case 23131100: 
                case 23131200: 
                case 23132000: 
                case 23330000: 
                case 23350000: 
                case 1322134000: {
                    minSpikeDistance = 25.0;
                    break;
                }
                case 22123000: 
                case 22624000: 
                case 23112000: 
                case 23113000: 
                case 23114000: 
                case 23115000: 
                case 23134000: 
                case 231111000: 
                case 231112000: 
                case 231113000: 
                case 231114000: 
                case 231115000: 
                case 231116000: 
                case 231117100: 
                case 231117200: 
                case 231117300: {
                    minSpikeDistance = 35.0;
                    break;
                }
                case 31131000: 
                case 31131100: 
                case 31131200: 
                case 31131300: {
                    minSpikeDistance = 60.0;
                    break;
                }
                case 31133000: 
                case 31133100: 
                case 31134000: 
                case 31134100: {
                    minSpikeDistance = 60.0;
                    break;
                }
                case 31134200: 
                case 31134300: {
                    minSpikeDistance = 60.0;
                    break;
                }
                case 31132200: 
                case 31132300: 
                case 31133200: {
                    minSpikeDistance = 60.0;
                    break;
                }
                case 31132000: 
                case 31132100: {
                    minSpikeDistance = 40.0;
                    break;
                }
                case 31142000: 
                case 32156000: 
                case 32162000: 
                case 32164000: {
                    minSpikeDistance = 35.0;
                    break;
                }
                default: {
                    return;
                }
            }
            int j = 0;
            double dist = 0.0;
            ArrayList<POINT2> pts = new ArrayList<POINT2>();
            ArrayList<POINT2> ptsGeo = new ArrayList<POINT2>();
            pts.add(tg.Pixels.get(0));
            ptsGeo.add(tg.LatLongs.get(0));
            POINT2 lastGoodPt = tg.Pixels.get(0);
            POINT2 currentPt = null;
            POINT2 currentPtGeo = null;
            boolean foundGoodPt = false;
            int n = tg.Pixels.size();
            block15: for (j = 1; j < n; ++j) {
                currentPt = tg.Pixels.get(j);
                currentPtGeo = tg.LatLongs.get(j);
                if (currentPt.style == -1) {
                    lastGoodPt = currentPt;
                    pts.add(currentPt);
                    ptsGeo.add(currentPtGeo);
                    foundGoodPt = true;
                    currentPt.style = 0;
                    continue;
                }
                dist = lineutility.CalcDistanceDouble(lastGoodPt, currentPt);
                switch (lineType) {
                    case 22123000: {
                        if (dist > minSpikeDistance) {
                            lastGoodPt = currentPt;
                            pts.add(currentPt);
                            ptsGeo.add(currentPtGeo);
                            foundGoodPt = true;
                            continue block15;
                        }
                        if (j != tg.Pixels.size() - 1) continue block15;
                        pts.set(pts.size() - 1, currentPt);
                        ptsGeo.set(ptsGeo.size() - 1, currentPtGeo);
                        continue block15;
                    }
                    default: {
                        if (!(dist > minSpikeDistance) && j != tg.Pixels.size() - 1) continue block15;
                        lastGoodPt = currentPt;
                        pts.add(currentPt);
                        ptsGeo.add(currentPtGeo);
                        foundGoodPt = true;
                    }
                }
            }
            if (foundGoodPt) {
                tg.Pixels = pts;
                tg.LatLongs = ptsGeo;
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "FilterPoints", new RendererException("Failed inside FilterPoints", exc));
        }
    }

    public static ArrayList<POINT2> PixelsToLatLong(ArrayList<POINT2> pts, IPointConversion converter) {
        int j = 0;
        POINT2 pt = null;
        POINT2 ptGeo = null;
        ArrayList<POINT2> ptsGeo = new ArrayList<POINT2>();
        int n = pts.size();
        for (j = 0; j < n; ++j) {
            pt = pts.get(j);
            ptGeo = clsUtility.PointPixelsToLatLong(pt, converter);
            ptsGeo.add(ptGeo);
        }
        return ptsGeo;
    }

    protected static ArrayList<POINT2> LatLongToPixels(ArrayList<POINT2> pts, IPointConversion converter) {
        int j = 0;
        POINT2 pt = null;
        POINT2 ptPixels = null;
        ArrayList<POINT2> ptsPixels = new ArrayList<POINT2>();
        int n = pts.size();
        for (j = 0; j < n; ++j) {
            pt = pts.get(j);
            ptPixels = clsUtility.PointLatLongToPixels(pt, converter);
            ptsPixels.add(ptPixels);
        }
        return ptsPixels;
    }

    private static POINT2 PointLatLongToPixels(POINT2 ptLatLong, IPointConversion converter) {
        POINT2 pt2 = new POINT2();
        try {
            Point2D pt2d = clsUtility.POINT2ToPoint2D(ptLatLong);
            pt2d = converter.GeoToPixels(pt2d);
            pt2 = clsUtility.Point2DToPOINT2(pt2d);
            pt2.style = ptLatLong.style;
        }
        catch (Exception e) {
            armyc2.c5isr.JavaTacticalRenderer.clsUtility.WriteFile("Error in clsUtility.PointLatLongToPixels");
        }
        return pt2;
    }

    protected static void FilterAXADPoints(TGLight tg, IPointConversion converter) {
        try {
            int lineType = tg.get_LineType();
            switch (lineType) {
                case 21700000: 
                case 21710000: 
                case 22521200: 
                case 22521300: 
                case 22521410: 
                case 22521420: 
                case 25152700: 
                case 25152900: 
                case 25342900: {
                    break;
                }
                default: {
                    return;
                }
            }
            int j = 0;
            ArrayList<Object> pts = new ArrayList<POINT2>();
            ArrayList<Object> ptsGeo = new ArrayList();
            POINT2 pt0 = tg.Pixels.get(0);
            POINT2 pt1 = tg.Pixels.get(1);
            Point2D.Double pt = new Point2D.Double(pt1.x, pt1.y);
            Point2D pt1Geo2d = converter.PixelsToGeo(pt);
            POINT2 pt1geo = new POINT2(pt1Geo2d.getX(), pt1Geo2d.getY());
            POINT2 ptj = null;
            POINT2 ptjGeo = null;
            POINT2 controlPt = tg.Pixels.get(tg.Pixels.size() - 1);
            POINT2 pt0Relative = lineutility.PointRelativeToLine(pt0, pt1, pt0, controlPt);
            double relativeDist = lineutility.CalcDistanceDouble(pt0Relative, controlPt);
            relativeDist += 5.0;
            double pt0pt1dist = lineutility.CalcDistanceDouble(pt0, pt1);
            boolean foundGoodPoint = false;
            if (relativeDist > pt0pt1dist) {
                pts.add(pt0);
                pt = new Point2D.Double(pt0.x, pt0.y);
                pt1Geo2d = converter.PixelsToGeo(pt);
                pt1geo = new POINT2(pt1Geo2d.getX(), pt1Geo2d.getY());
                ptsGeo.add(pt1geo);
                pt1 = lineutility.ExtendAlongLineDouble(pt0, pt1, relativeDist);
                pts.add(pt1);
                pt = new Point2D.Double(pt1.x, pt1.y);
                pt1Geo2d = converter.PixelsToGeo(pt);
                pt1geo = new POINT2(pt1Geo2d.getX(), pt1Geo2d.getY());
                ptsGeo.add(pt1geo);
            } else {
                foundGoodPoint = true;
                pts = tg.Pixels;
                ptsGeo = tg.LatLongs;
            }
            int n = tg.Pixels.size();
            if (!foundGoodPoint) {
                for (j = 2; j < n - 1; ++j) {
                    ptj = tg.Pixels.get(j);
                    ptjGeo = tg.LatLongs.get(j);
                    if (foundGoodPoint) {
                        pts.add(ptj);
                        ptsGeo.add(ptjGeo);
                        continue;
                    }
                    pt0pt1dist = lineutility.CalcDistanceDouble(pt0, ptj);
                    if (relativeDist > pt0pt1dist) continue;
                    pts.add(ptj);
                    ptsGeo.add(ptjGeo);
                    foundGoodPoint = true;
                }
                pts.add(controlPt);
                pt = new Point2D.Double(controlPt.x, controlPt.y);
                pt1Geo2d = converter.PixelsToGeo(pt);
                pt1geo = new POINT2(pt1Geo2d.getX(), pt1Geo2d.getY());
                ptsGeo.add(pt1geo);
            }
            POINT2 lastGoodPt = (POINT2)pts.get(1);
            POINT2 currentPt = null;
            POINT2 currentPtGeo = null;
            double dist = 0.0;
            tg.Pixels = new ArrayList();
            tg.LatLongs = new ArrayList();
            for (j = 0; j < 2; ++j) {
                tg.Pixels.add((POINT2)pts.get(j));
                tg.LatLongs.add((POINT2)ptsGeo.get(j));
            }
            n = pts.size();
            for (j = 2; j < n - 1; ++j) {
                currentPt = (POINT2)pts.get(j);
                currentPtGeo = (POINT2)ptsGeo.get(j);
                dist = lineutility.CalcDistanceDouble(currentPt, lastGoodPt);
                if (!(dist > 5.0)) continue;
                lastGoodPt = currentPt;
                tg.Pixels.add(currentPt);
                tg.LatLongs.add(currentPtGeo);
            }
            tg.Pixels.add((POINT2)pts.get(pts.size() - 1));
            tg.LatLongs.add((POINT2)ptsGeo.get(ptsGeo.size() - 1));
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "FilterAXADPoints", new RendererException("Failed inside FilterAXADPoints", exc));
        }
    }

    protected static void RemoveDuplicatePoints(TGLight tg) {
        try {
            switch (tg.get_LineType()) {
                case 22221000: 
                case 22222000: 
                case 22223000: 
                case 22224000: 
                case 22225000: 
                case 25170400: 
                case 25170600: {
                    break;
                }
                default: {
                    if (!armyc2.c5isr.JavaTacticalRenderer.clsUtility.isAutoshape(tg)) break;
                    return;
                }
            }
            switch (tg.get_LineType()) {
                case 21700000: 
                case 21710000: 
                case 22521200: 
                case 22521300: 
                case 22521410: 
                case 22521420: 
                case 25152700: 
                case 25152900: 
                case 25342900: {
                    return;
                }
                case 22121000: 
                case 25221000: 
                case 25222000: 
                case 25330500: {
                    String[] strs;
                    String strH = tg.get_H();
                    if (strH == null || strH.isEmpty() || (strs = strH.split(",")).length <= 1) break;
                    return;
                }
            }
            int linetype = tg.get_LineType();
            if (armyc2.c5isr.JavaTacticalRenderer.clsUtility.IsChange1Area(linetype)) {
                return;
            }
            POINT2 ptCurrent = null;
            POINT2 ptLast = null;
            Boolean isClosedPolygon = armyc2.c5isr.JavaTacticalRenderer.clsUtility.isClosedPolygon(tg.get_LineType());
            int minSize = 2;
            if (isClosedPolygon.booleanValue()) {
                minSize = 3;
            }
            for (int j = 1; j < tg.Pixels.size(); ++j) {
                ptLast = new POINT2(tg.Pixels.get(j - 1));
                ptCurrent = new POINT2(tg.Pixels.get(j));
                if (!(Math.abs(ptCurrent.x - ptLast.x) < 0.5) || !(Math.abs(ptCurrent.y - ptLast.y) < 0.5) || tg.Pixels.size() <= minSize) continue;
                tg.Pixels.remove(j);
                tg.LatLongs.remove(j);
                j = 1;
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "RemoveDuplicatePoints", new RendererException("Failed inside RemoveDuplicatePoints", exc));
        }
    }

    protected static POINT2 PointPixelsToLatLong(POINT2 ptPixels, IPointConversion converter) {
        POINT2 pt2 = new POINT2();
        try {
            Point2D.Double pt = new Point2D.Double(ptPixels.x, ptPixels.y);
            Point2D pt2d = converter.PixelsToGeo(pt);
            pt2 = clsUtility.Point2DToPOINT2(pt2d);
            pt2.style = ptPixels.style;
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "PointPixelsToLatLong", new RendererException("Could not convert point to geo", exc));
        }
        return pt2;
    }

    protected static Rectangle2D getMBR(ArrayList<Point2D> clipBounds) {
        Rectangle2D.Double rect = null;
        try {
            double ymax;
            double xmax;
            int j = 0;
            Point2D pt = null;
            double xmin = xmax = clipBounds.get(0).getX();
            double ymin = ymax = clipBounds.get(0).getY();
            int n = clipBounds.size();
            for (j = 0; j < n; ++j) {
                pt = clipBounds.get(j);
                if (pt.getX() < xmin) {
                    xmin = pt.getX();
                }
                if (pt.getX() > xmax) {
                    xmax = pt.getX();
                }
                if (pt.getY() <= ymin) {
                    ymin = pt.getY();
                }
                if (!(pt.getY() > ymax)) continue;
                ymax = pt.getY();
            }
            rect = new Rectangle2D.Double(xmin, ymin, xmax - xmin, ymax - ymin);
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "AddBoundaryPointsForLines", new RendererException("Failed inside AddBoundaryPointsForLines", exc));
        }
        return rect;
    }

    static void GetMBR(ArrayList<Shape2> shapes, POINT2 ptUl, POINT2 ptUr, POINT2 ptLr, POINT2 ptLl) {
        try {
            POINT2 firstPoint = shapes.get(0).getPoints().get(0);
            ptUl.x = firstPoint.x;
            ptUl.y = firstPoint.y;
            ptUr.x = firstPoint.x;
            ptUr.y = firstPoint.y;
            ptLl.x = firstPoint.x;
            ptLl.y = firstPoint.y;
            ptLr.x = firstPoint.x;
            ptLr.y = firstPoint.y;
            for (Shape2 shape : shapes) {
                ArrayList<POINT2> points = shape.getPoints();
                for (int j = 0; j < points.size(); ++j) {
                    double x = points.get((int)j).x;
                    double y = points.get((int)j).y;
                    if (x < ptLl.x) {
                        ptLl.x = x;
                        ptUl.x = x;
                    }
                    if (x > ptLr.x) {
                        ptLr.x = x;
                        ptUr.x = x;
                    }
                    if (y > ptLl.y) {
                        ptLl.y = y;
                        ptLr.y = y;
                    }
                    if (!(y < ptUl.y)) continue;
                    ptUl.y = y;
                    ptUr.y = y;
                }
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "GetMBR", new RendererException("Failed inside GetMBR", exc));
        }
    }
}

