/*
 * Decompiled with CFR 0.152.
 */
package armyc2.c5isr.renderer.utilities;

import armyc2.c5isr.renderer.utilities.GeoPixelConversion3D;
import armyc2.c5isr.renderer.utilities.IPointConversion;
import java.awt.Point;
import java.awt.geom.Point2D;

public class PointConverter3D
implements IPointConversion {
    private double _controlLat = 0.0;
    private double _controlLong = 0.0;
    private double _scale = 0.0;
    private double _metersPerPixel = 0.0;

    public PointConverter3D(double controlLong, double controlLat, double scale) {
        this._controlLat = controlLat;
        this._controlLong = controlLong;
        this._scale = scale;
        this._metersPerPixel = GeoPixelConversion3D.metersPerPixel(scale);
    }

    public Point2D.Double PixelsToGeo(Point pixel) {
        Point2D.Double pt2dGeo = null;
        double y = GeoPixelConversion3D.y2lat(pixel.getY(), this._scale, this._controlLat, this._metersPerPixel);
        double x = GeoPixelConversion3D.x2long(pixel.getX(), this._scale, this._controlLong, y, this._metersPerPixel);
        pt2dGeo = new Point2D.Double(x, y);
        return pt2dGeo;
    }

    public Point GeoToPixels(Point2D.Double coord) {
        Point ptPixels = null;
        double y = GeoPixelConversion3D.lat2y(coord.getY(), this._scale, this._controlLat, this._metersPerPixel);
        double x = GeoPixelConversion3D.long2x(coord.getX(), this._scale, this._controlLong, coord.getY(), this._metersPerPixel);
        ptPixels = new Point();
        ptPixels.setLocation(x, y);
        return ptPixels;
    }

    @Override
    public Point2D PixelsToGeo(Point2D pixel) {
        Point2D.Double pt2dGeo = null;
        double y = GeoPixelConversion3D.y2lat(pixel.getY(), this._scale, this._controlLat, this._metersPerPixel);
        double x = GeoPixelConversion3D.x2long(pixel.getX(), this._scale, this._controlLong, y, this._metersPerPixel);
        pt2dGeo = new Point2D.Double(x, y);
        return pt2dGeo;
    }

    @Override
    public Point2D GeoToPixels(Point2D coord) {
        Point2D.Double pt2DPixels = null;
        double y = GeoPixelConversion3D.lat2y(coord.getY(), this._scale, this._controlLat, this._metersPerPixel);
        double x = GeoPixelConversion3D.long2x(coord.getX(), this._scale, this._controlLong, coord.getY(), this._metersPerPixel);
        pt2DPixels = new Point2D.Double(x, y);
        return pt2DPixels;
    }
}

