/*
 * Decompiled with CFR 0.152.
 */
package armyc2.c5isr.web.render.utilities;

import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Arrays;

public class Path {
    private ArrayList<Action> _actions = new ArrayList();
    private String _dashArray = null;
    private Rectangle2D _rectangle = new Rectangle2D.Double();

    public void setLineDash(float[] dashArray) {
        this._dashArray = Arrays.toString(dashArray).replace(",", "").replace("[", "").replace("]", "").trim();
    }

    public Rectangle2D getBounds() {
        return this._rectangle;
    }

    public void moveTo(double x, double y) {
        if (this._actions.size() == 0) {
            this._rectangle = new Rectangle2D.Double(x, y, 1.0, 1.0);
        }
        this._rectangle.add(x, y);
        this._actions.add(new Action(0, x, y));
    }

    public void lineTo(double x, double y) {
        if (this._actions.size() == 0) {
            this.moveTo(0.0, 0.0);
        }
        this._actions.add(new Action(1, x, y));
        this._rectangle.add(x, y);
    }

    public void dashedLineTo(double x, double y) {
        if (this._actions.size() == 0) {
            this.moveTo(0.0, 0.0);
        }
        this._actions.add(new Action(6, x, y));
        this._rectangle.add(x, y);
    }

    public String toSVGElement(String stroke, int strokeWidth, String fill, double strokeOpacity, double fillOpacity) {
        int size = this._actions.size();
        Action temp = null;
        String path = "";
        for (int i = 0; i < size; ++i) {
            temp = this._actions.get(i);
            if (temp.actionType == 1) {
                path = path + "L" + temp.x + " " + temp.y;
                continue;
            }
            if (temp.actionType == 0) {
                path = path + "M" + temp.x + " " + temp.y;
                continue;
            }
            if (temp.actionType != 6) continue;
            path = path + "L" + temp.x + " " + temp.y;
        }
        String line = "<path d=\"" + path + '\"';
        if (stroke != null && !stroke.isEmpty()) {
            line = line + " stroke=\"" + stroke + '\"';
            line = strokeWidth != 0 ? line + " stroke-width=\"" + strokeWidth + '\"' : line + " stroke-width=\"2\"";
            if (strokeOpacity != 1.0) {
                line = line + " stroke-opacity=\"" + strokeOpacity + '\"';
            }
            line = line + " stroke-linecap=\"round\"";
        }
        if (this._dashArray != null) {
            line = line + " stroke-dasharray=\"" + this._dashArray + '\"';
        }
        if (fill != null && !fill.isEmpty()) {
            if (fill.indexOf("url") == 0) {
                line = line + " fill=\"url(#fillPattern)\"";
            } else {
                line = line + " fill=\"" + fill + '\"';
                if (fillOpacity != 1.0) {
                    line = line + " fill-opacity=\"" + fillOpacity + '\"';
                }
            }
        } else {
            line = line + " fill=\"none\"";
        }
        line = line + " />";
        return line;
    }

    static class Action {
        int actionType;
        double x;
        double y;

        public Action(int actionType, double x, double y) {
            this.actionType = actionType;
            this.x = x;
            this.y = y;
        }
    }

    static class ActionTypes {
        public static final int ACTION_MOVE_TO = 0;
        public static final int ACTION_LINE_TO = 1;
        public static final int ACTION_DASHED_LINE_TO = 6;

        ActionTypes() {
        }
    }
}

