/*
 * Decompiled with CFR 0.152.
 */
package armyc2.c5isr.web.render.utilities;

import armyc2.c5isr.renderer.utilities.RectUtilities;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;

public class SVGTextInfo {
    protected String _text;
    protected String _font;
    protected String _fontName;
    protected int _fontSize = 0;
    protected String _fontStyle;
    protected Point2D _location;
    protected Rectangle2D _bounds;
    private String justification = "start";
    private double angle = 0.0;
    private String alignmentBaseline = "middle";

    public SVGTextInfo(String text, Point2D position, Font font, String justification, double angle) {
        BufferedImage bi = new BufferedImage(8, 8, 2);
        Graphics2D g2d = bi.createGraphics();
        FontRenderContext frc = g2d.getFontRenderContext();
        this._font = font.toString();
        this._fontName = font.getName();
        this._fontSize = font.getSize();
        this._fontStyle = font.isBold() ? (font.isItalic() ? "bolditalic" : "bold") : (font.isItalic() ? "italic" : "plain");
        this._text = text;
        this._location = new Point2D.Double(position.getX(), position.getY());
        this.justification = justification;
        this.angle = angle;
        this._bounds = font.getStringBounds(text, frc);
        if (this.justification.equals("middle")) {
            this._bounds.setRect(position.getX() - this._bounds.getWidth() / 2.0, position.getY() - this._bounds.getHeight() / 2.0, this._bounds.getWidth(), this._bounds.getHeight());
        } else if (this.justification.equals("end")) {
            this._bounds.setRect(position.getX() - this._bounds.getWidth(), position.getY() - this._bounds.getHeight() / 2.0, this._bounds.getWidth(), this._bounds.getHeight());
        } else {
            this._bounds.setRect(position.getX(), position.getY() - this._bounds.getHeight() / 2.0, this._bounds.getWidth(), this._bounds.getHeight());
        }
        RectUtilities.grow(this._bounds, 1);
        if (this.angle != 0.0) {
            this._bounds = SVGTextInfo.getRotatedRectangleBounds(this._bounds, position, this.angle, this.justification);
        }
    }

    public Rectangle2D getTextBounds() {
        return this._bounds;
    }

    public String toSVGElement(String textColor, String outlineColor, double outlineWidth) {
        String fill = textColor;
        String stroke = outlineColor;
        double strokeWidth = outlineWidth;
        double x = this._location.getX();
        double y = this._location.getY();
        String se = "<text";
        se = this.angle == 0.0 ? se + " x=\"" + x + "\" y=\"" + y + "\"" : se + " transform=\"translate(" + x + ',' + y + ") rotate(" + this.angle + ")\"";
        se = se + " font-family=\"" + this._fontName + '\"';
        se = se + " font-size=\"" + this._fontSize + "px\"";
        se = se + " font-weight=\"" + this._fontStyle + '\"';
        se = se + " alignment-baseline=\"" + this.alignmentBaseline + "\"";
        se = se + " stroke-miterlimit=\"3\"";
        se = se + " text-anchor=\"" + this.justification + '\"';
        String seStroke = null;
        String seFill = null;
        String text = this._text;
        if (stroke != null && strokeWidth > 0.0) {
            seStroke = se + " stroke=\"" + stroke + '\"';
            if (strokeWidth != 0.0) {
                seStroke = seStroke + " stroke-width=\"" + (strokeWidth + 2.0) + '\"';
            }
            seStroke = seStroke + " fill=\"none\"";
            seStroke = seStroke + ">";
            seStroke = seStroke + text;
            seStroke = seStroke + "</text>";
        }
        if (fill != null) {
            seFill = se + " fill=\"" + fill + '\"';
            seFill = seFill + ">";
            seFill = seFill + text;
            seFill = seFill + "</text>";
        }
        se = stroke != null && !stroke.isEmpty() && fill != null && !fill.isEmpty() ? seStroke + seFill : (fill != null && !fill.isEmpty() ? seFill : "");
        return se;
    }

    public static Rectangle2D getRotatedRectangleBounds(Rectangle2D rectangle, Point2D pivotPt, double angle, String justification) {
        double textWidth = rectangle.getWidth();
        if (justification.equals("start")) {
            rectangle.setRect(rectangle.getX() - textWidth / 2.0, rectangle.getY(), rectangle.getWidth(), rectangle.getHeight());
        } else if (justification.equals("end")) {
            rectangle.setRect(rectangle.getX() + textWidth / 2.0, rectangle.getY(), rectangle.getWidth(), rectangle.getHeight());
        }
        Point2D.Double ptTL = new Point2D.Double(rectangle.getMinX(), rectangle.getMinY());
        Point2D.Double ptTR = new Point2D.Double(rectangle.getMaxX(), rectangle.getMinY());
        Point2D.Double ptBL = new Point2D.Double(rectangle.getMinX(), rectangle.getMaxY());
        Point2D.Double ptBR = new Point2D.Double(rectangle.getMaxX(), rectangle.getMaxY());
        SVGTextInfo.rotatePoint(ptTL, pivotPt, angle);
        SVGTextInfo.rotatePoint(ptTR, pivotPt, angle);
        SVGTextInfo.rotatePoint(ptBL, pivotPt, angle);
        SVGTextInfo.rotatePoint(ptBR, pivotPt, angle);
        rectangle = new Rectangle2D.Double(((Point2D)ptTL).getX(), ((Point2D)ptTL).getY(), 0.0, 0.0);
        rectangle.add(((Point2D)ptTR).getX(), ((Point2D)ptTR).getY());
        rectangle.add(((Point2D)ptBL).getX(), ((Point2D)ptBL).getY());
        rectangle.add(((Point2D)ptBR).getX(), ((Point2D)ptBR).getY());
        if (justification == "start") {
            double s = Math.sin(angle * 2.0 * Math.PI / 360.0);
            double c = Math.cos(angle * 2.0 * Math.PI / 360.0);
            rectangle.setRect(rectangle.getX() + textWidth / 2.0 * c, rectangle.getY() + textWidth / 2.0 * s, rectangle.getWidth(), rectangle.getHeight());
        } else if (justification == "end") {
            double s = Math.sin(angle * 2.0 * Math.PI / 360.0);
            double c = Math.cos(angle * 2.0 * Math.PI / 360.0);
            rectangle.setRect(rectangle.getX() - textWidth / 2.0 * c, rectangle.getY() - textWidth / 2.0 * s, rectangle.getWidth(), rectangle.getHeight());
        }
        return rectangle;
    }

    static void rotatePoint(Point2D pt, Point2D pivotPt, double angle) {
        double s = Math.sin(-angle * 2.0 * Math.PI / 360.0);
        double c = Math.cos(-angle * 2.0 * Math.PI / 360.0);
        pt.setLocation(pt.getX() - pivotPt.getX(), pt.getY() - pivotPt.getY());
        double xnew = pt.getX() * c - pt.getY() * s;
        double ynew = pt.getX() * s + pt.getY() * c;
        pt.setLocation(xnew + pivotPt.getX(), ynew + pivotPt.getY());
    }
}

