/*
 * Decompiled with CFR 0.152.
 */
package io.github.mitsumi.solutions.ciphers;

import io.github.mitsumi.solutions.ciphers.decrypters.AESDecrypter;
import io.github.mitsumi.solutions.ciphers.decrypters.RSAPrivateKeyDecrypter;
import io.github.mitsumi.solutions.ciphers.encrypters.AESEncrypter;
import io.github.mitsumi.solutions.ciphers.encrypters.RSAPublicKeyEncrypter;
import java.util.Base64;

public final class AESWithRSACipher {
    private final AESEncrypter aesEncrypter = AESEncrypter.build();
    private final AESDecrypter aesDecrypter = AESDecrypter.build();
    private final RSAPublicKeyEncrypter publicKeyEncrypter = RSAPublicKeyEncrypter.build();
    private final RSAPrivateKeyDecrypter privateKeyDecrypter = RSAPrivateKeyDecrypter.build();

    public static AESWithRSACipher build() {
        return new AESWithRSACipher();
    }

    private AESWithRSACipher() {
    }

    public AESWithRSAEncryptedResult encrypt(String publicKey, byte[] plainText) {
        AESEncrypter.AESEncryptedResult aesEncrypted = this.aesEncrypter.encrypt(plainText);
        byte[] encryptedKey = this.publicKeyEncrypter.encrypt(publicKey, aesEncrypted.key());
        return new AESWithRSAEncryptedResult(Base64.getEncoder().encodeToString(encryptedKey), Base64.getEncoder().encodeToString(aesEncrypted.iv()), Base64.getEncoder().encodeToString(aesEncrypted.encrypted()));
    }

    public byte[] decrypt(String privateKey, byte[] encryptedKey, byte[] iv, byte[] encrypted) {
        byte[] rsaDecryptedKey = this.privateKeyDecrypter.decrypt(privateKey, encryptedKey);
        return this.aesDecrypter.decrypt(rsaDecryptedKey, iv, encrypted);
    }

    public record AESWithRSAEncryptedResult(String encryptedKey, String iv, String encrypted) {
    }
}

