/*
 * Decompiled with CFR 0.152.
 */
package io.github.mitsumi.solutions.ciphers.decrypters;

import io.github.mitsumi.solutions.ciphers.loaders.RSAKeyLoader;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;

public final class RSAPrivateKeyDecrypter {
    private final RSAKeyLoader rsaKeyLoader = RSAKeyLoader.build();

    public static RSAPrivateKeyDecrypter build() {
        return new RSAPrivateKeyDecrypter();
    }

    private RSAPrivateKeyDecrypter() {
    }

    public byte[] decrypt(String privateKey, byte[] encrypted) {
        return this.decrypt(this.rsaKeyLoader.loadPrivate(privateKey), encrypted);
    }

    public byte[] decrypt(PrivateKey privateKey, byte[] encrypted) {
        try {
            Cipher cipher = Cipher.getInstance("RSA");
            cipher.init(2, privateKey);
            return cipher.doFinal(encrypted);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

