/*
 * Decompiled with CFR 0.152.
 */
package io.github.mitsumi.solutions.ciphers.encrypters;

import io.github.mitsumi.solutions.ciphers.generators.KeyGenerator;
import java.security.GeneralSecurityException;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public final class AESEncrypter {
    private static final int KEY_LENGTH = 32;
    private static final int IV_LENGTH = 16;
    private final KeyGenerator keyGenerator = KeyGenerator.build();

    public static AESEncrypter build() {
        return new AESEncrypter();
    }

    private AESEncrypter() {
    }

    public AESEncryptedResult encrypt(byte[] plainText) {
        try {
            byte[] key = this.keyGenerator.generate(32);
            byte[] iv = this.keyGenerator.generate(16);
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            cipher.init(1, (Key)new SecretKeySpec(key, "AES"), new IvParameterSpec(iv));
            return new AESEncryptedResult(key, iv, cipher.doFinal(plainText));
        }
        catch (GeneralSecurityException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public record AESEncryptedResult(byte[] key, byte[] iv, byte[] encrypted) {
    }
}

