/*
 * Decompiled with CFR 0.152.
 */
package io.github.mitsumi.solutions.ciphers.encrypters;

import io.github.mitsumi.solutions.ciphers.loaders.RSAKeyLoader;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.interfaces.RSAPublicKey;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;

public final class RSAPublicKeyEncrypter {
    private final RSAKeyLoader rsaKeyLoader = RSAKeyLoader.build();

    public static RSAPublicKeyEncrypter build() {
        return new RSAPublicKeyEncrypter();
    }

    private RSAPublicKeyEncrypter() {
    }

    public byte[] encrypt(String publicKey, byte[] plainText) {
        return this.encrypt(this.rsaKeyLoader.loadPublic(publicKey), plainText);
    }

    public byte[] encrypt(RSAPublicKey publicKey, byte[] plainText) {
        try {
            Cipher cipher = Cipher.getInstance("RSA");
            cipher.init(1, publicKey);
            return cipher.doFinal(plainText);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

