/*
 * Decompiled with CFR 0.152.
 */
package io.github.mitsumi.solutions.ciphers.loaders;

import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import lombok.Generated;

public class RSAKeyLoader {
    private static final String BEGIN_PUBLIC = "-----BEGIN PUBLIC KEY-----";
    private static final String END_PUBLIC = "-----END PUBLIC KEY-----";
    private static final String BEGIN_PRIVATE = "-----BEGIN PRIVATE KEY-----";
    private static final String END_PRIVATE = "-----END PRIVATE KEY-----";

    public RSAPublicKey loadPublic(String publicKey) {
        try {
            X509EncodedKeySpec spec = new X509EncodedKeySpec(this.keyBytes(publicKey, BEGIN_PUBLIC, END_PUBLIC));
            KeyFactory factory = KeyFactory.getInstance("RSA");
            return (RSAPublicKey)factory.generatePublic(spec);
        }
        catch (GeneralSecurityException e) {
            throw new IllegalArgumentException("Failed to load key.", e);
        }
    }

    public PrivateKey loadPrivate(String privateKey) {
        try {
            PKCS8EncodedKeySpec spec = new PKCS8EncodedKeySpec(this.keyBytes(privateKey, BEGIN_PRIVATE, END_PRIVATE));
            KeyFactory factory = KeyFactory.getInstance("RSA");
            return factory.generatePrivate(spec);
        }
        catch (GeneralSecurityException e) {
            throw new IllegalArgumentException("Failed to load key.", e);
        }
    }

    private byte[] keyBytes(String rsaKey, String replaceBegin, String replaceEnd) {
        String key = rsaKey.replace(replaceBegin, "").replace(replaceEnd, "").replaceAll("\r", "").replaceAll("\n", "");
        return Base64.getDecoder().decode(key);
    }

    @Generated
    private RSAKeyLoader() {
    }

    @Generated
    public static RSAKeyLoader build() {
        return new RSAKeyLoader();
    }
}

