/*
 * Decompiled with CFR 0.152.
 */
package io.github.mitsumi.solutions.shared.functions;

import io.github.mitsumi.solutions.shared.functions.HexaFunction;
import io.github.mitsumi.solutions.shared.functions.PentaConsumer;
import io.github.mitsumi.solutions.shared.functions.PentaFunction;
import io.github.mitsumi.solutions.shared.functions.QuadConsumer;
import io.github.mitsumi.solutions.shared.functions.QuadFunction;
import io.github.mitsumi.solutions.shared.functions.TriConsumer;
import io.github.mitsumi.solutions.shared.functions.TriFunction;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import lombok.Generated;

public class Functions {
    public <T> void runIf(Supplier<Boolean> supplier, Runnable runnable) {
        if (supplier.get().booleanValue()) {
            runnable.run();
        }
    }

    public <T> void runIf(Supplier<T> supplier, Predicate<T> predicate, Runnable runnable) {
        if (predicate.test(supplier.get())) {
            runnable.run();
        }
    }

    public <T> void runElse(Supplier<T> supplier, Predicate<T> predicate, Runnable runnable, Runnable other) {
        if (predicate.test(supplier.get())) {
            runnable.run();
        } else {
            other.run();
        }
    }

    public <T> void runElse(Supplier<Boolean> supplier, Runnable runnable, Runnable other) {
        if (supplier.get().booleanValue()) {
            runnable.run();
        } else {
            other.run();
        }
    }

    public <T extends RuntimeException> void throwsIf(Supplier<Boolean> conditionSupplier, Supplier<T> exceptionSupplier) {
        if (conditionSupplier.get().booleanValue()) {
            throw (RuntimeException)exceptionSupplier.get();
        }
    }

    public <T, U extends RuntimeException> void throwsIf(Supplier<T> supplier, Predicate<T> predicate, Supplier<U> exceptionSupplier) {
        if (predicate.test(supplier.get())) {
            throw (RuntimeException)exceptionSupplier.get();
        }
    }

    public <T, R> R apply(Supplier<T> supplier, Function<T, R> function) {
        return function.apply(supplier.get());
    }

    public <T, U, R> R apply(Supplier<T> supplierT, Supplier<U> supplierU, BiFunction<T, U, R> function) {
        return function.apply(supplierT.get(), supplierU.get());
    }

    public <T, U, V, R> R apply(Supplier<T> supplierT, Supplier<U> supplierU, Supplier<V> supplierV, TriFunction<T, U, V, R> function) {
        return function.apply(supplierT.get(), supplierU.get(), supplierV.get());
    }

    public <T, U, V, W, R> R apply(Supplier<T> supplierT, Supplier<U> supplierU, Supplier<V> supplierV, Supplier<W> supplierW, QuadFunction<T, U, V, W, R> function) {
        return function.apply(supplierT.get(), supplierU.get(), supplierV.get(), supplierW.get());
    }

    public <T, U, V, W, X, R> R apply(Supplier<T> supplierT, Supplier<U> supplierU, Supplier<V> supplierV, Supplier<W> supplierW, Supplier<X> supplierX, PentaFunction<T, U, V, W, X, R> function) {
        return function.apply(supplierT.get(), supplierU.get(), supplierV.get(), supplierW.get(), supplierX.get());
    }

    public <T, U, V, W, X, Y, R> R apply(Supplier<T> supplierT, Supplier<U> supplierU, Supplier<V> supplierV, Supplier<W> supplierW, Supplier<X> supplierX, Supplier<Y> supplierY, HexaFunction<T, U, V, W, X, Y, R> function) {
        return function.apply(supplierT.get(), supplierU.get(), supplierV.get(), supplierW.get(), supplierX.get(), supplierY.get());
    }

    public <T, R> R applyOrElse(boolean condition, Supplier<T> supplierT, Function<T, R> function, Supplier<R> supplierR) {
        return condition ? function.apply(supplierT.get()) : supplierR.get();
    }

    public <T, U, R> R applyOrElse(boolean condition, Supplier<T> supplierT, Supplier<U> supplierU, BiFunction<T, U, R> function, Supplier<R> supplierR) {
        return condition ? function.apply(supplierT.get(), supplierU.get()) : supplierR.get();
    }

    public <T, U, V, R> R applyOrElse(boolean condition, Supplier<T> supplierT, Supplier<U> supplierU, Supplier<V> supplierV, TriFunction<T, U, V, R> function, Supplier<R> supplierR) {
        return condition ? function.apply(supplierT.get(), supplierU.get(), supplierV.get()) : supplierR.get();
    }

    public <T, U, V, W, R> R applyOrElse(boolean condition, Supplier<T> supplierT, Supplier<U> supplierU, Supplier<V> supplierV, Supplier<W> supplierW, QuadFunction<T, U, V, W, R> function, Supplier<R> supplierR) {
        return condition ? function.apply(supplierT.get(), supplierU.get(), supplierV.get(), supplierW.get()) : supplierR.get();
    }

    public <T, U, V, W, X, R> R applyOrElse(boolean condition, Supplier<T> supplierT, Supplier<U> supplierU, Supplier<V> supplierV, Supplier<W> supplierW, Supplier<X> supplierX, PentaFunction<T, U, V, W, X, R> function, Supplier<R> supplierR) {
        return condition ? function.apply(supplierT.get(), supplierU.get(), supplierV.get(), supplierW.get(), supplierX.get()) : supplierR.get();
    }

    public <T, R> R applyOrElse(boolean condition, Supplier<T> supplierT, Function<T, R> ifTrue, Function<T, R> other) {
        return condition ? ifTrue.apply(supplierT.get()) : other.apply(supplierT.get());
    }

    public <T> void acceptIf(boolean condition, Supplier<T> supplierT, Consumer<T> consumer) {
        if (condition) {
            consumer.accept(supplierT.get());
        }
    }

    public <T, V> void acceptIf(boolean condition, Supplier<T> firstSupplier, Supplier<V> secondSupplier, BiConsumer<T, V> consumer) {
        if (condition) {
            consumer.accept(firstSupplier.get(), secondSupplier.get());
        }
    }

    public <T> void acceptOrElse(boolean condition, Supplier<T> supplierT, Consumer<T> consumer, Consumer<T> other) {
        if (condition) {
            consumer.accept(supplierT.get());
        } else {
            other.accept(supplierT.get());
        }
    }

    public <T> T getOrElse(boolean condition, Supplier<T> supplier, Supplier<T> other) {
        return condition ? supplier.get() : other.get();
    }

    public <T> T accept(Supplier<T> supplierT, Consumer<T> consumer) {
        T value = supplierT.get();
        consumer.accept(value);
        return value;
    }

    public <T, V> void accept(Supplier<T> firstSupplier, Supplier<V> secondSupplier, BiConsumer<T, V> consumer) {
        consumer.accept(firstSupplier.get(), secondSupplier.get());
    }

    public <T, U, V> void accept(Supplier<T> firstSupplier, Supplier<U> secondSupplier, Supplier<V> thirdSupplier, TriConsumer<T, U, V> consumer) {
        consumer.accept(firstSupplier.get(), secondSupplier.get(), thirdSupplier.get());
    }

    public <T, U, V, W> void accept(Supplier<T> firstSupplier, Supplier<U> secondSupplier, Supplier<V> thirdSupplier, Supplier<W> fourthSupplier, QuadConsumer<T, U, V, W> consumer) {
        consumer.accept(firstSupplier.get(), secondSupplier.get(), thirdSupplier.get(), fourthSupplier.get());
    }

    public <T, U, V, W, X> void accept(Supplier<T> firstSupplier, Supplier<U> secondSupplier, Supplier<V> thirdSupplier, Supplier<W> fourthSupplier, Supplier<X> fifthSupplier, PentaConsumer<T, U, V, W, X> consumer) {
        consumer.accept(firstSupplier.get(), secondSupplier.get(), thirdSupplier.get(), fourthSupplier.get(), fifthSupplier.get());
    }

    @SafeVarargs
    public final <T> T accept(Supplier<T> supplierT, Consumer<T> ... consumers) {
        return (T)this.accept(supplierT, t -> List.of(consumers).forEach(consumer -> consumer.accept(t)));
    }

    @SafeVarargs
    public final <T> T acceptNonNull(Supplier<T> supplierT, Consumer<T> ... consumers) {
        return (T)this.accept(supplierT, t -> Optional.ofNullable(t).ifPresent(val -> List.of(consumers).forEach(consumer -> consumer.accept(t))));
    }

    @Generated
    private Functions() {
    }

    @Generated
    public static Functions build() {
        return new Functions();
    }
}

