/*
 * Decompiled with CFR 0.152.
 */
package io.github.mitsumi.solutions.shared.utils;

import java.time.DateTimeException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.Objects;
import lombok.Generated;

public final class DateTimeUtils {
    public static final ZoneId ZONE_ID_UTC = ZoneId.of("UTC");
    public static final ZoneId ZONE_ID_JST = ZoneId.of("Asia/Tokyo");

    public static LocalDateTime getUtcTime() {
        return LocalDateTime.now(ZONE_ID_UTC);
    }

    public static LocalDateTime getJstTime() {
        return LocalDateTime.now(ZONE_ID_JST);
    }

    public static ZonedDateTime getUtcZonedDateTime() {
        return DateTimeUtils.getUtcTime().atZone(ZONE_ID_UTC);
    }

    public static OffsetDateTime getOffsetDateTime() {
        return OffsetDateTime.now();
    }

    public static long getUtcEpochSecond() {
        return DateTimeUtils.getUtcZonedDateTime().toEpochSecond();
    }

    public static boolean isSame(LocalDateTime source, LocalDateTime target) {
        return source.equals(target);
    }

    public static boolean isSame(OffsetDateTime source, LocalDateTime target) {
        return DateTimeUtils.isSame(source.toLocalDateTime(), target);
    }

    public static boolean isSameMs(LocalDateTime source, LocalDateTime target) {
        ChronoUnit compareUnit = ChronoUnit.MILLIS;
        return source.truncatedTo(compareUnit).equals(target.truncatedTo(compareUnit));
    }

    public static boolean isBetween(LocalDateTime target, LocalDateTime fromDateTime, LocalDateTime endDateTime) {
        return !target.isAfter(fromDateTime) && !target.isBefore(endDateTime);
    }

    public static boolean isBetween(OffsetDateTime target, LocalDateTime fromDateTime, LocalDateTime endDateTime) {
        return DateTimeUtils.isBetween(target.toLocalDateTime(), fromDateTime, endDateTime);
    }

    public static OffsetDateTime getOffsetDateTimeUtc(int year, int month, int dayOfMonth, int hour, int minute, int second) {
        return OffsetDateTime.of(year, month, dayOfMonth, hour, minute, second, 0, ZoneOffset.systemDefault().getRules().getOffset(LocalDateTime.now())).withOffsetSameInstant(ZoneOffset.UTC);
    }

    public static OffsetDateTime getUtcOffsetDateTimeFromJst(int year, int month, int dayOfMonth, int hour, int minute, int second) {
        LocalDateTime jstLocalDateTime = LocalDateTime.of(year, month, dayOfMonth, hour, minute, second);
        ZonedDateTime jstZonedDateTime = jstLocalDateTime.atZone(ZONE_ID_JST);
        ZonedDateTime utcZonedDateTime = jstZonedDateTime.withZoneSameInstant(ZONE_ID_UTC);
        return utcZonedDateTime.toOffsetDateTime();
    }

    public static OffsetDateTime toOffsetDateTime(LocalDateTime localDateTime) {
        return DateTimeUtils.toOffsetDateTime(localDateTime, ZoneOffset.UTC);
    }

    public static OffsetDateTime toOffsetDateTime(LocalDateTime localDateTime, ZoneOffset zoneOffset) {
        if (Objects.isNull(localDateTime)) {
            throw new IllegalArgumentException("specified localDateTime cannot be null.");
        }
        return OffsetDateTime.of(localDateTime, zoneOffset);
    }

    public static OffsetDateTime toJSTOffsetDateTime(LocalDateTime jstLocalDateTime) {
        ZonedDateTime zonedDateTime = jstLocalDateTime.atZone(ZONE_ID_JST);
        return OffsetDateTime.ofInstant(zonedDateTime.toInstant(), ZONE_ID_JST);
    }

    public static OffsetDateTime toJSTOffsetDateTime(OffsetDateTime utcOffsetDateTime) {
        ZonedDateTime zonedDateTime = utcOffsetDateTime.toZonedDateTime();
        ZonedDateTime jstZonedDateTime = zonedDateTime.withZoneSameInstant(ZONE_ID_JST);
        return OffsetDateTime.ofInstant(jstZonedDateTime.toInstant(), ZONE_ID_JST);
    }

    public static OffsetDateTime toJSTOffsetDateTimeWithUtc(LocalDateTime utcLocalDateTime) {
        ZonedDateTime utcZonedDateTime = utcLocalDateTime.atZone(ZONE_ID_UTC);
        ZonedDateTime jstZonedDateTime = utcZonedDateTime.withZoneSameInstant(ZONE_ID_JST);
        return jstZonedDateTime.toOffsetDateTime();
    }

    public static LocalDateTime toUtcLocalDateTime(LocalDateTime jstLocalDateTime) {
        ZonedDateTime jstZonedDateTime = jstLocalDateTime.atZone(ZONE_ID_JST);
        ZonedDateTime utcZonedDateTime = jstZonedDateTime.withZoneSameInstant(ZONE_ID_UTC);
        return utcZonedDateTime.toLocalDateTime();
    }

    public static Date getDateSystemDefaultZone(int year, int month, int dayOfMonth, int hour, int minute, int second) {
        return Date.from(ZonedDateTime.of(year, month, dayOfMonth, hour, minute, second, 0, ZoneId.systemDefault()).toInstant());
    }

    public static OffsetDateTime toOffsetDateTimeUtc(Date date) {
        return date.toInstant().atOffset(ZoneOffset.UTC);
    }

    public static Date toDate(LocalDateTime localDateTime) {
        if (Objects.isNull(localDateTime)) {
            throw new IllegalArgumentException("specified localDateTime cannot be null.");
        }
        ZonedDateTime zonedDateTime = ZonedDateTime.of(localDateTime, ZoneOffset.UTC);
        return Date.from(zonedDateTime.toInstant());
    }

    public static Date toDate(LocalDate localDate) {
        if (Objects.isNull(localDate)) {
            throw new IllegalArgumentException("specified localDate cannot be null.");
        }
        return Date.from(localDate.atStartOfDay(ZoneId.systemDefault()).toInstant());
    }

    public static Date toDate(OffsetDateTime offsetDateTime) {
        if (Objects.isNull(offsetDateTime)) {
            throw new IllegalArgumentException("specified offsetDateTime cannot be null.");
        }
        return Date.from(offsetDateTime.toInstant());
    }

    public static LocalDateTime toLocalDateTime(String dateTimeString) {
        return LocalDateTime.parse(dateTimeString, DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
    }

    public static LocalDateTime toUtcLocalDateTime(String source) {
        OffsetDateTime jstOffsetDateTime = OffsetDateTime.parse(source);
        return DateTimeUtils.toUtcLocalDateTime(jstOffsetDateTime);
    }

    public static LocalDateTime toUtcLocalDateTime(OffsetDateTime jstOffsetDateTime) {
        return ZonedDateTime.ofInstant(jstOffsetDateTime.toInstant(), ZONE_ID_UTC).toLocalDateTime();
    }

    public static LocalDateTime toSystemZoneLocalDateTime(OffsetDateTime offsetDateTime) {
        if (Objects.isNull(offsetDateTime)) {
            throw new IllegalArgumentException("OffsetDateTime cannot be null");
        }
        return offsetDateTime.atZoneSameInstant(ZoneId.systemDefault()).toLocalDateTime();
    }

    public static boolean isBefore(Date time1, LocalDateTime time2) {
        return time1.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime().isBefore(time2);
    }

    public static boolean isValidDate(int year, int month, int dayOfMonth) {
        try {
            LocalDate date = LocalDate.of(year, month, dayOfMonth);
            return year == date.getYear() && month == date.getMonthValue() && dayOfMonth == date.getDayOfMonth();
        }
        catch (DateTimeException e) {
            return false;
        }
    }

    @Generated
    private DateTimeUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

