/*
 * Decompiled with CFR 0.152.
 */
package io.github.mitsumi.solutions.shared.utils;

import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public final class StringCaseUtils {
    public static String snakeToCamel(String snake) {
        return StringCaseUtils.snakeToCamel(snake, true);
    }

    public static String snakeToCamel(String snake, boolean initialLetterLowerCase) {
        int i;
        if (StringUtils.isEmpty((CharSequence)snake)) {
            return snake;
        }
        StringBuilder camel = new StringBuilder(snake.length() + snake.length());
        if (initialLetterLowerCase) {
            camel.append(Character.toLowerCase(snake.charAt(0)));
        }
        int n = i = initialLetterLowerCase ? 1 : 0;
        while (i < snake.length()) {
            char charAt = snake.charAt(i);
            if (charAt == '_') {
                camel.append(i + 1 < snake.length() ? Character.valueOf(Character.toUpperCase(snake.charAt(++i))) : "");
            } else {
                camel.append(camel.isEmpty() ? Character.toUpperCase(charAt) : Character.toLowerCase(charAt));
            }
            ++i;
        }
        return camel.toString();
    }

    public static String camelToSnake(String camel) {
        if (StringUtils.isEmpty((CharSequence)camel)) {
            return camel;
        }
        StringBuilder snake = new StringBuilder();
        snake.append(Character.toLowerCase(camel.charAt(0)));
        for (int i = 1; i < camel.length(); ++i) {
            char currentChar = camel.charAt(i);
            if (Character.isUpperCase(currentChar)) {
                snake.append('_').append(Character.toLowerCase(currentChar));
                continue;
            }
            snake.append(currentChar);
        }
        return snake.toString();
    }

    @Generated
    private StringCaseUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

