package com.monmonkeygroup.openapi.quote;

public class Constants {
    public interface MarketState {
        int NONE = 0;
        int AUCTION = 1;
        int WAITING_OPEN = 2;
        int OPEN = 3;
        int REST = 4;
        int CLOSED = 5;
        int PRE_MARKET_BEGIN = 6;
        int HK_CAS = 7;
        int AFTER_HOURS_BEGIN = 8;
    }

    public interface SecurityType {
        int NONE = 0;
        int BOND = 1;
        int EQTY = 2;
        int ETF = 3;
        int WARRANT = 4;
        int INDEX = 5;
        int PLATE = 6;
        int CRYPTO = 7;
    }

    public interface SecurityStatus {
        int NONE = 0;
        int NORMAL = 1;
        int LISTING = 2;
        int PURCHASING = 3;
        int SUSPENDED = 4;
        int TO_BE_OPEN = 5;
        int CALLED = 6;
        int EXPIRED = 7;
        int DELISTED = 8;
    }

    public interface TradeType {
        int NONE = 0;
    }

    public interface TradeDirection {
        int NONE = 0;
        int BUY = 1;
        int SELL = 2;
        int NEUTRAL = 3;
    }

    public interface WarrantType {
        String BUY = "Buy";
        String SELL = "Sell";
        String BULL = "Bull";
        String BEAR = "Bear";
        String INLINE = "IL";
    }

    public interface KbarPeriod {
        int M1 = 1;
        int M5 = 2;
        int M15 = 3;
        int M30 = 4;
        int H1 = 5;
        int DAY = 6;
        int WEEK = 7;
        int MONTH = 8;
        int YEAR = 9;
    }

    public interface RehabType {
        int NONE = 0;
        int FORWARD = 1;
    }

    public interface SectionType {
        int OPEN = 0;
        int ALL = 1;
        int PRE = 2;
        int POST = 3;
    }
}
