/*
 * Decompiled with CFR 0.152.
 */
package nlScript.mic;

public class Interpolator {
    private final Getter getter;
    private final Setter setter;
    private double vFrom;
    private final double vTo;
    private final int nCycles;

    public Interpolator(Getter getter, Setter setter, double vTo, int nCycles) {
        this.getter = getter;
        this.setter = setter;
        this.vTo = vTo;
        this.nCycles = nCycles;
    }

    private void initialize() {
        this.vFrom = this.getter.get();
    }

    public void interpolate(int cycle) {
        if (cycle == this.nCycles - 1) {
            this.setter.set(cycle, this.vTo);
            return;
        }
        if (cycle == 0) {
            this.initialize();
        }
        double interpolated = this.vFrom + (double)cycle * (this.vTo - this.vFrom) / (double)(this.nCycles - 1);
        this.setter.set(cycle, interpolated);
    }

    public static void main(String[] args) {
        int nCycles = 10;
        Interpolator interpolator = new Interpolator(() -> 5.0, (c, v) -> System.out.println(c + ": " + v), 15.0, nCycles);
        for (int i = 0; i < nCycles; ++i) {
            interpolator.interpolate(i);
        }
    }

    public static interface Getter {
        public double get();
    }

    public static interface Setter {
        public void set(int var1, double var2);
    }
}

