/*
 * Decompiled with CFR 0.152.
 */
package nlScript.mic;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Microscope {
    private final ArrayList<AcquisiitonListener> listeners = new ArrayList();
    public static final String ALL_CHANNELS = "ALL_CHANNELS";
    public static final String ALL_POSITIONS = "ALL_POSITIONS";
    private final List<Channel> channels = new ArrayList<Channel>();
    private final List<Position> positions = new ArrayList<Position>();
    private Lens lens = Lens.FIVE;
    private MagnificationChanger magnificationChanger = MagnificationChanger.ONE_ZERO;
    private Binning binning = Binning.ONE;
    private final Incubation incubation = new Incubation();

    public void addAcquisitionListener(AcquisiitonListener l) {
        this.listeners.add(l);
    }

    public void removeAcquisitionListener(AcquisiitonListener l) {
        this.listeners.remove(l);
    }

    private void fireAcquire(Position p, Channel c) {
        for (AcquisiitonListener l : this.listeners) {
            l.acquire(p, c);
        }
    }

    public void reset() {
        this.channels.clear();
        this.positions.clear();
        this.lens = Lens.FIVE;
        this.magnificationChanger = MagnificationChanger.ONE_ZERO;
        this.binning = Binning.ONE;
        this.incubation.reset();
    }

    public void addChannel(Channel channel) {
        this.channels.add(channel);
    }

    public Channel getChannel(String name) {
        for (Channel channel : this.channels) {
            if (!channel.name.equals(name)) continue;
            return channel;
        }
        return null;
    }

    public void clearChannels() {
        this.channels.clear();
    }

    public void addPosition(Position position) {
        this.positions.add(position);
    }

    public Position getPosition(String name) {
        for (Position position : this.positions) {
            if (!position.name.equals(name)) continue;
            return position;
        }
        return null;
    }

    public void clearPositions() {
        this.positions.clear();
    }

    public double getTemperature() {
        return this.incubation.temperature;
    }

    public void setTemperature(double temperature) {
        this.incubation.setTemperature(temperature);
    }

    public double getCO2Concentration() {
        return this.incubation.co2Concentration;
    }

    public void setCO2Concentration(double co2Concentration) {
        this.incubation.setCO2Concentration(co2Concentration);
    }

    public Lens getLens() {
        return this.lens;
    }

    public void setLens(Lens lens) {
        this.lens = lens;
    }

    public MagnificationChanger getMagnificationChanger() {
        return this.magnificationChanger;
    }

    public void setMagnificationChanger(MagnificationChanger mag) {
        this.magnificationChanger = mag;
    }

    public Binning getBinning() {
        return this.binning;
    }

    public void setBinning(Binning binning) {
        this.binning = binning;
    }

    public void acquire(String[] positionNames, String[] channelNames, double dz) {
        Channel[] channels = channelNames.length > 0 && channelNames[0].equals(ALL_CHANNELS) ? this.channels.toArray(new Channel[0]) : (Channel[])Arrays.stream(channelNames).map(this::getChannel).toArray(Channel[]::new);
        Position[] positions = positionNames.length > 0 && positionNames[0].equals(ALL_POSITIONS) ? this.positions.toArray(new Position[0]) : (Position[])Arrays.stream(positionNames).map(this::getPosition).toArray(Position[]::new);
        this.acquirePositionsAndChannels(positions, channels, dz);
    }

    public void acquirePositionsAndChannels(Position[] positions, Channel[] channels, double dz) {
        for (Position position : positions) {
            for (Channel channel : channels) {
                this.acquireSinglePositionAndChannel(position, channel);
            }
        }
    }

    public void acquireSinglePositionAndChannel(Position position, Channel channel) {
        this.fireAcquire(position, channel);
    }

    public static enum Lens {
        FIVE(5.0f, "5x"),
        TWENTY(20.0f, "20x");

        public final float magnification;
        public final String label;

        private Lens(float magnification, String label) {
            this.magnification = magnification;
            this.label = label;
        }

        public String toString() {
            return this.label;
        }
    }

    public static enum MagnificationChanger {
        ZERO_FIVE(0.5f, "0.5x"),
        ONE_ZERO(1.0f, "1.0x"),
        TWO_ZERO(2.0f, "2.0x");

        public final float magnification;
        public final String label;

        private MagnificationChanger(float magnification, String label) {
            this.magnification = magnification;
            this.label = label;
        }

        public String toString() {
            return this.label;
        }
    }

    public static enum Binning {
        ONE(1, "1x1"),
        TWO(2, "2x2"),
        THREE(3, "3x3"),
        FOUR(4, "4x4"),
        FIVE(5, "5x5");

        public final int binning;
        public final String label;

        private Binning(int binning, String label) {
            this.binning = binning;
            this.label = label;
        }

        public String toString() {
            return this.label;
        }
    }

    public static class Incubation {
        private double temperature = 20.0;
        private double co2Concentration = 0.0;

        public void setTemperature(double temperature) {
            this.temperature = temperature;
        }

        public void setCO2Concentration(double co2Concentration) {
            this.co2Concentration = co2Concentration;
        }

        public void reset() {
            this.temperature = 20.0;
            this.co2Concentration = 0.0;
        }
    }

    public static interface AcquisiitonListener {
        public void acquire(Position var1, Channel var2);
    }

    public static class Position {
        public final String name;
        public final Tuple3D center;
        public final Tuple3D extent;

        public Position(String name, Double[] center, Double[] extent) {
            this.name = name;
            this.center = new Tuple3D(center);
            this.extent = new Tuple3D(extent);
        }

        public String toString() {
            return this.name + " " + this.center;
        }
    }

    public static class Channel {
        public final String name;
        private final List<LEDSetting> ledSettings;
        private int exposureTime;

        public Channel(String name, LEDSetting first, LEDSetting[] remaining, int exposureTime) {
            this.name = name;
            this.ledSettings = new ArrayList<LEDSetting>();
            this.ledSettings.add(first);
            this.ledSettings.addAll(Arrays.asList(remaining));
            this.exposureTime = exposureTime;
        }

        public LEDSetting getLEDSetting(LED led) {
            for (LEDSetting ledSetting : this.ledSettings) {
                if (ledSetting.led != led) continue;
                return ledSetting;
            }
            return null;
        }

        public int getExposureTime() {
            return this.exposureTime;
        }

        public void setExposureTime(int exposureTime) {
            this.exposureTime = exposureTime;
        }
    }

    public static class Tuple3D {
        public final double x;
        public final double y;
        public final double z;

        public Tuple3D(Double[] t) {
            this.x = t[0];
            this.y = t[1];
            this.z = t[2];
        }

        public String toString() {
            return "(" + this.x + ", " + this.y + ", " + this.z + ")";
        }
    }

    public static class LEDSetting {
        private final LED led;
        private int intensity;

        public LEDSetting(LED led, int intensity) {
            this.led = led;
            this.intensity = intensity;
        }

        public void setIntensity(int intensity) {
            this.intensity = intensity;
        }

        public int getIntensity() {
            return this.intensity;
        }
    }

    public static enum LED {
        LED_385(385),
        LED_470(470),
        LED_567(567),
        LED_625(625);

        public final int WAVELENGTH;

        private LED(int wl) {
            this.WAVELENGTH = wl;
        }
    }
}

