/*
 * Decompiled with CFR 0.152.
 */
package nlScript.mic;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.TreeMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;

public class Timeline<E> {
    private final TreeMap<LocalDateTime, ArrayList<E>> timeline = new TreeMap();
    private final AtomicBoolean stop = new AtomicBoolean(false);
    private ExecutorService executor;

    public void put(LocalDateTime time, E entry) {
        ArrayList list = this.timeline.computeIfAbsent(time, k -> new ArrayList());
        list.add(entry);
    }

    public void runAndRemoveEntriesBefore(LocalDateTime time, Consumer<E> function) {
        ArrayList<LocalDateTime> timesToRemove = new ArrayList<LocalDateTime>();
        for (LocalDateTime entryTime : this.timeline.keySet()) {
            if (!entryTime.isBefore(time)) break;
            timesToRemove.add(entryTime);
            for (E entry : this.timeline.get(entryTime)) {
                function.accept(entry);
            }
        }
        timesToRemove.forEach(this.timeline.keySet()::remove);
    }

    public void process(Consumer<E> function) {
        this.stop.set(false);
        this.executor = Executors.newSingleThreadExecutor();
        this.executor.submit(() -> {
            while (!this.stop.get() && !this.timeline.isEmpty()) {
                this.runAndRemoveEntriesBefore(LocalDateTime.now(), function);
                if (!this.timeline.isEmpty()) continue;
                return;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        });
    }

    public void waitForProcessing() {
        this.executor.shutdown();
        try {
            this.executor.awaitTermination(1L, TimeUnit.HOURS);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void cancel() {
        this.stop.set(true);
        this.waitForProcessing();
    }

    public void clear() {
        this.timeline.clear();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (LocalDateTime t : this.timeline.keySet()) {
            ArrayList<E> entries = this.timeline.get(t);
            sb.append(t).append(" -> ").append(entries);
        }
        return sb.toString();
    }
}

