/*
 * Decompiled with CFR 0.152.
 */
package nlScript.ui;

import java.awt.Component;
import java.awt.Font;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.MouseListener;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JWindow;
import nlScript.core.Autocompletion;
import nlScript.ui.ACListModel;

public class ACPopup
extends JWindow {
    private final ACListModel model;
    private final JList<Autocompletion> jList = new JList();
    private static final int VERTICAL_SPACE = 1;

    public ACPopup(Window parent) {
        super(parent);
        this.model = new ACListModel();
        this.jList.setModel(this.model);
        this.jList.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                String text = ((Autocompletion)value).getCompletion(Autocompletion.Purpose.FOR_MENU);
                if (text.contains("${")) {
                    text = "<html>" + text.replaceAll("\\Q${\\E", "<b>").replaceAll("\\Q}\\E", "</b>") + "</html>";
                }
                if (text.startsWith("\n")) {
                    text = "<new line>";
                }
                if (text.equals("")) {
                    text = "<empty>";
                }
                JLabel label = (JLabel)super.getListCellRendererComponent(list, text, index, isSelected, cellHasFocus);
                Font font = label.getFont();
                font = font.deriveFont(0);
                label.setFont(font);
                return label;
            }
        });
        JScrollPane scrollPane = new JScrollPane(this.jList);
        scrollPane.setHorizontalScrollBarPolicy(32);
        scrollPane.setVerticalScrollBarPolicy(22);
        this.getContentPane().add(scrollPane);
        this.setLocation(200, 200);
        this.setSize(350, 250);
        this.setFocusableWindowState(false);
    }

    public void addMouseListenerToList(MouseListener l) {
        this.jList.addMouseListener(l);
    }

    public void removeMouseListenerFromList(MouseListener l) {
        this.jList.removeMouseListener(l);
    }

    public Autocompletion getSelected() {
        return this.jList.getSelectedValue();
    }

    public void setSelectedIndex(int idx) {
        this.jList.setSelectedIndex(idx);
    }

    public ACListModel getModel() {
        return this.model;
    }

    public void next() {
        int selectedIdx = (this.jList.getSelectedIndex() + 1) % this.model.getSize();
        this.jList.setSelectedIndex(selectedIdx);
    }

    public void previous() {
        int selectedIdx = (this.jList.getSelectedIndex() - 1 + this.model.getSize()) % this.model.getSize();
        this.jList.setSelectedIndex(selectedIdx);
    }

    public void setLocationRelativeTo(Rectangle r) {
        int x;
        Rectangle screenBounds = ACPopup.getScreenBoundsForPoint(r.x, r.y);
        int y = r.y + r.height + 1;
        int totalH = this.getHeight();
        if (y + totalH > screenBounds.height) {
            y = r.y - 1 - this.getHeight();
        }
        if ((x = r.x) < screenBounds.x) {
            x = screenBounds.x;
        } else if (x + this.getWidth() > screenBounds.x + screenBounds.width) {
            x = screenBounds.x + screenBounds.width - this.getWidth();
        }
        this.setLocation(x, y);
    }

    private static Rectangle getScreenBoundsForPoint(int x, int y) {
        GraphicsDevice[] devices;
        GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
        for (GraphicsDevice device : devices = env.getScreenDevices()) {
            GraphicsConfiguration config = device.getDefaultConfiguration();
            Rectangle gcBounds = config.getBounds();
            if (!gcBounds.contains(x, y)) continue;
            return gcBounds;
        }
        return env.getMaximumWindowBounds();
    }

    private String escapeHTML(String html) {
        return html.replace("&", "&amp;").replace("\\", "&#39;").replace("\"", "&quot;").replace("<", "&lt;").replace(">", "&gt;");
    }
}

